<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2019 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){var c=[""],e=[256],f=["","t"],p=["","id"],aa=["","vid"],ba=["","type"],r={flags:3089},t=["","width"],u=["","height"],ca=/embed\\/(\\d+)/,da=["","track_id"],v=[[/(?:)/,c]],ea=["","video_id"],fa=["","album_id"],ha=["","user","id"],ia=["","episode_id"],ja=["","playlist_id"],ka=["","oid","vid","hash"],la=["","channel","clip_id"],ma=["","athlete","highlight"],na=["","account_id","event_id"],w={d:[],r:!1},oa=[[/globalnews\\.ca\\/video\\/(\\d+)/,p]],pa=[/hudl\\.com\\/video\\/(\\w+)(?![\\w\\/])/,p],qa=[/flickr\\.com\\/photos\\/[^\\/]+\\/(\\d+)/,
p],ra=[[/247sports\\.com\\/PlayerSport\\/[-\\w]*(\\d+)\\/Embed/,["","player_id"]]],sa=[/hudl\\.com\\/video\\/\\d+\\/(\\d+)\\/([\\da-f]+)/,ma],ta=[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],D=[function(a,b){var d={},g;for(g in b.b){var n=b.b[g],h=!1;if(g in a.b){h=n.d;var k=g,q=a.b[g];z.k=k;for(var l=0;l<h.length&&(q=h[l](q,k),!1!==q);++l);delete z.k;h=q}!1!==h?d[g]=h:"undefined"!==typeof n.x?d[g]=n.x:n.r&&B(a)}C(a,d)}],ua={d:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?
3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],r:!1},va={x:640,d:ta,r:!1},wa={x:360,d:ta,r:!1},E={e:e,b:{id:w},h:1,d:D,f:10,j:r,g:5E3},xa={e:e,b:{id:w,user:w},h:1,d:D,f:10,j:r,g:5E3},ya={e:e,b:{height:wa,id:w,width:va},h:1,d:D,f:10,j:r,g:5E3},za=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:param$tAMAZON_ASSOCIATE_TAG"/><xsl:param$tAMAZON_ASSOCIATE_TAG_CA"/><xsl:param$tAMAZON_ASSOCIATE_TAG_DE"/><xsl:param$tAMAZON_ASSOCIATE_TAG_ES"/><xsl:param$tAMAZON_ASSOCIATE_TAG_FR"/><xsl:param$tAMAZON_ASSOCIATE_TAG_IN"/><xsl:param$tAMAZON_ASSOCIATE_TAG_IT"/><xsl:param$tAMAZON_ASSOCIATE_TAG_JP"/><xsl:param$tAMAZON_ASSOCIATE_TAG_UK"/>$fABCNEWS"><$n$eabcnews"$g$c640px"><$n$g$a56.25%">$d$m//abcnews.go.com/video/embed?id={@id}"$g$b/></$n></$n>$h$fAMAZON"><$n$eamazon"$g$c120px"><$n$g$a200%">$d$gbackground:url(https://www.amazon.com/favicon.ico) center no-repeat;$b><$l$tsrc">//ws-<$u><$s$q@tld=\\\'jp\\\'">fe</$s><$s$q@tld and contains(\\\'desfrinituk\\\',@tld)">eu</$s><$r>na</$r></$u>.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=<$u><$s$q@tld=\\\'ca\\\'">15&amp;t=$i$AMAZON_ASSOCIATE_TAG_CA"/></$s><$s$q@tld=\\\'de\\\'">3&amp;t=$i$AMAZON_ASSOCIATE_TAG_DE"/></$s><$s$q@tld=\\\'es\\\'">30&amp;t=$i$AMAZON_ASSOCIATE_TAG_ES"/></$s><$s$q@tld=\\\'fr\\\'">8&amp;t=$i$AMAZON_ASSOCIATE_TAG_FR"/></$s><$s$q@tld=\\\'in\\\'">31&amp;t=$i$AMAZON_ASSOCIATE_TAG_IN"/></$s><$s$q@tld=\\\'it\\\'">29&amp;t=$i$AMAZON_ASSOCIATE_TAG_IT"/></$s><$s$q@tld=\\\'jp\\\'">9&amp;t=$i$AMAZON_ASSOCIATE_TAG_JP"/></$s><$s$q@tld=\\\'uk\\\'">2&amp;t=$i$AMAZON_ASSOCIATE_TAG_UK"/></$s><$r>1&amp;t=$i$AMAZON_ASSOCIATE_TAG"/></$r></$u>&amp;asins=$i@id"/></$l></$x></$n></$n>$h$fANCHOR"><$x$eanchor"$k"$pno"$m//anchor.fm/embed/episodes/x-{@id}"$gborder:0;height:102px;max-width:700px;width:100%"/>$h$fAUDIOBOOM"><$x$eaudioboom"$k"$pno"$m//audioboom.com/posts/{@id}/embed/v3"$gborder:0;height:150px;max-width:700px;width:100%"/>$h$fAUDIOMACK"><$x$eaudiomack"$k"$pno"><$u><$s$q@mode=\\\'album\\\'"><$l$tsrc">https://www.audiomack.com/embed/album/$i@id"/></$l><$l$t$y>border:0;height:400px;max-width:900px;width:100%</$l></$s><$r><$l$tsrc">https://www.audiomack.com/embed/song/$i@id"/></$l><$l$t$y>border:0;height:252px;max-width:900px;width:100%</$l></$r></$u></$x>$h$fBANDCAMP"><$n$ebandcamp"$g$c400px"><$n$g$a100%">$d$g$b><$l$tsrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$u><$s$q@album_id">album=$i@album_id"/><xsl:if$q@track_num">/t=$i@track_num"/></xsl:if></$s><$r>track=$i@track_id"/></$r></$u></$l></$x></$n></$n>$h$fBBCNEWS"><$n$ebbcnews"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//www.bbc.com<$u><$s$qstarts-with(@id,\\\'av/\\\')">/news/$i@id"/>/embed</$s><$s$qstarts-with(@playlist,\\\'/news/\\\')and contains(@playlist,\\\'A\\\')">$isubstring-before(@playlist,\\\'A\\\')"/>/embed</$s><$r>/news/av/embed/$i@id"/></$r></$u></$l></$x></$n></$n>$h$fBITCHUTE"><$n$ebitchute"$g$c640px"><$n$g$a56.25%">$d$mhttps://www.bitchute.com/embed/{@id}/"$g$b/></$n></$n>$h$fBLEACHERREPORT"><$n$ebleacherreport"$g$c320px"><$n$g$a100%">$d$m//bleacherreport.com/video_embed?id={@id}&amp;library=video-cms"$g$b/></$n></$n>$h$fBREAK"><$n$ebreak"$g$c464px"><$n$g$a60.344828%">$d$m//break.com/embed/{@id}"$g$b/></$n></$n>$h$fBRIGHTCOVE"><$n$ebrightcove"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">https://<$u><$s$q@bckey">link.brightcove.com/services/player/bcpid$i@bcpid"/>?bckey=$i@bckey"/>&amp;bctid=$i@bctid"/>&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640</$s><$r>players.brightcove.net/$i@bcpid"/>/default_default/index.html?videoId=$i@bctid"/></$r></$u></$l></$x></$n></$n>$h$fCBSNEWS"><$n$ecbsnews"$g$c640px"><$n><$u><$s$qcontains(@id,\\\'-\\\')"><$l$t$y>$a56.25%</$l>$d$mhttps://www.cbsnews.com/embed/videos/{@id}/"$g$b/></$s><$s$q@pid"><$l$t$y>$a62.1875%;padding-bottom:calc(56.25% + 38px)</$l><object data="//www.cbsnews.com/common/video/cbsnews_player.swf"$g$v type="$z typemustmatch="">$w<param$tflashvars" value="pType=embed&amp;si=254&amp;pid={@pid}"/></object></$s><$r><$l$t$y>$a62.5%;padding-bottom:calc(56.25% + 40px)</$l><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf"$g$v type="$z typemustmatch="">$w<param$tflashvars" value="si=254&amp;contentValue={@id}"/></object></$r></$u></$n></$n>$h$fCNBC"><$n$ecnbc"$g$c640px"><$n$g$a56.25%">$d$mhttps://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid={@id}&amp;size=640_360"$g$b/></$n></$n>$h$fCNN"><$n$ecnn"$g$c640px"><$n$g$a56.25%">$d$m//fave.api.cnn.io/v1/fav/?video={@id}&amp;customer=cnn&amp;edition=international&amp;env=prod"$g$b/></$n></$n>$h$fCNNMONEY"><$n$ecnnmoney"$g$c560px"><$n$g$a64.285714%">$d$m//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&amp;width=560&amp;height=360"$g$b/></$n></$n>$h$fCOLLEGEHUMOR"><$n$ecollegehumor"$g$c600px"><$n$g$a61.5%">$d$m//www.collegehumor.com/e/{@id}"$g$b/></$n></$n>$h$fCOMEDYCENTRAL"><$n$ecomedycentral"$g$c640px"><$n$g$a56.25%">$d$m//media.mtvnservices.com/embed/{@id}"$g$b/></$n></$n>$h$fCOUB"><$n$ecoub"$g$c640px"><$n$g$a56.25%">$d$m//coub.com/embed/{@id}"$g$b/></$n></$n>$h$fDAILYMOTION"><$n$edailymotion"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//www.dailymotion.com/embed/video/$i@id"/><xsl:if$q@t">?start=$i@t"/></xsl:if></$l></$x></$n></$n>$h$fDEMOCRACYNOW"><$n$edemocracynow"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//www.democracynow.org/embed/<$u><$s$qcontains(@id,\\\'/headlines\\\')">headlines/$isubstring-before(@id,\\\'/headlines\\\')"/></$s><$s$qstarts-with(@id,\\\'2\\\')">story/$i@id"/></$s><$s$qstarts-with(@id,\\\'shows/\\\')">show/$isubstring-after(@id,\\\'/\\\')"/></$s><$r>$i@id"/></$r></$u></$l></$x></$n></$n>$h$fDUMPERT"><$n$edumpert"$g$c640px"><$n$g$a56.25%">$d$m//www.dumpert.nl/embed/{translate(@id,\\\'_\\\',\\\'/\\\')}/"$g$b/></$n></$n>$h$fEIGHTTRACKS"><$n$eeighttracks"$g$c400px"><$n$g$a100%">$d$m//8tracks.com/mixes/{@id}/player_v3_universal"$g$b/></$n></$n>$h$fESPN"><$n$eespn"$g$c640px"><$n$g$a56.25%">$d$m//www.espn.com/core/video/$x?id={@id}"$g$b/></$n></$n>$h$fFACEBOOK"><$x$efacebook"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/facebook.min.html#{@type}{@id}"$gborder:0;height:360px;max-width:640px;width:100%"/>$h$fFLICKR"><$n$eflickr"$g$c500px"><$n$g$a100%">$d$mhttps://www.flickr.com/photos/_/{@id}/player/"$g$b/></$n></$n>$h$fFOXNEWS"><$n$efoxnews"$g$c640px"><$n$g$a56.25%">$d$m//video.foxnews.com/v/video-embed.html?video_id={@id}"$g$b/></$n></$n>$h$fFOXSPORTS"><$n$efoxsports"$g$c640px"><$n$g$a56.25%">$d$m//player.foxfdm.com/sports/embed-$x.html?videourl=http://link.theplatform.com/s/BKQ29B/{@id}?mbr=true&amp;assetTypes=Video&amp;feed=Fox%20Sports%20All&amp;autoplay=false&amp;policy=68249219&amp;sdk=PDK%205.7.15"$g$b/></$n></$n>$h$fFUNNYORDIE"><$n$efunnyordie"$g$c640px"><$n$g$a56.25%">$d$m//www.funnyordie.com/embed/{@id}"$g$b/></$n></$n>$h$fGAMESPOT"><$n$egamespot"$g$c640px"><$n$g$a56.25%">$d$m//www.gamespot.com/videos/embed/{@id}/"$g$b/></$n></$n>$h$fGAMETRAILERS"><$n$egametrailers"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//<$u><$s$qstarts-with(@id,\\\'mgid:\\\')">media.mtvnservices.com/embed/$i@id"/></$s><$r>embed.gametrailers.com/embed/$i@id"/>?embed=1&amp;suppressBumper=1</$r></$u></$l></$x></$n></$n>$h$fGETTY"><$n$egetty"$g$c{@width}px"><$n><$l$t$y>display:block;overflow:hidden;position:relative;<xsl:if$q@width&gt;0">padding-bottom:$i100*@height div@width"/>%</xsl:if></$l>$d$m//embed.gettyimages.com/embed/{@id}?et={@et}&amp;tld=com&amp;sig={@sig}&amp;caption=false&amp;ver=1"$g$b/></$n></$n>$h$fGFYCAT"><$n$egfycat"$g$c{@width}px"><$n><$l$t$y>display:block;overflow:hidden;position:relative;<xsl:if$q@width&gt;0">padding-bottom:$i100*(@height+44)div@width"/>%;padding-bottom:calc($i100*@height div@width"/>% + 44px)</xsl:if></$l>$d$m//gfycat.com/ifr/{@id}"$g$b/></$n></$n>$h$fGIFS"><$n$egifs"$g$c{@width}px"><$n><$l$t$y>display:block;overflow:hidden;position:relative;<xsl:if$q@width&gt;0">padding-bottom:$i100*@height div@width"/>%</xsl:if></$l>$d$m//gifs.com/embed/{@id}"$g$b/></$n></$n>$h$fGIST"><$x$egist"$k"$o$y onload="$j$p"$mhttps://s9e.github.io/$x/2/gist.min.html#{@id}"$gborder:0;height:180px;width:100%"/>$h$fGLOBALNEWS"><$n$eglobalnews"$g$c640px"><$n$g$a56.25%">$d$m//globalnews.ca/video/embed/{@id}/"$g$b/></$n></$n>$h$fGOFUNDME"><$n$egofundme"$g$c349px"><$n$g$a118.911175%;padding-bottom:calc(59.312321% + 208px)">$d$m//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund={@id}&amp;image=1&amp;coinfo=1"$g$b/></$n></$n>$h$fGOOGLEDRIVE"><$n$egoogledrive"$g$c640px"><$n$g$a75%">$d$m//drive.google.com/file/d/{@id}/preview"$g$b/></$n></$n>$h$fGOOGLEPLUS"><$x$egoogleplus"$k"$o$y onload="$j$pno"$gborder:0;height:240px;max-width:450px;width:100%"><$l$tsrc">https://s9e.github.io/$x/2/googleplus.min.html#<$u><$s$q@oid">$i@oid"/></$s><$r>+$i@name"/></$r></$u>/posts/$i@pid"/></$l></$x>$h$fGOOGLESHEETS"><$u><$s$q@type=\\\'chart\\\'"><$n$egooglesheets"$g$c600px"><$n$g$a62%">$d$mhttps://docs.google.com/spreadsheets/d/{@id}/pubchart?oid={@oid}&amp;format=interactive"$g$b/></$n></$n></$s><$r><$x$egooglesheets"$k"$pno"$gborder:0;height:500px;resize:vertical;width:100%"><$l$tsrc">https://docs.google.com/spreadsheets/d/$i@id"/>/p<$u><$s$qstarts-with(@id,\\\'e/\\\')">ubhtml?widget=true&amp;headers=false</$s><$r>review</$r></$u>#gid=$i@gid"/></$l></$x></$r></$u>$h$fHUDL"><$n$ehudl"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//www.hudl.com/embed/<$u><$s$q@id">video/$i@id"/></$s><$r>athlete/$i@athlete"/>/highlights/$i@highlight"/></$r></$u></$l></$x></$n></$n>$h$fHULU"><$n$ehulu"$g$c640px"><$n$g$a56.25%">$d$mhttps://secure.hulu.com/embed/{@id}"$g$b/></$n></$n>$h$fIGN"><$n$eign"$g$c468px"><$n$g$a56.196581%">$d$m//widgets.ign.com/video/embed/content.html?url={@id}"$g$b/></$n></$n>$h$fIMDB"><$n$eimdb"$g$c640px"><$n$g$a56.25%">$d$m//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&amp;width=640"$g$b/></$n></$n>$h$fIMGUR"><$x$eimgur"$k"$o$y onload="var c=new MessageChannel;c.port1.onmessage=function(e){{var d=e.data.split(\\\' \\\');style.height=d[0]+\\\'px\\\';style.width=d[1]+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$pno"$gborder:0;height:400px;max-width:100%;width:542px"><$l$tsrc">https://s9e.github.io/$x/2/imgur.min.html#<xsl:if$q@type=\\\'album\\\'">a/</xsl:if>$i@id"/></$l></$x>$h$fINDIEGOGO"><$n$eindiegogo"$g$c222px"><$n$g$a200.45045%">$d$m//www.indiegogo.com/project/{@id}/embedded"$g$b/></$n></$n>$h$fINSTAGRAM"><$x$einstagram"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/instagram.min.html#{@id}"$gbackground:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"/>$h$fINTERNETARCHIVE"><$u><$s$qcontains(@id,\\\'playlist=1\\\')"><$x$einternetarchive"$k"$pno"$mhttps://archive.org/embed/{@id}&amp;list_height=150"$gborder:0;height:170px;max-width:640px;width:100%"/></$s><$r><$n$einternetarchive"$g$c{@width}px"><$n><$l$t$y>display:block;overflow:hidden;position:relative;<xsl:if$q@width&gt;0">padding-bottom:$i100*@height div@width"/>%</xsl:if></$l>$d$mhttps://archive.org/embed/{@id}"$g$b/></$n></$n></$r></$u>$h$fIZLESENE"><$n$eizlesene"$g$c640px"><$n$g$a56.25%">$d$m//www.izlesene.com/embedplayer/{@id}?autoplay=0"$g$b/></$n></$n>$h$fJWPLATFORM"><$n$ejwplatform"$g$c640px"><$n$g$a56.25%">$d$m//content.jwplatform.com/players/{@id}.html"$g$b/></$n></$n>$h$fKHL"><$n$ekhl"$g$c640px"><$n$g$a56.25%">$d$m//video.khl.ru/$x/feed/start/{@id}?type_id=18&amp;width=560&amp;height=315"$g$b/></$n></$n>$h$fKICKSTARTER"><$n$ekickstarter"><$u><$s$q@video"><$l$t$y>$c640px</$l><$n$g$a56.25%">$d$m//www.kickstarter.com/projects/{@id}/widget/video.html"$g$b/></$n></$s><$r><$l$t$y>$c220px</$l><$n$g$a190.909091%">$d$m//www.kickstarter.com/projects/{@id}/widget/card.html"$g$b/></$n></$r></$u></$n>$h$fLIBSYN"><$x$elibsyn"$k"$pno"$m//html5-player.libsyn.com/embed/episode/id/{@id}/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/"$gborder:0;height:45px;max-width:900px;width:100%"/>$h$fLIVELEAK"><$n$eliveleak"$g$c640px"><$n$g$a56.25%">$d$m//www.liveleak.com/e/{@id}"$g$b/></$n></$n>$h$fLIVESTREAM"><$n$elivestream"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//<$u><$s$q@clip_id">cdn.livestream.com/embed/$i@channel"/>?layout=4&amp;autoplay=false&amp;clip=$i@clip_id"/></$s><$r>livestream.com/accounts/$i@account_id"/>/events/$i@event_id"/><xsl:if$q@video_id">/videos/$i@video_id"/></xsl:if>/player?autoPlay=false</$r></$u></$l></$x></$n></$n>$h$fMAILRU"><$n$emailru"$g$c640px"><$n$g$a56.25%">$d$mhttps://my.mail.ru/video/embed/{@id}"$g$b/></$n></$n>$h$fMEDIUM"><$x$emedium"$k"$pno"$mhttps://api.medium.com/embed?type=story&amp;path=%2F%2F{@id}"$gborder:1px solid;border-color:#eee #ddd #bbb;border-radius:5px;box-shadow:rgba(0,0,0,.15) 0 1px 3px;height:313px;max-width:900px;width:100%"/>$h$fMEGAPHONE"><$x$emegaphone"$k"$pno"$mhttps://player.megaphone.fm/{@id}"$gborder:0;height:200px;max-width:900px;width:100%"/>$h$fMETACAFE"><$n$emetacafe"$g$c640px"><$n$g$a56.25%">$d$m//www.metacafe.com/embed/{@id}/"$g$b/></$n></$n>$h$fMIXCLOUD"><$n$emixcloud"$g$c400px"><$n$g$a100%">$d$m//www.mixcloud.com/widget/$x/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&amp;embed_type=widget_standard"$g$b/></$n></$n>$h$fMIXER"><$n$emixer"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">https://mixer.com/embed/player/$i@channel"/><xsl:if$q@vod">?vod=$i@vod"/></xsl:if></$l></$x></$n></$n>$h$fMLB"><$n$emlb"$g$c640px"><$n$g$a56.25%">$d$mhttps://www.mlb.com/video/share/c-{@id}"$g$b/></$n></$n>$h$fMRCTV"><$n$emrctv"$g$c640px"><$n$g$a56.25%">$d$mhttps://www.mrctv.org/embed/{@id}"$g$b/></$n></$n>$h$fMSNBC"><$n$emsnbc"$g$c640px"><$n><$u><$s$qcontains(@id,\\\'_\\\')"><$l$t$y>$a68.75%;padding-bottom:calc(56.25% + 80px)</$l>$d$m//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid={@id}"$g$b/></$s><$r><$l$t$y>$a56.25%</$l>$d$mhttps://www.msnbc.com/msnbc/embedded-video/{@id}"$g$b/></$r></$u></$n></$n>$h$fNATGEOCHANNEL"><$n$enatgeochannel"$g$c640px"><$n$g$a56.25%">$d$m//channel.nationalgeographic.com/{@id}/embed/"$g$b/></$n></$n>$h$fNATGEOVIDEO"><$n$enatgeovideo"$g$c640px"><$n$g$a56.25%">$d$m//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}"$g$b/></$n></$n>$h$fNBCNEWS"><$n$enbcnews"$g$c640px"><$n$g$a56.25%">$d$m//www.nbcnews.com/widget/video-embed/{@id}"$g$b/></$n></$n>$h$fNBCSPORTS"><$n$enbcsports"$g$c640px"><$n$g$a56.25%">$d$m//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl="$g$b/></$n></$n>$h$fNHL"><$n$enhl"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">https://www.nhl.com/video/embed<xsl:if$q@t">/t-$i@t"/></xsl:if><xsl:if$q@c">/c-$i@c"/></xsl:if>?autostart=false</$l></$x></$n></$n>$h$fNPR"><$x$enpr"$k"$pno"$m//www.npr.org/player/embed/{@i}/{@m}"$gborder:0;height:228px;max-width:800px;width:100%"/>$h$fNYTIMES"><$n$enytimes"$g$c585px"><$n$g$a68.376068%">$d$m//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}"$g$b/></$n></$n>$h$fORFIUM"><$x$eorfium"$k"$pno"><$l$tsrc">https://www.orfium.com/embedded/<$u><$s$q@album_id">album/$i@album_id"/></$s><$s$q@playlist_id">playlist/$i@playlist_id"/></$s><$s$q@set_id">live-set/$i@set_id"/></$s><$r>track/$i@track_id"/></$r></$u></$l><$l$t$y>border:0;height:<$u><$s$q@album_id">550</$s><$r>275</$r></$u>px;max-width:900px;width:100%</$l></$x>$h$fPASTEBIN"><$x$epastebin"$k"$p"$m//pastebin.com/embed_$x.php?i={@id}"$gborder:0;height:300px;resize:vertical;width:100%"/>$h$fPINTEREST"><$x$epinterest"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/pinterest.min.html#{@id}"><$l$t$y>border:0;height:360px;max-width:<$u><$s$qcontains(@id,\\\'/\\\')">730</$s><$r>345</$r></$u>px;width:100%</$l></$x>$h$fPODBEAN"><$x$epodbean"$k"$pno"$m//www.podbean.com/media/player/{@id}"$gborder:0;height:100px;max-width:900px;width:100%"/>$h$fPREZI"><$n$eprezi"$g$c550px"><$n$g$a72.727273%">$d$m//prezi.com/embed/{@id}/"$g$b/></$n></$n>$h$fREDDIT"><$x$ereddit"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/reddit.min.html#{@id}{@path}"$gborder:0;height:165px;max-width:800px;width:100%"/>$h$fRUTUBE"><$n$erutube"$g$c720px"><$n$g$a56.25%">$d$m//rutube.ru/play/embed/{@id}"$g$b/></$n></$n>$h$fSCRIBD"><$x$escribd"$k"$pno"$mhttps://www.scribd.com/embeds/{@id}/content?view_mode=scroll&amp;show_recommendations=false"$gborder:0;height:500px;resize:vertical;width:100%"/>$h$fSENDVID"><$n$esendvid"$g$c640px"><$n$g$a56.25%">$d$m//sendvid.com/embed/{@id}"$g$b/></$n></$n>$h$fSLIDESHARE"><$n$eslideshare"$g$c427px"><$n$g$a83.372365%">$d$m//www.slideshare.net/slideshow/embed_code/{@id}"$g$b/></$n></$n>$h$fSOUNDCLOUD"><$x$esoundcloud"$k"$pno"><$l$tsrc">https://w.soundcloud.com/player/?url=<$u><$s$q@playlist_id">https%3A//api.soundcloud.com/playlists/$i@playlist_id"/></$s><$s$q@track_id">https%3A//api.soundcloud.com/tracks/$i@track_id"/>&amp;secret_token=$i@secret_token"/></$s><$r><xsl:if$qnot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</xsl:if>$i@id"/></$r></$u></$l><$l$t$y>border:0;height:<$u><$s$q@playlist_id or contains(@id,\\\'/sets/\\\')">450</$s><$r>166</$r></$u>px;max-width:900px;width:100%</$l></$x>$h$fSPORCLE"><$x$esporcle"$k"$o$y onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'*\\\',[c.port2])"$pno"$mhttps://s9e.github.io/$x/2/sporcle.min.html#{@id}"$gborder:0;height:535px;max-width:820px;width:100%"/>$h$fSPORTSNET"><$n$esportsnet"$g$c640px"><$n$g$a56.25%">$d$mhttps://images.rogersdigitalmedia.com/video_service.php?videoId={@id}&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25"$g$b/></$n></$n>$h$fSPOTIFY"><$n$espotify"$g$c400px"><$n$g$a100%"><$x allow="encrypted-media"$k"$pno"$mhttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$g$b/></$n></$n>$h$fSPREAKER"><$x$espreaker"$k"$pno"$mhttps://widget.spreaker.com/player?episode_id={@episode_id}&amp;show_id={@show_id}"$gborder:0;height:{400-200*boolean(@episode_id)}px;max-width:900px;width:100%"/>$h$fSTEAMSTORE"><$x$esteamstore"$k"$pno"$m//store.steampowered.com/widget/{@id}"$gborder:0;height:190px;max-width:900px;width:100%"/>$h$fSTITCHER"><$x$estitcher"$k"$pno"$m//app.stitcher.com/splayer/f/{@fid}/{@eid}"$gborder:0;height:150px;max-width:900px;width:100%"/>$h$fSTRAWPOLL"><$n$estrawpoll"$g$c640px"><$n$g$a56.25%"><$x$k"$p"$m//www.strawpoll.me/embed_1/{@id}"$g$b/></$n></$n>$h$fSTREAMABLE"><$n$estreamable"$g$c640px"><$n$g$a56.25%">$d$m//streamable.com/e/{@id}"$g$b/></$n></$n>$h$fSTREAMJA"><$n$estreamja"$g$c640px"><$n$g$a56.25%">$d$mhttps://streamja.com/embed/{@id}"$g$b/></$n></$n>$h$fTEAMCOCO"><$n$eteamcoco"$g$c640px"><$n$g$a56.25%">$d$m//teamcoco.com/embed/v/{@id}"$g$b/></$n></$n>$h$fTED"><$n$eted"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//embed.ted.com/$i@id"/><xsl:if$qnot(contains(@id,\\\'.html\\\'))">.html</xsl:if></$l></$x></$n></$n>$h$fTELEGRAM"><$x$etelegram"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/telegram.min.html#{@id}"$gborder:0;height:96px;max-width:500px;width:100%"/>$h$fTHEATLANTIC"><$n$etheatlantic"$g$c640px"><$n$g$a56.25%">$d$m//www.theatlantic.com/video/$x/{@id}/"$g$b/></$n></$n>$h$fTHEGUARDIAN"><$n$etheguardian"$g$c640px"><$n$g$a56.25%">$d$m//embed.theguardian.com/embed/video/{@id}"$g$b/></$n></$n>$h$fTHEONION"><$n$etheonion"$g$c640px"><$n$g$a56.25%">$d$m//www.theonion.com/video_embed/?id={@id}"$g$b/></$n></$n>$h$fTIKTOK"><$n$etiktok"$g$c340px"><$n$g$a205.882353%">$d$m//www.tiktok.com/embed/{@id}"$g$b/></$n></$n>$h$fTMZ"><$n$etmz"$g$c640px"><$n$g$a56.25%">$d$m//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}"$g$b/></$n></$n>$h$fTRAILERADDICT"><$n$etraileraddict"$g$c640px"><$n$g$a56.25%">$d$m//v.traileraddict.com/{@id}"$g$b/></$n></$n>$h$fTRENDINGVIEWS"><$n$etrendingviews"$g$c640px"><$n$g$a56.25%">$d$mhttps://trendingviews.co/embed/{@id}"$g$b/></$n></$n>$h$fTUMBLR"><$x$etumblr"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/tumblr.min.html#{@key}/{@id}"$gborder:0;height:300px;max-width:520px;width:100%"/>$h$fTWENTYFOURSEVENSPORTS"><$u><$s$q@video_id"><$n$etwentyfoursevensports"$g$c640px"><$n$g$a56.25%">$d$mhttps://www.cbssports.com/video/player/embed?args=player_id%3D{@video_id}%26channel%3Dmobilevideo%26pcid%3D{@video_id}%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue"$g$b/></$n></$n></$s><$r><$x$etwentyfoursevensports"$k" onload="window.addEventListener(\\\'message\\\',function(e){{if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\\\'px\\\'}})"$pno"$mhttps://247sports.com/PlayerSport/{@player_id}/Embed/"$gborder:0;height:200px;max-width:600px;width:100%"/></$r></$u>$h$fTWITCH"><$n$etwitch"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//<$u><$s$q@clip_id">clips.twitch.tv/embed?autoplay=false&amp;clip=<xsl:if$q@channel">$i@channel"/>/</xsl:if>$i@clip_id"/></$s><$r>player.twitch.tv/?autoplay=false&amp;<$u><$s$q@video_id">video=v$i@video_id"/></$s><$r>channel=$i@channel"/></$r></$u><xsl:if$q@t">&amp;time=$i@t"/></xsl:if></$r></$u></$l></$x></$n></$n>$h$fTWITTER"><$x$etwitter" allow="autoplay *"$k"$o$y onload="$j$pno"$mhttps://s9e.github.io/$x/2/twitter.min.html#{@id}"$gbackground:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:250px;max-width:500px;width:100%"/>$h$fUSTREAM"><$n$eustream"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//www.ustream.tv/embed/<$u><$s$q@vid">recorded/$i@vid"/></$s><$r>$i@cid"/></$r></$u>?html5ui</$l></$x></$n></$n>$h$fVBOX7"><$n$evbox7"$g$c640px"><$n$g$a56.25%">$d$m//vbox7.com/emb/external.php?vid={@id}"$g$b/></$n></$n>$h$fVEOH"><$n$eveoh"$g$c640px"><$n$g$a62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v{@id}&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous"$g$v type="$z typemustmatch="">$w</object></$n></$n>$h$fVEVO"><$n$evevo"$g$c640px"><$n$g$a56.25%">$d$mhttps://embed.vevo.com/?isrc={@id}"$g$b/></$n></$n>$h$fVIDEODETECTIVE"><$n$evideodetective"$g$c640px"><$n$g$a56.25%">$d$m//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid={@id}"$g$b/></$n></$n>$h$fVIMEO"><$n$evimeo"$g$c640px"><$n$g$a56.25%">$d$g$b><$l$tsrc">//player.vimeo.com/video/$i@id"/><xsl:if$q@t">#t=$i@t"/></xsl:if></$l></$x></$n></$n>$h$fVINE"><$n$evine"$g$c480px"><$n$g$a100%">$d$mhttps://vine.co/v/{@id}/embed/simple?audio=1"$g$b/></$n></$n>$h$fVK"><$n$evk"$g$c640px"><$n$g$a56.25%">$d$m//vk.com/video_ext.php?oid={@oid}&amp;id={@vid}&amp;hash={@hash}&amp;hd=1"$g$b/></$n></$n>$h$fVOCAROO"><$n$evocaroo"$g$c148px"><$n$g$a29.72973%"><object data="//vocaroo.com/player.swf?playMediaID={@id}&amp;autoplay=0"$g$v type="$z typemustmatch="">$w</object></$n></$n>$h$fVOX"><$n$evox"$g$c640px"><$n$g$a56.25%">$d$m//player.ooyala.com/$x.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec={@id}"$g$b/></$n></$n>$h$fWASHINGTONPOST"><$n$ewashingtonpost"$g$c640px"><$n$g$a56.25%">$d$m//www.washingtonpost.com/video/c/embed/{@id}"$g$b/></$n></$n>$h$fWSHH"><$n$ewshh"$g$c640px"><$n$g$a56.25%">$d$m//www.worldstarhiphop.com/embed/{@id}"$g$b/></$n></$n>$h$fWSJ"><$n$ewsj"$g$c512px"><$n$g$a56.25%">$d$m//video-api.wsj.com/api-video/player/$x.html?guid={@id}"$g$b/></$n></$n>$h$fXBOXCLIPS"><$n$exboxclips"$g$c640px"><$n$g$a56.25%">$d$m//xboxclips.com/{@user}/{@id}/embed"$g$b/></$n></$n>$h$fXBOXDVR"><$n$exboxdvr"$g$c640px"><$n$g$a56.25%">$d$m//gamerdvr.com/gamer/{@user}/video/{@id}/embed"$g$b/></$n></$n>$h$fYOUKU"><$n$eyouku"$g$c640px"><$n$g$a56.25%">$d$m//player.youku.com/embed/{@id}"$g$b/></$n></$n>$h$fYOUTUBE"><$n$eyoutube"$g$c640px"><$n$g$a56.25%">$d$gbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$b><$l$tsrc">https://www.youtube.com/embed/$i@id"/><xsl:if$q@list">?list=$i@list"/></xsl:if><xsl:if$q@t"><$u><$s$q@list">&amp;</$s><$r>?</$r></$u>start=$i@t"/></xsl:if></$l></$x></$n></$n>$h$fbr"><br/>$h$fe|i|s"/>$fp"><p><xsl:apply-templates/></p>$h</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$c:"display:inline-block;width:100%;max-width:",$d:\'<iframe allowfullscreen="" scrolling="no"\',$e:\' data-s9e-mediaembed="\',$f:\'<xsl:template match="\',$g:\' style="\',$h:"</xsl:template>",$i:\'<xsl:value-of select="\',$j:"var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\'px\'}};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])\\"",
$k:\' allowfullscreen="\',$l:"xsl:attribute",$m:\' src="\',$n:"span",$o:\' data-s9e-livepreview-ignore-attrs="\',$p:\' scrolling="\',$q:\' test="\',$r:"xsl:otherwise",$s:"xsl:when",$t:\' name="\',$u:"xsl:choose",$v:\'height:100%;left:0;position:absolute;width:100%"\',$w:\'<param name="allowfullscreen" value="true"/>\',$x:"iframe",$y:\'style"\',$z:\'application/x-shockwave-flash"\'}[a]});function Aa(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(d){return b[d]})}
function Ba(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(d){return b[d]})}function G(){this.o={};this.q=[]}G.prototype.add=function(a,b,d){d=d||{};"attrName"in d||!this.k||(d.attrName=this.k);"tag"in d||!this.l||(d.tag=this.l);this.o[a]&&this.o[a].forEach(function(g){g(b,d)});this.q.push([a,b,d])};G.prototype.getLogs=function(){return this.q};G.prototype.on=function(a,b){this.o[a].push(b)};function Ca(a,b){z.add("debug",a,b)}
function H(a,b,d,g,n){this.n=+a;this.name=b;this.k=+d;this.l=+g;this.w=+n||0;this.b={};this.y=[];isNaN(a+d+g)&&B(this)}H.prototype.o=!1;function B(a){a.o||(a.o=!0,a.y.forEach(function(b){B(b)}))}function J(a,b){a.name===b.name&&(1===a.n&&2===b.n&&b.k>=a.k?(a.s=b,b.q=a,a.y.push(b),a.o&&B(b)):2===a.n&&1===b.n&&b.k<=a.k&&(a.q=b,b.s=a))}function Da(a){var b={},d;for(d in a.b)b[d]=a.b[d];return b}
function Ea(a,b){return a.o||a.name!==b.name||1!==b.n||2!==a.n||a.k<b.k||a.q&&a.q!==b||b.s&&b.s!==a?!1:!0}function C(a,b){a.b={};for(var d in b)a.b[d]=b[d]}
var K,Fa,L,M,N,Ga,z=new G,O,P,R={MediaEmbed:{F:function(a,b){b.forEach(function(d){var g=d[0][0];Q(3,"MEDIA",d[0][1],g.length,-10).b.url=g})},A:"://",B:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,C:5E4}},S,Ha={"MediaEmbed.hosts":{"247sports.com":"twentyfoursevensports","8tracks.com":"eighttracks","abcnews.go.com":"abcnews","amazon.ca":"amazon","amazon.co.jp":"amazon","amazon.co.uk":"amazon","amazon.com":"amazon","amazon.de":"amazon","amazon.es":"amazon","amazon.fr":"amazon","amazon.in":"amazon","amazon.it":"amazon",
"anchor.fm":"anchor","archive.org":"internetarchive","audioboo.fm":"audioboom","audioboom.com":"audioboom","audiomack.com":"audiomack","bandcamp.com":"bandcamp","bbc.co.uk":"bbcnews","bbc.com":"bbcnews","bitchute.com":"bitchute","bleacherreport.com":"bleacherreport","break.com":"break","cbsnews.com":"cbsnews","cc.com":"comedycentral","channel.nationalgeographic.com":"natgeochannel","cnbc.com":"cnbc","cnn.com":"cnn","collegehumor.com":"collegehumor","comedycentral.com":"comedycentral","coub.com":"coub",
"dai.ly":"dailymotion","dailymotion.com":"dailymotion","democracynow.org":"democracynow","docs.google.com":"googlesheets","drive.google.com":"googledrive","dumpert.nl":"dumpert","espn.com":"espn","espn.go.com":"espn","facebook.com":"facebook","flic.kr":"flickr","flickr.com":"flickr","foxsports.com":"foxsports","funnyordie.com":"funnyordie","gamerdvr.com":"xboxdvr","gamespot.com":"gamespot","gametrailers.com":"gametrailers","gettyimages.be":"getty","gettyimages.cn":"getty","gettyimages.co.jp":"getty",
"gettyimages.co.uk":"getty","gettyimages.com":"getty","gettyimages.com.au":"getty","gettyimages.de":"getty","gettyimages.dk":"getty","gettyimages.es":"getty","gettyimages.fr":"getty","gettyimages.ie":"getty","gettyimages.it":"getty","gettyimages.nl":"getty","gettyimages.pt":"getty","gettyimages.se":"getty","gfycat.com":"gfycat","gifs.com":"gifs","github.com":"gist","globalnews.ca":"globalnews","gofundme.com":"gofundme","gty.im":"getty","hudl.com":"hudl","hulu.com":"hulu","ign.com":"ign","imdb.com":"imdb",
"imgur.com":"imgur","indiegogo.com":"indiegogo","instagram.com":"instagram","izlesene.com":"izlesene","jwplatform.com":"jwplatform","kickstarter.com":"kickstarter","libsyn.com":"libsyn","link.brightcove.com":"brightcove","liveleak.com":"liveleak","livestre.am":"livestream","livestream.com":"livestream","medium.com":"medium","megaphone.fm":"megaphone","megaphone.link":"megaphone","metacafe.com":"metacafe","mixcloud.com":"mixcloud","mixer.com":"mixer","mlb.com":"mlb","money.cnn.com":"cnnmoney","mrctv.org":"mrctv",
"msnbc.com":"msnbc","my.mail.ru":"mailru","n.pr":"npr","nbcnews.com":"nbcnews","nbcsports.com":"nbcsports","nhl.com":"nhl","npr.org":"npr","nytimes.com":"nytimes","open.spotify.com":"spotify","orfium.com":"orfium","pastebin.com":"pastebin","pinterest.com":"pinterest","play.spotify.com":"spotify","players.brightcove.net":"brightcove","plus.google.com":"googleplus","podbean.com":"podbean","prezi.com":"prezi","reddit.com":"reddit","rutube.ru":"rutube","scribd.com":"scribd","sendvid.com":"sendvid","slideshare.net":"slideshare",
"soundcloud.com":"soundcloud","sporcle.com":"sporcle","sportsnet.ca":"sportsnet","spreaker.com":"spreaker","stitcher.com":"stitcher","store.steampowered.com":"steamstore","strawpoll.me":"strawpoll","streamable.com":"streamable","streamja.com":"streamja","t.me":"telegram","teamcoco.com":"teamcoco","ted.com":"ted","theatlantic.com":"theatlantic","theguardian.com":"theguardian","theonion.com":"theonion","tiktok.com":"tiktok","tmz.com":"tmz","traileraddict.com":"traileraddict","trendingviews.co":"trendingviews",
"tumblr.com":"tumblr","twitch.tv":"twitch","twitter.com":"twitter","ustream.tv":"ustream","vbox7.com":"vbox7","veoh.com":"veoh","vevo.com":"vevo","video.foxnews.com":"foxnews","video.khl.ru":"khl","video.nationalgeographic.com":"natgeovideo","videodetective.com":"videodetective","vimeo.com":"vimeo","vine.co":"vine","vk.com":"vk","vkontakte.ru":"vk","vocaroo.com":"vocaroo","vox.com":"vox","washingtonpost.com":"washingtonpost","worldstarhiphop.com":"wshh","wsj.com":"wsj","xboxclips.com":"xboxclips",
"xboxdvr.com":"xboxdvr","youku.com":"youku","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{abcnews:[[[/abcnews\\.go\\.com\\/(?:video\\/embed\\?id=|[^\\/]+\\/video\\/[^\\/]+-)(\\d+)/,p]],[]],amazon:[[[/\\/(?:dp|gp\\/product)\\/([A-Z0-9]+)/,p],[/amazon\\.(?:co\\.)?(ca|de|es|fr|in|it|jp|uk)/,["","tld"]]],[]],anchor:[[[/anchor.fm\\/[-\\w]+\\/episodes\\/(?:[-\\w]+-)(\\w+)(?![-\\w])/,p]],[]],audioboom:[[[/audioboo(?:\\.f|m\\.co)m\\/(?:boo|post)s\\/(\\d+)/,p]],[]],audiomack:[[[/audiomack\\.com\\/(album|song)\\/([-\\w]+\\/[-\\w]+)/,
["","mode","id"]]],[]],bandcamp:[[],[{a:[[/\\/album=(\\d+)/,fa]],match:[[/bandcamp\\.com\\/album\\/./,c]]},{a:[[/"album_id":(\\d+)/,fa],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,da]],match:[[/bandcamp\\.com\\/track\\/./,c]]}]],bbcnews:[[[/bbc\\.co(?:m|\\.uk)\\/news\\/av\\/embed\\/([-\\\\\\w\\/]+)/,p]],[{a:[[/bbc\\.co(?:m|\\.uk)\\\\?\\/news\\\\?\\/av\\\\?\\/embed\\\\?\\/([-\\\\\\w\\/]+)/,p]],match:[[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av(?!\\/embed)|video_and_audio)\\/\\w/,c]]}]],bitchute:[[[/bitchute\\.com\\/video\\/(\\w+)/,p]],[]],
bleacherreport:[[],[{a:[[/id="video-([-\\w]+)/,p],[/video_embed\\?id=([-\\w]+)/,p]],match:[[/\\/articles\\/./,c]]}]],"break":[[[/break\\.com\\/video\\/.*-(\\d+)$/,p]],[]],brightcove:[[[/link\\.brightcove\\.com\\/services\\/player\\/bcpid(\\d+).*?bckey=([-,~\\w]+).*?bctid=(\\d+)/,["","bcpid","bckey","bctid"]],[/players\\.brightcove\\.net\\/(\\d+)\\/.*?videoId=(\\d+)/,["","bcpid","bctid"]]],[]],cbsnews:[[[/cbsnews\\.com\\/videos?\\/(?!watch\\/)([-\\w]+)/,p],[/cbsnews\\.com\\/video\\/watch\\/\\?id=(\\d+)/,p]],[]],cnbc:[[[/cnbc\\.com\\/gallery\\/\\?video=(\\d+)/,
p]],[{a:[[/byGuid=(\\d+)/,p]],match:[[/cnbc\\.com\\/video\\/20\\d\\d\\/\\d\\d\\/\\d\\d\\/\\w/,c]]}]],cnn:[[[/cnn.com\\/videos\\/(.*\\.cnn)/,p],[/cnn\\.com\\/video\\/data\\/2\\.0\\/video\\/(.*\\.cnn)/,p]],[]],cnnmoney:[[[/money\\.cnn\\.com\\/video\\/(.*\\.cnnmoney)/,p]],[]],collegehumor:[[[/collegehumor\\.com\\/(?:video|embed)\\/(\\d+)/,p]],[]],comedycentral:[[],[{a:[[/(mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)/,p]],match:[[/c(?:c|omedycentral)\\.com\\/(?:full-episode|video-clip)s\\//,c]]}]],coub:[[[/coub\\.com\\/view\\/(\\w+)/,p]],[]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,
p],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,p],[/start=(\\d+)/,f]],[]],democracynow:[[[/democracynow.org\\/(?:embed\\/)?((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)/,p]],[{a:[[/democracynow\\.org\\/((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)\' rel=\'canonical/,p]],match:[[/m\\.democracynow\\.org\\/stories\\/\\d/,c]]}]],dumpert:[[[/dumpert\\.nl\\/mediabase\\/(\\d+[\\/_]\\w+)/,p]],[]],eighttracks:[[[/8tracks\\.com\\/[-\\w]+\\/(\\d+)(?=#|$)/,p]],[{a:[[/eighttracks:\\/\\/mix\\/(\\d+)/,p]],
match:[[/8tracks\\.com\\/[-\\w]+\\/\\D/,c]]}]],espn:[[[/video\\/(?:clip(?:\\?id=|\\/_\\/id\\/))?(\\d+)/,p]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,p],[/facebook\\.com\\/([.\\w]+)\\/(post|video)s?\\//,["","user","type"]],[/facebook\\.com\\/video\\/(post|video)\\.php/,ba]],[]],flickr:[[qa,[/flic\\.kr\\/(?!p\\/)[^\\/]+\\/(\\d+)/,p]],[{a:[qa],match:[[/flic\\.kr\\/p\\/(\\w+)/,["","short"]]],p:"https://www.flickr.com/photo.gne?rb=1&short={@short}"}]],
foxnews:[[[/video\\.foxnews\\.com\\/v\\/(\\d+)/,p]],[]],foxsports:[[],[{a:[[/BKQ29B\\/(\\w+)/,p]],match:[[/\\/video\\/\\d/,c]]}]],funnyordie:[[[/funnyordie\\.com\\/videos\\/([0-9a-f]+)/,p]],[]],gamespot:[[[/gamespot\\.com.*?\\/(?:events|videos)\\/.*?-(\\d+)\\/(?:[#?].*)?$/,p]],[]],gametrailers:[[],[{a:[[ca,p]],match:[[/gametrailers\\.com\\/(?:full-episode|review|video)s\\//,c]]}]],getty:[[[/gty\\.im\\/(\\d+)/,p],[/gettyimages\\.[.\\w]+\\/detail(?=\\/).*?\\/(\\d+)/,p],[/#[-\\w]*picture-id(\\d+)$/,p]],[{a:[[/"height":[ "]*(\\d+)/,
u],[/"width":[ "]*(\\d+)/,t],[/\\bid[=:][\'"]?([-=\\w]+)/,["","et"]],[/\\bsig[=:][\'"]?([-=\\w]+)/,["","sig"]]],match:v,p:"http://embed.gettyimages.com/preview/{@id}"}]],gfycat:[[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?(\\w+)/,p]],[{a:[[/\\/ifr\\/(\\w+)/,p]],match:[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?[a-z]/,c]],p:"https://gfycat.com/ifr/{@id}"},{a:[[/"height":(\\d+)/,u],[/"width":(\\d+)/,t]],match:v,p:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}"}]],
gifs:[[[/gifs\\.com\\/(?:gif\\/)?(\\w+)/,p]],[{a:[[/meta property="og:image:width" content="(\\d+)/,t],[/meta property="og:image:height" content="(\\d+)/,u]],match:v,p:"https://gifs.com/gif/{@id}"}]],gist:[[[/gist\\.github\\.com\\/((?:\\w+\\/)?[\\da-f]+(?:\\/[\\da-f]+)?)/,p]],[]],globalnews:[oa,[{a:oa,match:[[/globalnews\\.ca\\/video\\/rd\\//,c]]}]],gofundme:[[[/gofundme\\.com\\/(\\w+)(?![^#?])/,p]],[]],googledrive:[[[/drive\\.google\\.com\\/.*?(?:file\\/d\\/|id=)([-\\w]+)/,p]],[]],googleplus:[[[/\\/\\/plus\\.google\\.com\\/(?:u\\/\\d+\\/)?(?:\\+([^\\/]+)|(\\d+))\\/posts\\/(\\w+)/,
["","name","oid","pid"]]],[]],googlesheets:[[[/docs\\.google\\.com\\/spreadsheet(?:\\/ccc\\?key=|(?:[^e]\\/)+)((?:e\\/)?[-\\w]+)/,p],[/oid=(\\d+)/,["","oid"]],[/#gid=(\\d+)/,["","gid"]],[/\\/pub(chart)/,ba]],[]],hudl:[[[/hudl\\.com\\/athlete\\/(\\d+)\\/highlights\\/([\\da-f]+)/,ma],sa,pa],[{a:[sa,pa],match:[[/hudl\\.com\\/v\\//,c]]}]],hulu:[[],[{a:[[/eid=([-\\w]+)/,p]],match:[[/hulu\\.com\\/watch\\//,c]]}]],ign:[[[/(https?:\\/\\/.*?ign\\.com\\/videos\\/.+)/i,p]],[]],imdb:[[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)/,p]],[]],imgur:[[[/imgur\\.com\\/(a\\/\\w+)/,
p],[/i\\.imgur\\.com\\/(\\w{5,7})[lms]?\\./,p],[/imgur\\.com\\/(\\w+)(?![\\w.\\/])/,p]],[{a:[[/data-id="([\\w\\/]+)"/,p]],match:[[/imgur\\.com\\/(?![art]\\/|user\\/)((?:gallery\\/)?\\w+)(?![\\w.])/,["","path"]]],p:"https://api.imgur.com/oembed.xml?url=/{@path}"}]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,p]],[]],instagram:[[[/instagram\\.com\\/(?:p|tv)\\/([-\\w]+)/,p]],[]],internetarchive:[[],[{a:[[/meta property="twitter:player" content="https:\\/\\/archive.org\\/embed\\/([^\\/"]+)/,p],[/meta property="og:video:width" content="(\\d+)/,
t],[/meta property="og:video:height" content="(\\d+)/,u]],match:[[/archive\\.org\\/(?:details|embed)\\//,c]]}]],izlesene:[[[/izlesene\\.com\\/video\\/[-\\w]+\\/(\\d+)/,p]],[]],jwplatform:[[[/jwplatform\\.com\\/\\w+\\/([-\\w]+)/,p]],[]],khl:[[],[{a:[[/\\/feed\\/start\\/([\\/\\w]+)/,p]],match:[[/video\\.khl\\.ru\\/(?:event|quote)s\\/\\d/,c]]}]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],libsyn:[[],[{a:[[/embed\\/episode\\/id\\/(\\d+)/,p]],match:[[/(?!\\.mp3)....$/,
c]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,p]],[{a:[[/liveleak\\.com\\/e\\/(\\w+)/,p]],match:[[/liveleak\\.com\\/view\\?t=/,c]]}]],livestream:[[[/livestream\\.com\\/accounts\\/(\\d+)\\/events\\/(\\d+)/,na],[/\\/videos\\/(\\d+)/,ea],[/original\\.livestream\\.com\\/(\\w+)\\/video\\?clipId=([-\\w]+)/,la]],[{a:[[/accounts\\/(\\d+)\\/events\\/(\\d+)/,na]],match:[[/livestream\\.com\\/(?!accounts\\/\\d+\\/events\\/\\d)/,c]]},{a:[[/\\/\\/original\\.livestream\\.com\\/(\\w+)\\/video\\/([-\\w]+)/,la]],match:[[/livestre.am/,c]]}]],mailru:[[],
[{a:[[/"itemId": ?"?(\\d+)/,p]],match:[[/my\\.mail\\.ru\\/\\w+\\/\\w+\\/video\\/\\w+\\/\\d/,c]]}]],medium:[[[/medium\\.com\\/(?:s\\/)?[^\\/]*\\/(?:[-\\w]+-)?([\\da-f]+)/,p]],[]],megaphone:[[[/megaphone\\.fm\\/.*?\\?(?:e|selected)=(\\w+)/,p],[/(?:dcs|player|traffic)\\.megaphone\\.fm\\/(\\w+)/,p],[/megaphone\\.link\\/(\\w+)/,p]],[]],metacafe:[[[/metacafe\\.com\\/watch\\/(\\d+)/,p]],[]],mixcloud:[[[/mixcloud\\.com\\/(?!categories|tag)([-\\w]+\\/[^\\/&]+)\\//,p]],[]],mixer:[[[/mixer.com\\/(?!browse\\/)(\\w+)(?!\\?clip|\\w)(?:\\?vod=([-\\w]+))?/,["",
"channel","vod"]]],[]],mlb:[[[/mlb\\.com\\/video\\/(?:[-\\w\\/]+\\/)?(?:c-|v|[-\\w]+-c)(\\d+)/,p]],[]],mrctv:[[],[{a:[[/mrctv\\.org\\/embed\\/(\\d+)/,p]],match:[[/mrctv\\.org\\/videos\\/./,c]]}]],msnbc:[[],[{a:[[/"video":\\{"current".*?id":"(\\w+)/,p]],match:[[/msnbc\\.com\\/[-\\w]+\\/watch\\//,c],[/on\\.msnbc\\.com\\/./,c]]}]],natgeochannel:[[[/channel\\.nationalgeographic\\.com\\/([-\\/\\w]+\\/videos\\/[-\\w]+)/,p]],[]],natgeovideo:[[],[{a:[[/guid="([-\\w]+)"/,p]],match:[[/video\\.nationalgeographic\\.com\\/(?:tv|video)\\/\\w/,c]]}]],
nbcnews:[[[/nbcnews\\.com\\/(?:widget\\/video-embed\\/|video\\/[-\\w]+-)(\\d+)/,p]],[]],nbcsports:[[],[{a:[[/select\\/media\\/(\\w+)/,p]],match:[[/nbcsports\\.com\\/video\\/./,c]]}]],nhl:[[[/nhl\\.com\\/(?:\\w+\\/)?video(?:\\/(?![ct]-)[-\\w]+)?(?:\\/t-(\\d+))?(?:\\/c-(\\d+))?/,["","t","c"]]],[]],npr:[[],[{a:[[/player\\/embed\\/(\\d+)\\/(\\d+)/,["","i","m"]]],u:"Cookie: trackingChoice=false; choiceVersion=1",match:[[/npr\\.org\\/[\\/\\w]+\\/\\d+/,c],[/n\\.pr\\/\\w/,c]]}]],nytimes:[[[/nytimes\\.com\\/video\\/[a-z]+\\/(?:[a-z]+\\/)?(\\d+)/,p],
[/nytimes\\.com\\/video\\/\\d+\\/\\d+\\/\\d+\\/[a-z]+\\/(\\d+)/,p]],[{a:[[/\\/video\\/movies\\/(\\d+)/,p]],match:[[/nytimes\\.com\\/movie(?:s\\/movie)?\\/(\\d+)\\/[-\\w]+\\/trailers/,["","playlist"]]],p:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true"}]],orfium:[[[/album\\/(\\d+)/,fa],[/playlist\\/(\\d+)/,ja],[/live-set\\/(\\d+)/,["","set_id"]],[/track\\/(\\d+)/,da]],[]],pastebin:[[[/pastebin\\.com\\/(?!u\\/)(?:\\w+(?:\\.php\\?i=|\\/))?(\\w+)/,p]],[]],pinterest:[[[/pinterest.com\\/pin\\/(\\d+)/,p],[/pinterest.com\\/(?!_\\/|discover\\/|explore\\/|news_hub\\/|pin\\/|search\\/)([-\\w]+\\/[-\\w]+)/,
p]],[]],podbean:[[[/podbean\\.com\\/media\\/(?:player\\/|share\\/pb-)([-\\w]+)/,p]],[{a:[[/podbean\\.com\\/media\\/player\\/([-\\w]+)/,p]],match:[[/podbean\\.com\\/(?:media\\/shar)?e\\/(?!pb-)/,c]]}]],prezi:[[[/\\/\\/prezi\\.com\\/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)\\/)(\\w+)\\//,p]],[]],reddit:[[[/(\\w+\\/comments\\/\\w+(?:\\/\\w+\\/\\w+)?)/,p]],[]],rutube:[[[/rutube\\.ru\\/tracks\\/(\\d+)/,
p]],[{a:[[/rutube\\.ru\\/play\\/embed\\/(\\d+)/,p]],u:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/rutube\\.ru\\/video\\/([0-9a-f]{32})/,aa]],p:"http://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/"}]],scribd:[[[/scribd\\.com\\/(?:mobile\\/)?(?:doc(?:ument)?|presentation)\\/(\\d+)/,p]],[]],sendvid:[[[/sendvid\\.com\\/(\\w+)/,p]],[]],slideshare:[[[/slideshare\\.net\\/[^\\/]+\\/[-\\w]+-(\\d{6,})$/,p]],[{a:[[/"presentationId":(\\d+)/,p]],match:[[/slideshare\\.net\\/[^\\/]+\\/\\w(?![-\\w]+-\\d{6,}$)/,
c]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,p],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,ja],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{a:[[/soundcloud:tracks:(\\d+)/,da]],u:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,c]]},{a:[[/soundcloud:\\/\\/playlists:(\\d+)/,
ja]],u:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/\\w+\\/sets\\//,c]]}]],sporcle:[[[/sporcle.com\\/framed\\/.*?gid=(\\w+)/,p]],[{a:[[/encodedGameID\\W+(\\w+)/,p]],match:[[/sporcle\\.com\\/games\\/(?!\\w*category\\/)[-\\w]+\\/[-\\w]/,c]]}]],sportsnet:[[],[{a:[[/vid(?:eoId)?=(\\d+)/,p],[/param name="@videoPlayer" value="(\\d+)"/,p]],match:v}]],spotify:[[[/(?:open|play)\\.spotify\\.com\\/((?:user\\/[-.\\w]+\\/)?(?:album|artist|playlist|track)(?:[:\\/][-.\\w]+)+)/,p]],[]],spreaker:[[[/spreaker\\.com\\/episode\\/(\\d+)/,
ia]],[{a:[[/episode_id=(\\d+)/,ia],[/show_id=(\\d+)/,["","show_id"]]],match:[[/(.+\\/(?:show\\/|user\\/.+\\/).+)/,["","url"]]],p:"https://api.spreaker.com/oembed?format=json&url={@url}"}]],steamstore:[[[/store.steampowered.com\\/app\\/(\\d+)/,p]],[]],stitcher:[[],[{a:[[/data-eid="(\\d+)/,["","eid"]],[/data-fid="(\\d+)/,["","fid"]]],match:[[/\\/podcast\\//,c]]}]],strawpoll:[[[/strawpoll\\.me\\/(\\d+)/,p]],[]],streamable:[[[/streamable\\.com\\/(\\w+)/,p]],[]],streamja:[[[/streamja\\.com\\/(?!login|signup|terms|videos)(\\w+)/,
p]],[]],teamcoco:[[[/teamcoco\\.com\\/video\\/(\\d+)/,p]],[{a:[[/embed\\/v\\/(\\d+)/,p]],match:[[/teamcoco\\.com\\/video\\/\\D/,c]]}]],ted:[[[/ted\\.com\\/((?:talk|playlist)s\\/[-\\w]+(?:\\.html)?)(?![-\\w]|\\/transcript)/i,p]],[]],telegram:[[[/\\/\\/t.me\\/(?!addstickers\\/|joinchat\\/)(\\w+\\/\\d+)/,p]],[]],theatlantic:[[[/theatlantic\\.com\\/video\\/index\\/(\\d+)/,p]],[]],theguardian:[[[/theguardian\\.com\\/(\\w+\\/video\\/20(?:0[0-9]|1[0-7])[-\\/\\w]+)/,p]],[]],theonion:[[[/theonion\\.com\\/video\\/[-\\w]+[-,](\\d+)/,p]],[]],tiktok:[[[/tiktok\\.com\\/(?:v|i18n\\/share\\/video)\\/(\\d+)/,
p]],[{a:[[/tiktok\\.com\\/v\\/(\\d+)/,p],[/musically:\\/\\/musical\\?id=(\\d+)/,p]],u:"User-agent: PHP",match:[[/\\/\\/vm\\.tiktok\\.com\\/./,c]]}]],tmz:[[[/tmz\\.com\\/videos\\/(\\w+)/,p]],[]],traileraddict:[[],[{a:[[/v\\.traileraddict\\.com\\/(\\d+)/,p]],match:[[/traileraddict\\.com\\/(?!tags\\/)[^\\/]+\\/./,c]]}]],trendingviews:[[[/trendingviews.co\\/(?:video|embed)\\/(?:[^\\/]+-)?(\\d+)/,p]],[]],tumblr:[[[/([-\\w]+)\\.tumblr\\.com\\/post\\/(\\d+)/,["","name","id"]]],[{a:[[/did=\\\\u0022([-\\w]+)/,["","did"]],[/embed\\\\\\/post\\\\\\/([-\\w]+)/,
["","key"]]],match:[[/\\w\\.tumblr\\.com\\/post\\/\\d/,c]],p:"http://www.tumblr.com/oembed/1.0?url=http://{@name}.tumblr.com/post/{@id}"}]],twentyfoursevensports:[ra,[{a:ra,u:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Player\\/[-\\w]*\\d/,c]]},{a:[[/player_id%3D(\\d+)/,ea]],u:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Video\\/./,
c]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,ea],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)/,["","channel"]],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,f],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?(\\w+)/,la]],[]],twitter:[[[/twitter\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,p]],[]],ustream:[[[/ustream\\.tv\\/recorded\\/(\\d+)/,aa]],[{a:[[ca,["","cid"]]],match:[[/ustream\\.tv\\/(?!explore\\/|platform\\/|recorded\\/|search\\?|upcoming$|user\\/)(?:channel\\/)?[-\\w]+/,c]]}]],vbox7:[[[/vbox7\\.com\\/play:([\\da-f]+)/,
p]],[]],veoh:[[[/veoh\\.com\\/(?:m\\/watch\\.php\\?v=|watch\\/)v(\\w+)/,p]],[]],vevo:[[[/vevo\\.com\\/watch\\/(.*?\\/)?([A-Z]+\\d+)/,["","","id"]]],[]],videodetective:[[[/videodetective\\.com\\/\\w+\\/[-\\w]+\\/(?:trailer\\/P0*)?(\\d+)/,p]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,p],[/#t=([\\dhms]+)/,f]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,p]],[]],vk:[[[/vk(?:\\.com|ontakte\\.ru)\\/(?:[\\w.]+\\?z=)?video(-?\\d+)_(\\d+).*?hash=([0-9a-f]+)/,ka],[/vk(?:\\.com|ontakte\\.ru)\\/video_ext\\.php\\?oid=(-?\\d+)&id=(\\d+)&hash=([0-9a-f]+)/,
ka]],[]],vocaroo:[[[/vocaroo\\.com\\/i\\/(\\w+)/,p]],[]],vox:[[[/vox.com\\/.*#ooid=([-\\w]+)/,p]],[]],washingtonpost:[[[/washingtonpost\\.com\\/video\\/c\\/\\w+\\/([-0-9a-f]+)/,p],[/washingtonpost\\.com\\/video\\/[-\\/\\w]+\\/([-0-9a-f]+)_video\\.html/,p]],[]],wshh:[[[/worldstarhiphop\\.com\\/featured\\/(\\d+)/,p]],[{a:[[/v: ?"?(\\d+)/,p]],match:[[/worldstarhiphop\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,c]]}]],wsj:[[[/wsj\\.com\\/[^#]*#!([-0-9A-F]{36})/,p],[/wsj\\.com\\/video\\/[^\\/]+\\/([-0-9A-F]{36})/,p]],[{a:[[/guid=([-0-9A-F]{36})/,
p]],match:[[/on\\.wsj\\.com\\/\\w/,c]]}]],xboxclips:[[[/xboxclips\\.com\\/([^\\/]+)\\/(?!screenshots\\/)([-0-9a-f]+)/,ha]],[]],xboxdvr:[[[/(?:gamer|xbox)dvr\\.com\\/gamer\\/([^\\/]+)\\/video\\/(\\d+)/,ha]],[]],youku:[[[/youku\\.com\\/v(?:_show|ideo)\\/id_(\\w+=*)/,p]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|v\\/|attribution_link.*?v%3D)([-\\w]+)/,p],[/youtu\\.be\\/([-\\w]+)/,p],[/[#&?]t=(\\d[\\dhms]*)/,f],[/[&?]list=([-\\w]+)/,["","list"]]],[{a:[[/\\/vi\\/([-\\w]+)/,p]],match:[[/\\/shared\\?ci=/,c]]}]]},urlConfig:{G:/^https?$/i}},
Ia={e:[771],flags:0},T={ABCNEWS:E,AMAZON:{e:e,b:{id:w,tld:w},h:1,d:D,f:10,j:r,g:5E3},ANCHOR:E,AUDIOBOOM:E,AUDIOMACK:{e:e,b:{id:w,mode:w},h:1,d:D,f:10,j:r,g:5E3},BANDCAMP:{e:e,b:{album_id:w,track_id:w,track_num:w},h:1,d:D,f:10,j:r,g:5E3},BBCNEWS:{e:e,b:{id:{d:[function(a){return a.replace(/\\\\([\\s\\S]?)/g,"\\\\1")}],r:!1}},h:1,d:D,f:10,j:r,g:5E3},BITCHUTE:E,BLEACHERREPORT:E,BREAK:E,BRIGHTCOVE:{e:e,b:{bckey:w,bcpid:w,bctid:w},h:1,d:D,f:10,j:r,g:5E3},CBSNEWS:E,CNBC:E,CNN:E,CNNMONEY:E,COLLEGEHUMOR:E,COMEDYCENTRAL:E,
COUB:E,DAILYMOTION:{e:e,b:{id:w,t:w},h:1,d:D,f:10,j:r,g:5E3},DEMOCRACYNOW:E,DUMPERT:E,EIGHTTRACKS:E,ESPN:E,FACEBOOK:{e:e,b:{id:w,type:w,user:w},h:1,d:D,f:10,j:r,g:5E3},FLICKR:E,FOXNEWS:E,FOXSPORTS:E,FUNNYORDIE:E,GAMESPOT:E,GAMETRAILERS:E,GETTY:{e:e,b:{et:w,height:wa,id:w,sig:w,width:va},h:1,d:D,f:10,j:r,g:5E3},GFYCAT:ya,GIFS:ya,GIST:E,GLOBALNEWS:E,GOFUNDME:E,GOOGLEDRIVE:E,GOOGLEPLUS:{e:e,b:{name:{d:[function(a){return decodeURIComponent(""+a)}],r:!1},oid:w,pid:w},h:1,d:D,f:10,j:r,g:5E3},GOOGLESHEETS:{e:e,
b:{gid:w,id:w,oid:w,type:w},h:1,d:D,f:10,j:r,g:5E3},HUDL:{e:e,b:{athlete:w,highlight:w,id:w},h:1,d:D,f:10,j:r,g:5E3},HULU:E,IGN:E,IMDB:E,IMGUR:E,INDIEGOGO:E,INSTAGRAM:E,INTERNETARCHIVE:{e:e,b:{height:wa,id:{d:[function(){return!1}],r:!1},width:va},h:1,d:D,f:10,j:r,g:5E3},IZLESENE:E,JWPLATFORM:E,KHL:E,KICKSTARTER:{e:e,b:{card:w,id:w,video:w},h:1,d:D,f:10,j:r,g:5E3},LIBSYN:E,LIVELEAK:E,LIVESTREAM:{e:e,b:{account_id:w,channel:w,clip_id:w,event_id:w,video_id:w},h:1,d:D,f:10,j:r,g:5E3},MAILRU:E,MEDIA:{e:[770],
b:{},h:0,d:[function(a){return function(b,d,g){function n(h,k,q){var l=!1;q.forEach(function(m){var x=m[1],A=m[0].exec(k);A&&(l=!0,x.forEach(function(I,y){""<A[y]&&""<I&&(h[I]=A[y])}))});return l}(function(h,k,q){B(h);if("url"in h.b){var l=h.b.url,m;a:{for(m=/^https?:\\/\\/([^\\/]+)/.exec(l.toLowerCase())[1]||"";""<m;){if(k[m]){m=k[m];break a}m=m.replace(/^[^.]*./,"")}m=""}if(q[m]){k={};n(k,l,q[m][0]);a:{for(var x in k){q=!1;break a}q=!0}if(!q){q=h.k;x=h.s;if(x){var A=h.l;l=x.k;x=x.l}else A=0,l=h.k+
h.l,x=0;m=m.toUpperCase();h=h.w;l=Q(2,m,l,x,-h||0);h=Q(1,m,q,A,h||0);J(h,l);C(h,k)}}}})(b,d,g)}(a,Ha["MediaEmbed.hosts"],Ha["MediaEmbed.sites"],Ha.cacheDir)}],f:10,j:{flags:513},g:5E3},MEDIUM:E,MEGAPHONE:E,METACAFE:E,MIXCLOUD:E,MIXER:{e:e,b:{channel:w,vod:w},h:1,d:D,f:10,j:r,g:5E3},MLB:E,MRCTV:E,MSNBC:E,NATGEOCHANNEL:E,NATGEOVIDEO:E,NBCNEWS:E,NBCSPORTS:E,NHL:{e:e,b:{c:w,t:w},h:1,d:D,f:10,j:r,g:5E3},NPR:{e:e,b:{i:w,m:w},h:1,d:D,f:10,j:r,g:5E3},NYTIMES:E,ORFIUM:{e:e,b:{album_id:w,playlist_id:w,set_id:w,
track_id:w},h:1,d:D,f:10,j:r,g:5E3},PASTEBIN:E,PINTEREST:E,PODBEAN:E,PREZI:E,REDDIT:E,RUTUBE:E,SCRIBD:E,SENDVID:E,SLIDESHARE:E,SOUNDCLOUD:{e:e,b:{id:w,playlist_id:w,secret_token:w,track_id:w},h:1,d:D,f:10,j:r,g:5E3},SPORCLE:E,SPORTSNET:E,SPOTIFY:E,SPREAKER:{e:e,b:{episode_id:w,show_id:w},h:1,d:D,f:10,j:r,g:5E3},STEAMSTORE:E,STITCHER:{e:e,b:{eid:w,fid:w},h:1,d:D,f:10,j:r,g:5E3},STRAWPOLL:E,STREAMABLE:E,STREAMJA:E,TEAMCOCO:E,TED:E,TELEGRAM:E,THEATLANTIC:E,THEGUARDIAN:E,THEONION:E,TIKTOK:E,TMZ:E,TRAILERADDICT:E,
TRENDINGVIEWS:E,TUMBLR:{e:e,b:{did:w,id:w,key:w,name:w},h:1,d:D,f:10,j:r,g:5E3},TWENTYFOURSEVENSPORTS:{e:e,b:{player_id:w,video_id:w},h:1,d:D,f:10,j:r,g:5E3},TWITCH:{e:e,b:{channel:w,clip_id:w,t:w,video_id:w},h:1,d:D,f:10,j:r,g:5E3},TWITTER:E,USTREAM:{e:e,b:{cid:w,vid:w},h:1,d:D,f:10,j:r,g:5E3},VBOX7:E,VEOH:E,VEVO:E,VIDEODETECTIVE:E,VIMEO:{e:e,b:{id:w,t:ua},h:1,d:D,f:10,j:r,g:5E3},VINE:E,VK:{e:e,b:{hash:w,oid:w,vid:w},h:1,d:D,f:10,j:r,g:5E3},VOCAROO:E,VOX:E,WASHINGTONPOST:E,WSHH:E,WSJ:E,XBOXCLIPS:xa,
XBOXDVR:xa,YOUKU:E,YOUTUBE:{e:e,b:{id:{d:[function(a){return/^[-0-9A-Za-z_]+$/.test(a)?a:!1}],r:!1},list:w,t:ua},h:1,d:D,f:10,j:r,g:5E3}},U,Ja,V,W,Ka=0,X;
function La(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=z;b.q=[];delete b.k;delete b.l;K={};Fa={};M=0;N=null;Ga=!1;O=[];P="";S=0;U=[];Ja=!1;V=a;W=V.length;X=0;L=Ia;L.z=!1;++Ka;a=Ka;for(var d in R)if(!R[d].v)a:{b=d;var g=R[b];if(!(g.A&&0>V.indexOf(g.A))){var n=[];if("undefined"!==typeof g.B&&"undefined"!==typeof g.C){n=void 0;var h=g.B;g=g.C;h.lastIndex=0;for(var k=[],q=0;++q<=g&&(n=h.exec(V));){for(var l=n.index,m=[[n[0],l]],x=0;++x<n.length;){var A=n[x];void 0===
A?m.push(["",-1]):(m.push([A,V.indexOf(A,l)]),l+=A.length)}k.push(m)}n=k;if(!n.length)break a}(0,R[b].F)(V,n)}}Ma();Y(W,!0);do d=P,P=P.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(P!==d);P=P.replace(/<\\/i><i>/g,"");P=P.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");P=P.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Na);d=Ga?"r":"t";P="<"+d+">"+P+"</"+d+">";if(Ka!==a)throw"The parser has been reset during execution";1E4<M&&z.add("warn","Fixing cost limit exceeded",void 0);return P}
function Oa(a){var b={},d;for(d in T[a])b[d]=T[a][d];return T[a]=b}function Na(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function Pa(a){Ga=!0;var b=a.name,d=a.k,g=a.l,n=0,h=!1;a.n&1||(h=!0);Y(d,h);h=g?Ba(V.substr(d,g)):"";if(a.n&1){P+="<"+b;var k=Da(a),q=[],l;for(l in k)q.push(l);q.sort(function(m,x){return m>x?1:-1});q.forEach(function(m){P+=" "+m+\'="\'+Aa(k[m].toString()).replace(/\\n/g,"&#10;")+\'"\'});P=3===a.n?g?P+(">"+h+"</"+b+">"):P+"/>":g?P+("><s>"+h+"</s>"):P+">"}else g&&(P+="<e>"+h+"</e>"),P+="</"+b+">";for(X=S=d+g;n&&X<W&&"\\n"===V[X];)--n,++X}
function Y(a,b){var d=0;b&&(L.flags&8?d=-1:b=!1);S>=a&&b&&Qa();if(X>S){var g=Math.min(a,X);P+=V.substr(S,g-S);S=g;S>=a&&b&&Qa()}var n=a;for(g=0;d&&--n>=S;){var h=V[n];if(" "!==h&&"\\n"!==h&&"\\t"!==h)break;"\\n"===h&&--d;++g}a-=g;a>S&&(d=Ba(V.substr(S,a-S)),P+=d);b&&Qa();g&&(P+=V.substr(a,g));S=a+g}function Ra(a){var b=a.k;a=a.l;var d=V.substr(b,a);Y(b,!1);P+="<i>"+Ba(d)+"</i>";Ga=!0;S=b+a}function Qa(){L.z&&(P+="</p>",L.z=!1)}
function Ma(){if(U.length){for(var a in T)K[a]=0,Fa[a]=0;do{for(;U.length;)Ja||Sa(),N=U.pop(),Ta();O.forEach(function(b){var d=Q(2,b.name,W,0,0);J(d,b)})}while(U.length)}}
function Ta(){L.flags&64&&!Ea(N,O[O.length-1])&&!(-1<"br i pb v".indexOf(N.name))&&B(N);var a=N.k,b=N.l;if(S>a&&!N.o){var d;if((d=N.q)&&0<=O.indexOf(d)){J(Q(2,d.name,S,Math.max(0,a+b-S),0),d);return}if("i"===N.name&&(a=a+b-S,0<a)){b=S;Q(3,"i",b,Math.min(a,W-b),0);return}B(N)}if(!N.o)if("i"===N.name)Ra(N);else if("br"===N.name)L.flags&1024||(Y(N.k,!1),P+="<br/>");else if("pb"===N.name)Y(N.k,!0);else if("v"===N.name)a=L.flags,L.flags=N.flags,Y(N.k+N.l,!1),L.flags=a;else if(N.n&1)if(a=N,b=a.name,d=T[b],
Fa[b]>=d.g)z.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:d.g}),B(a);else{var g=a,n=T[g.name];z.l=g;for(var h=0;h<n.d.length&&!g.o;++h)n.d[h](g,n);delete z.l;a.o||(K[b]>=d.f?(z.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:d.f}),B(a)):(d=T[b].h,L.e[d>>3]&1<<(d&7)?(!(a.flags&1&&3!==a.n)||a.s||U.length&&Ea(U[U.length-1],a)||(b=new H(3,b,a.k,a.l),C(b,Da(a)),b.flags=a.flags,a=b),Pa(a),Ua(a)):(b={tag:a,tagName:b},0<a.l?z.add("warn","Tag is not allowed in this context",b):
Ca("Tag is not allowed in this context",b),B(a))))}else Va()}
function Va(){var a=N;if(K[a.name]){for(var b=[],d=O.length;0<=--d;){var g=O[d];if(Ea(a,g))break;b.push(g);++M}if(0>d)Ca("Skipping end tag with no start tag",{tag:a});else{b.forEach(function(){});var n=0,h=[];b.forEach(function(l){var m=l.name;n&&(l.flags&2?h.push(l):n=!1);m=new H(2,m,a.k,0);m.flags=l.flags;Pa(m);Wa()});Pa(a);Wa();if(b.length&&1E4>M){g=S;for(d=U.length;0<=--d&&1E4>++M;){var k=U[d];if(k.k>g||k.n&1)break;for(var q=b.length;0<=--q&&1E4>++M;)if(Ea(k,b[q])){b.splice(q,1);h[q]&&h.splice(q,
1);g=Math.max(g,k.k+k.l);break}}g>S&&Ra(new H(3,"i",S,g-S))}h.forEach(function(l){var m=Q(l.n,l.name,S,0,l.w);C(m,Da(l));(l=l.s)&&J(m,l)})}}}function Wa(){var a=O.pop();--K[a.name];L=L.D}function Ua(a){var b=a.name,d=a.flags,g=T[b];++Fa[b];if(3!==a.n){var n=[];L.e.forEach(function(k,q){d&512||(k=k&65280|k>>8);n.push(g.e[q]&k)});var h=d|L.flags&32;h&16&&(h&=-33);++K[b];O.push(a);L={D:L};L.e=n;L.flags=h}}
function Q(a,b,d,g,n){a=new H(a,b,d,g,n||0);T[b]&&(a.flags=T[b].j.flags);if(!(T[b]||-1<"br i pb v".indexOf(a.name))||0>g||0>d||d+g>W||/[\\uDC00-\\uDFFF]/.test(V.substr(d,1)+V.substr(d+g,1)))B(a);else if(T[b]&&T[b].v)z.add("warn","Tag is disabled",{tag:a,tagName:b}),B(a);else if(Ja){b=U.length;for(d=Xa(a);0<b&&d>Xa(U[b-1]);)U[b]=U[b-1],--b;U[b]=a}else U.push(a);return a}
function Sa(){for(var a={},b=[],d=U.length;0<=--d;){var g=U[d],n=Xa(g,d);b.push(n);a[n]=g}b.sort();d=b.length;for(U=[];0<=--d;)U.push(a[b[d]]);Ja=!0}function Xa(a,b){var d=0<=a.w,g=a.w;d||(g+=1073741824);var n=0<a.l,h;n?h=W-a.l:h={2:0,3:1,1:2}[a.n];return Ya(a.k)+ +d+Ya(g)+ +n+Ya(h)+Ya(b||0)}function Ya(a){a=a.toString(16);return"        ".substr(a.length)+a}var Za="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function $a(a){if(Za){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function ab(a,b){if(Za){var d=b.createElement("div");b=b.createDocumentFragment();Z.input=$a(a);Z.transform();for(d.innerHTML=Z.output;d.firstChild;)b.appendChild(d.firstChild);return b}return Z.transformToFragment($a(a),b)}var Z,bb=$a(za);
if(Za){var cb=new ActiveXObject("MSXML2.XSLTemplate.6.0");cb.stylesheet=bb;Z=cb.createProcessor()}else Z=new XSLTProcessor,Z.importStylesheet(bb);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){R[a]&&(R[a].v=!0)},disableTag:function(a){T[a]&&(Oa(a).v=!0)},enablePlugin:function(a){R[a]&&(R[a].v=!1)},enableTag:function(a){T[a]&&(Oa(a).v=!1)},getLogger:function(){return z},parse:La,preview:function(a,b){function d(k,q){var l=k.childNodes;q=q.childNodes;for(var m=l.length,x=q.length,A,I,y=0,F=0;y<m&&y<x;){A=l[y];I=q[y];if(!g(A,I))break;++y}for(var db=Math.min(m-y,x-y);F<db;){A=l[m-(F+1)];I=q[x-(F+1)];if(!g(A,I))break;++F}for(m-=F;--m>=y;)k.removeChild(l[m]),
h=k;l=x-F;if(!(y>=l)){x=n.createDocumentFragment();m=y;do I=q[m],h=x.appendChild(I);while(m<--l);F?k.insertBefore(x,k.childNodes[y]):k.appendChild(x)}}function g(k,q){if(k.nodeName!==q.nodeName||k.nodeType!==q.nodeType)return!1;if(k instanceof HTMLElement&&q instanceof HTMLElement){if(!k.isEqualNode(q)){for(var l=k.attributes,m=q.attributes,x=m.length,A=l.length,I=" "+k.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--A;){var y=l[A],F=y.namespaceURI;y=y.name;-1<I.indexOf(" "+y+" ")||q.hasAttributeNS(F,
y)||(k.removeAttributeNS(F,y),h=k)}for(A=x;0<=--A;)l=m[A],F=l.namespaceURI,y=l.name,l=l.value,-1<I.indexOf(" "+y+" ")||l===k.getAttributeNS(F,y)||(k.setAttributeNS(F,y,l),h=k);d(k,q)}}else 3!==k.nodeType&&8!==k.nodeType||k.nodeValue===q.nodeValue||(k.nodeValue=q.nodeValue,h=k);return!0}var n=b.ownerDocument;if(!n)throw"Target does not have a ownerDocument";a=ab(La(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),n);var h=b;d(b,a);return h},registeredVars:Ha,setNestingLimit:function(a,b){T[a]&&(Oa(a).f=b)},
setParameter:function(a,b){Za?Z.addParameter(a,b,""):Z.setParameter(null,a,b)},setTagLimit:function(a,b){T[a]&&(Oa(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:158:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"amazon.ca";s:6:"amazon";s:12:"amazon.co.uk";s:6:"amazon";s:12:"amazon.co.jp";s:6:"amazon";s:10:"amazon.com";s:6:"amazon";s:9:"amazon.de";s:6:"amazon";s:9:"amazon.es";s:6:"amazon";s:9:"amazon.fr";s:6:"amazon";s:9:"amazon.in";s:6:"amazon";s:9:"amazon.it";s:6:"amazon";s:9:"anchor.fm";s:6:"anchor";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:12:"bandcamp.com";s:8:"bandcamp";s:9:"bbc.co.uk";s:7:"bbcnews";s:7:"bbc.com";s:7:"bbcnews";s:12:"bitchute.com";s:8:"bitchute";s:18:"bleacherreport.com";s:14:"bleacherreport";s:9:"break.com";s:5:"break";s:19:"link.brightcove.com";s:10:"brightcove";s:22:"players.brightcove.net";s:10:"brightcove";s:11:"cbsnews.com";s:7:"cbsnews";s:8:"cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:16:"collegehumor.com";s:12:"collegehumor";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:7:"flic.kr";s:6:"flickr";s:10:"flickr.com";s:6:"flickr";s:17:"video.foxnews.com";s:7:"foxnews";s:13:"foxsports.com";s:9:"foxsports";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:16:"gametrailers.com";s:12:"gametrailers";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:10:"gfycat.com";s:6:"gfycat";s:8:"gifs.com";s:4:"gifs";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:14:"jwplatform.com";s:10:"jwplatform";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:10:"libsyn.com";s:6:"libsyn";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:10:"medium.com";s:6:"medium";s:12:"megaphone.fm";s:9:"megaphone";s:14:"megaphone.link";s:9:"megaphone";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:9:"mixer.com";s:5:"mixer";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:13:"nbcsports.com";s:9:"nbcsports";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"orfium.com";s:6:"orfium";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:11:"sendvid.com";s:7:"sendvid";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:11:"sporcle.com";s:7:"sporcle";s:12:"sportsnet.ca";s:9:"sportsnet";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:12:"spreaker.com";s:8:"spreaker";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"stitcher.com";s:8:"stitcher";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"streamja.com";s:8:"streamja";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:4:"t.me";s:8:"telegram";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:10:"tiktok.com";s:6:"tiktok";s:7:"tmz.com";s:3:"tmz";s:17:"traileraddict.com";s:13:"traileraddict";s:16:"trendingviews.co";s:13:"trendingviews";s:10:"tumblr.com";s:6:"tumblr";s:13:"247sports.com";s:21:"twentyfoursevensports";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:18:"videodetective.com";s:14:"videodetective";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:13:"xboxclips.com";s:9:"xboxclips";s:12:"gamerdvr.com";s:7:"xboxdvr";s:11:"xboxdvr.com";s:7:"xboxdvr";s:9:"youku.com";s:5:"youku";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:121:{s:7:"abcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:68:"!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}}i:1;a:0:{}}s:6:"amazon";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:1;R:175;}i:1;a:2:{i:0;s:50:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|in|it|jp|uk)#";i:1;a:2:{i:0;s:0:"";i:1;s:3:"tld";}}}i:1;R:178;}s:6:"anchor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"@anchor.fm/[-\\w]+/episodes/(?:[-\\w]+-)(?\'id\'\\w+)(?![-\\w])@";i:1;R:175;}}i:1;R:178;}s:9:"audioboom";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:9:"audiomack";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"!audiomack\\.com/(?\'mode\'album|song)/(?\'id\'[-\\w]+/[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:2:"id";}}}i:1;R:178;}s:8:"bandcamp";a:2:{i:0;R:178;i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:210;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:216;}}}}}s:7:"bbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"@bbc\\.co(?:m|\\.uk)/news/av/embed/(?\'id\'[-\\\\\\w/]+)@";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:62:"@bbc\\.co(?:m|\\.uk)\\\\?/news\\\\?/av\\\\?/embed\\\\?/(?\'id\'[-\\\\\\w/]+)@";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:60:"@bbc\\.co(?:m|\\.uk)/news/(?:av(?!/embed)|video_and_audio)/\\w@";i:1;R:216;}}}}}s:8:"bitchute";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"@bitchute\\.com/video/(?\'id\'\\w+)@";i:1;R:175;}}i:1;R:178;}s:14:"bleacherreport";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!id="video-(?\'id\'[-\\w]+)!";i:1;R:175;}i:1;a:2:{i:0;s:31:"!video_embed\\?id=(?\'id\'[-\\w]+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!/articles/.!";i:1;R:216;}}}}}s:5:"break";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!break\\.com/video/.*-(?\'id\'\\d+)$!";i:1;R:175;}}i:1;R:178;}s:10:"brightcove";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:107:"@link\\.brightcove\\.com/services/player/bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bckey";i:3;s:5:"bctid";}}i:1;a:2:{i:0;s:65:"@players\\.brightcove\\.net/(?\'bcpid\'\\d+)/.*?videoId=(?\'bctid\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}i:1;R:178;}s:7:"cbsnews";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"#cbsnews\\.com/videos?/(?!watch/)(?\'id\'[-\\w]+)#";i:1;R:175;}i:1;a:2:{i:0;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:1;R:175;}}i:1;R:178;}s:4:"cnbc";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!byGuid=(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"!cnbc\\.com/video/20\\d\\d/\\d\\d/\\d\\d/\\w!";i:1;R:216;}}}}}s:3:"cnn";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;R:175;}i:1;a:2:{i:0;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:1;R:175;}}i:1;R:178;}s:8:"cnnmoney";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:1;R:175;}}i:1;R:178;}s:12:"collegehumor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!collegehumor\\.com/(?:video|embed)/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:13:"comedycentral";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;R:216;}}}}}s:4:"coub";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:1;R:175;}}i:1;R:178;}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;R:175;}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:175;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:178;}s:12:"democracynow";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;R:216;}}}}}s:7:"dumpert";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!dumpert\\.nl/mediabase/(?\'id\'\\d+[/_]\\w+)!";i:1;R:175;}}i:1;R:178;}s:11:"eighttracks";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!8tracks\\.com/[-\\w]+/\\D!";i:1;R:216;}}}}}s:4:"espn";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:1;R:175;}}i:1;R:178;}s:8:"facebook";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:135:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:175;}i:1;a:2:{i:0;s:54:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'post|video)s?/@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:46:"@facebook\\.com/video/(?\'type\'post|video)\\.php@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}}i:1;R:178;}s:6:"flickr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"@flickr\\.com/photos/[^/]+/(?\'id\'\\d+)@";i:1;R:175;}i:1;a:2:{i:0;s:33:"@flic\\.kr/(?!p/)[^/]+/(?\'id\'\\d+)@";i:1;R:175;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;R:386;}s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"@flic\\.kr/p/(?\'short\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:5:"short";}}}s:3:"url";s:52:"https://www.flickr.com/photo.gne?rb=1&short={@short}";}}}s:7:"foxnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:9:"foxsports";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"@BKQ29B/(?\'id\'\\w+)@";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:11:"@/video/\\d@";i:1;R:216;}}}}}s:10:"funnyordie";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:1;R:175;}}i:1;R:178;}s:8:"gamespot";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:1;R:175;}}i:1;R:178;}s:12:"gametrailers";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:18:"!embed/(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:51:"!gametrailers\\.com/(?:full-episode|review|video)s/!";i:1;R:216;}}}}}s:5:"getty";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:20:"!gty\\.im/(?\'id\'\\d+)!";i:1;R:175;}i:1;a:2:{i:0;s:47:"!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!";i:1;R:175;}i:2;a:2:{i:0;s:30:"!#[-\\w]*picture-id(?\'id\'\\d+)$!";i:1;R:175;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:4:{i:0;a:2:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"height";}}i:1;a:2:{i:0;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"width";}}i:2;a:2:{i:0;s:29:"!\\bid[=:][\'"]?(?\'et\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"et";}}i:3;a:2:{i:0;s:31:"!\\bsig[=:][\'"]?(?\'sig\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"sig";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:2:"//";i:1;R:216;}}s:3:"url";s:42:"http://embed.gettyimages.com/preview/{@id}";}}}s:6:"gfycat";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?(?\'id\'\\w+)#";i:1;R:175;}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:17:"!/ifr/(?\'id\'\\w+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:87:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?[a-z]#";i:1;R:216;}}s:3:"url";s:28:"https://gfycat.com/ifr/{@id}";}i:1;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!"height":(?\'height\'\\d+)!";i:1;R:443;}i:1;a:2:{i:0;s:23:"!"width":(?\'width\'\\d+)!";i:1;R:448;}}s:5:"match";R:461;s:3:"url";s:61:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}";}}}s:4:"gifs";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:1;R:175;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;R:448;}i:1;a:2:{i:0;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";i:1;R:443;}}s:5:"match";R:461;s:3:"url";s:26:"https://gifs.com/gif/{@id}";}}}s:4:"gist";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"!gist\\.github\\.com/(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)!";i:1;R:175;}}i:1;R:178;}s:10:"globalnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:502;s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!globalnews\\.ca/video/rd/!";i:1;R:216;}}}}}s:8:"gofundme";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:1;R:175;}}i:1;R:178;}s:11:"googledrive";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!";i:1;R:175;}}i:1;R:178;}s:10:"googleplus";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}i:1;R:178;}s:12:"googlesheets";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:76:"@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|(?:[^e]/)+)(?\'id\'(?:e/)?[-\\w]+)@";i:1;R:175;}i:1;a:2:{i:0;s:17:"@oid=(?\'oid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"oid";}}i:2;a:2:{i:0;s:18:"@#gid=(?\'gid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"gid";}}i:3;a:2:{i:0;s:20:"@/pub(?\'type\'chart)@";i:1;R:381;}}i:1;R:178;}s:4:"hudl";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:2:{i:0;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:1;R:547;}i:2;a:2:{i:0;s:37:"@hudl\\.com/video/(?\'id\'\\w+)(?![\\w/])@";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;R:551;i:1;R:553;}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!hudl\\.com/v/!";i:1;R:216;}}}}}s:4:"hulu";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!eid=(?\'id\'[-\\w]+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:18:"!hulu\\.com/watch/!";i:1;R:216;}}}}}s:3:"ign";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:40:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!i";i:1;R:175;}}i:1;R:178;}s:4:"imdb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!imdb\\.com/[/\\w]+/vi(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:5:"imgur";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:25:"@imgur\\.com/(?\'id\'a/\\w+)@";i:1;R:175;}i:1;a:2:{i:0;s:38:"@i\\.imgur\\.com/(?\'id\'\\w{5,7})[lms]?\\.@";i:1;R:175;}i:2;a:2:{i:0;s:33:"@imgur\\.com/(?\'id\'\\w+)(?![\\w./])@";i:1;R:175;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"@data-id="(?\'id\'[\\w/]+)"@";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:63:"@imgur\\.com/(?![art]/|user/)(?\'path\'(?:gallery/)?\\w+)(?![\\w.])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:3:"url";s:45:"https://api.imgur.com/oembed.xml?url=/{@path}";}}}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:175;}}i:1;R:178;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!instagram\\.com/(?:p|tv)/(?\'id\'[-\\w]+)!";i:1;R:175;}}i:1;R:178;}s:15:"internetarchive";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;R:175;}i:1;a:2:{i:0;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:1;R:448;}i:2;a:2:{i:0;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";i:1;R:443;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!archive\\.org/(?:details|embed)/!";i:1;R:216;}}}}}s:8:"izlesene";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:10:"jwplatform";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:1;R:175;}}i:1;R:178;}s:3:"khl";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;R:216;}}}}}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:178;}s:6:"libsyn";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;R:216;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:216;}}}}}s:10:"livestream";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:2:{i:0;s:26:"!/videos/(?\'video_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:2:{i:0;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;R:670;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@livestream\\.com/(?!accounts/\\d+/events/\\d)@";i:1;R:216;}}}i:1;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:1;R:681;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!livestre.am!";i:1;R:216;}}}}}s:6:"mailru";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!"itemId": ?"?(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;R:216;}}}}}s:6:"medium";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:54:"!medium\\.com/(?:s/)?[^/]*/(?:[-\\w]+-)?(?\'id\'[\\da-f]+)!";i:1;R:175;}}i:1;R:178;}s:9:"megaphone";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:46:"@megaphone\\.fm/.*?\\?(?:e|selected)=(?\'id\'\\w+)@";i:1;R:175;}i:1;a:2:{i:0;s:50:"@(?:dcs|player|traffic)\\.megaphone\\.fm/(?\'id\'\\w+)@";i:1;R:175;}i:2;a:2:{i:0;s:28:"@megaphone\\.link/(?\'id\'\\w+)@";i:1;R:175;}}i:1;R:178;}s:8:"metacafe";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:8:"mixcloud";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:1;R:175;}}i:1;R:178;}s:5:"mixer";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#mixer.com/(?!browse/)(?\'channel\'\\w+)(?!\\?clip|\\w)(?:\\?vod=(?\'vod\'[-\\w]+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:3:"vod";}}}i:1;R:178;}s:3:"mlb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"#mlb\\.com/video/(?:[-\\w/]+/)?(?:c-|v|[-\\w]+-c)(?\'id\'\\d+)#";i:1;R:175;}}i:1;R:178;}s:5:"mrctv";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;R:216;}}}}}s:5:"msnbc";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:39:"@"video":\\{"current".*?id":"(?\'id\'\\w+)@";i:1;R:175;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;R:216;}i:1;a:2:{i:0;s:18:"@on\\.msnbc\\.com/.@";i:1;R:216;}}}}}s:13:"natgeochannel";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:1;R:175;}}i:1;R:178;}s:11:"natgeovideo";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;R:216;}}}}}s:7:"nbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:9:"nbcsports";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!select/media/(?\'id\'\\w+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!nbcsports\\.com/video/.!";i:1;R:216;}}}}}s:3:"nhl";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}}i:1;R:178;}s:3:"npr";a:2:{i:0;R:178;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:1:"i";i:2;s:1:"m";}}}s:6:"header";s:45:"Cookie: trackingChoice=false; choiceVersion=1";s:5:"match";a:2:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;R:216;}i:1;a:2:{i:0;s:10:"!n\\.pr/\\w!";i:1;R:216;}}}}}s:7:"nytimes";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;R:175;}i:1;a:2:{i:0;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:1;R:175;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:26:"!/video/movies/(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"playlist";}}}s:3:"url";s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}}s:6:"orfium";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:24:"@album/(?\'album_id\'\\d+)@";i:1;R:210;}i:1;a:2:{i:0;s:30:"@playlist/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:25:"@live-set/(?\'set_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:6:"set_id";}}i:3;a:2:{i:0;s:24:"@track/(?\'track_id\'\\d+)@";i:1;R:229;}}i:1;R:178;}s:8:"pastebin";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:1;R:175;}}i:1;R:178;}s:9:"pinterest";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:1;R:175;}i:1;a:2:{i:0;s:84:"@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@";i:1;R:175;}}i:1;R:178;}s:7:"podbean";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!podbean\\.com/media/(?:player/|share/pb-)(?\'id\'[-\\w]+)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:41:"!podbean\\.com/media/player/(?\'id\'[-\\w]+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"@podbean\\.com/(?:media/shar)?e/(?!pb-)@";i:1;R:216;}}}}}s:5:"prezi";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:1;R:175;}}i:1;R:178;}s:6:"reddit";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!(?\'id\'\\w+/comments/\\w+(?:/\\w+/\\w+)?)!";i:1;R:175;}}i:1;R:178;}s:6:"rutube";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rutube\\.ru/tracks/(?\'id\'\\d+)!";i:1;R:175;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!rutube\\.ru/play/embed/(?\'id\'\\d+)!";i:1;R:175;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"!rutube\\.ru/video/(?\'vid\'[0-9a-f]{32})!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}s:3:"url";s:64:"http://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/";}}}s:6:"scribd";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:67:"!scribd\\.com/(?:mobile/)?(?:doc(?:ument)?|presentation)/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:7:"sendvid";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!sendvid\\.com/(?\'id\'\\w+)!";i:1;R:175;}}i:1;R:178;}s:10:"slideshare";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!"presentationId":(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@slideshare\\.net/[^/]+/\\w(?![-\\w]+-\\d{6,}$)@";i:1;R:216;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:175;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;R:835;}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:229;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:216;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:835;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;R:216;}}}}}s:7:"sporcle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"#sporcle.com/framed/.*?gid=(?\'id\'\\w+)#";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"#encodedGameID\\W+(?\'id\'\\w+)#";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"#sporcle\\.com/games/(?!\\w*category/)[-\\w]+/[-\\w]#";i:1;R:216;}}}}}s:9:"sportsnet";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"/vid(?:eoId)?=(?\'id\'\\d+)/";i:1;R:175;}i:1;a:2:{i:0;s:46:"/param name="@videoPlayer" value="(?\'id\'\\d+)"/";i:1;R:175;}}s:5:"match";R:461;}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:102:"!(?:open|play)\\.spotify\\.com/(?\'id\'(?:user/[-.\\w]+/)?(?:album|artist|playlist|track)(?:[:/][-.\\w]+)+)!";i:1;R:175;}}i:1;R:178;}s:8:"spreaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!spreaker\\.com/episode/(?\'episode_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:10:"episode_id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!episode_id=(?\'episode_id\'\\d+)!";i:1;R:974;}i:1;a:2:{i:0;s:25:"!show_id=(?\'show_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:7:"show_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!(?\'url\'.+/(?:show/|user/.+/).+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"url";}}}s:3:"url";s:54:"https://api.spreaker.com/oembed?format=json&url={@url}";}}}s:10:"steamstore";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:8:"stitcher";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:23:"!data-eid="(?\'eid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"eid";}}i:1;a:2:{i:0;s:23:"!data-fid="(?\'fid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"fid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:11:"!/podcast/!";i:1;R:216;}}}}}s:9:"strawpoll";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:10:"streamable";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"!streamable\\.com/(?\'id\'\\w+)!";i:1;R:175;}}i:1;R:178;}s:8:"streamja";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@streamja\\.com/(?!login|signup|terms|videos)(?\'id\'\\w+)@";i:1;R:175;}}i:1;R:178;}s:8:"teamcoco";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:20:"!embed/v/(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!teamcoco\\.com/video/\\D!";i:1;R:216;}}}}}s:3:"ted";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:1;R:175;}}i:1;R:178;}s:8:"telegram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"@//t.me/(?!addstickers/|joinchat/)(?\'id\'\\w+/\\d+)@";i:1;R:175;}}i:1;R:178;}s:11:"theatlantic";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:11:"theguardian";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!theguardian\\.com/(?\'id\'\\w+/video/20(?:0[0-9]|1[0-7])[-/\\w]+)!";i:1;R:175;}}i:1;R:178;}s:8:"theonion";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:6:"tiktok";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:47:"@tiktok\\.com/(?:v|i18n/share/video)/(?\'id\'\\d+)@";i:1;R:175;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:26:"@tiktok\\.com/v/(?\'id\'\\d+)@";i:1;R:175;}i:1;a:2:{i:0;s:36:"@musically://musical\\?id=(?\'id\'\\d+)@";i:1;R:175;}}s:6:"header";s:15:"User-agent: PHP";s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"@//vm\\.tiktok\\.com/.@";i:1;R:216;}}}}}s:3:"tmz";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:1;R:175;}}i:1;R:178;}s:13:"traileraddict";a:2:{i:0;R:178;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;R:216;}}}}}s:13:"trendingviews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:56:"!trendingviews.co/(?:video|embed)/(?:[^/]+-)?(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:6:"tumblr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:27:"!did=\\\\u0022(?\'did\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"did";}}i:1;a:2:{i:0;s:31:"!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"key";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;R:216;}}s:3:"url";s:73:"http://www.tumblr.com/oembed/1.0?url=http://{@name}.tumblr.com/post/{@id}";}}}s:21:"twentyfoursevensports";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!247sports\\.com/PlayerSport/[-\\w]*?(?\'player_id\'\\d+)/Embed!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"player_id";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";R:1117;s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!247sports\\.com/Player/[-\\w]*?\\d!";i:1;R:216;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!player_id%3D(?\'video_id\'\\d+)!";i:1;R:676;}}s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!247sports\\.com/Video/.!";i:1;R:216;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;R:676;}i:1;a:2:{i:0;s:44:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:7:"channel";}}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:334;}i:3;a:2:{i:0;s:56:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'\\w+)#";i:1;R:681;}}i:1;R:178;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@twitter\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:175;}}i:1;R:178;}s:7:"ustream";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:1;R:888;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!embed/(?\'cid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"cid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;R:216;}}}}}s:5:"vbox7";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:1;R:175;}}i:1;R:178;}s:4:"veoh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:1;R:175;}}i:1;R:178;}s:4:"vevo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!vevo\\.com/watch/(.*?/)?(?\'id\'[A-Z]+\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}}i:1;R:178;}s:14:"videodetective";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:1;R:175;}}i:1;R:178;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:175;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:334;}}i:1;R:178;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:175;}}i:1;R:178;}s:2:"vk";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:97:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}i:1;a:2:{i:0;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:1;R:1203;}}i:1;R:178;}s:7:"vocaroo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!vocaroo\\.com/i/(?\'id\'\\w+)!";i:1;R:175;}}i:1;R:178;}s:3:"vox";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:1;R:175;}}i:1;R:178;}s:14:"washingtonpost";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:1;R:175;}i:1;a:2:{i:0;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:1;R:175;}}i:1;R:178;}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:18:"!v: ?"?(?\'id\'\\d+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:216;}}}}}s:3:"wsj";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;R:175;}i:1;a:2:{i:0;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:1;R:175;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;R:216;}}}}}s:9:"xboxclips";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:65:"@xboxclips\\.com/(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}}i:1;R:178;}s:7:"xboxdvr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!(?:gamer|xbox)dvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:1;R:1254;}}i:1;R:178;}s:5:"youku";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+=*)!";i:1;R:175;}}i:1;R:178;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:69:"!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:175;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:175;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:334;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!/vi/(?\'id\'[-\\w]+)!";i:1;R:175;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!/shared\\?ci=!";i:1;R:216;}}}}}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:1:{i:0;i:771;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:122:{s:7:"ABCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:178;}}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:1:{i:0;i:256;}}s:6:"AMAZON";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1294;s:3:"tld";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:6:"ANCHOR";R:1292;s:9:"AUDIOBOOM";R:1292;s:9:"AUDIOMACK";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1294;s:4:"mode";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1294;s:8:"track_id";R:1294;s:9:"track_num";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"BBCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:12:"stripslashes";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:8:"BITCHUTE";R:1292;s:14:"BLEACHERREPORT";R:1292;s:5:"BREAK";R:1292;s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:3:{s:5:"bckey";R:1294;s:5:"bcpid";R:1294;s:5:"bctid";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"CBSNEWS";R:1292;s:4:"CNBC";R:1292;s:3:"CNN";R:1292;s:8:"CNNMONEY";R:1292;s:12:"COLLEGEHUMOR";R:1292;s:13:"COMEDYCENTRAL";R:1292;s:4:"COUB";R:1292;s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1294;s:1:"t";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:12:"DEMOCRACYNOW";R:1292;s:7:"DUMPERT";R:1292;s:11:"EIGHTTRACKS";R:1292;s:4:"ESPN";R:1292;s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1294;s:4:"type";R:1294;s:4:"user";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:6:"FLICKR";R:1292;s:7:"FOXNEWS";R:1292;s:9:"FOXSPORTS";R:1292;s:10:"FUNNYORDIE";R:1292;s:8:"GAMESPOT";R:1292;s:12:"GAMETRAILERS";R:1292;s:5:"GETTY";a:7:{s:10:"attributes";a:5:{s:2:"et";R:1294;s:6:"height";a:3:{s:12:"defaultValue";i:360;s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";R:1332;}}s:8:"required";b:0;}s:2:"id";R:1294;s:3:"sig";R:1294;s:5:"width";a:3:{s:12:"defaultValue";i:640;s:11:"filterChain";R:1357;s:8:"required";b:0;}}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:6:"GFYCAT";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1355;s:2:"id";R:1294;s:5:"width";R:1361;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:4:"GIFS";R:1367;s:4:"GIST";R:1292;s:10:"GLOBALNEWS";R:1292;s:8:"GOFUNDME";R:1292;s:11:"GOOGLEDRIVE";R:1292;s:10:"GOOGLEPLUS";a:7:{s:10:"attributes";a:3:{s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";R:1332;}}s:8:"required";b:0;}s:3:"oid";R:1294;s:3:"pid";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:12:"GOOGLESHEETS";a:7:{s:10:"attributes";a:4:{s:3:"gid";R:1294;s:2:"id";R:1294;s:3:"oid";R:1294;s:4:"type";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:4:"HUDL";a:7:{s:10:"attributes";a:3:{s:7:"athlete";R:1294;s:9:"highlight";R:1294;s:2:"id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:4:"HULU";R:1292;s:3:"IGN";R:1292;s:4:"IMDB";R:1292;s:5:"IMGUR";R:1292;s:9:"INDIEGOGO";R:1292;s:9:"INSTAGRAM";R:1292;s:15:"INTERNETARCHIVE";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1355;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:23:"htmlspecialchars_decode";s:6:"params";R:1332;}}s:8:"required";b:0;}s:5:"width";R:1361;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:8:"IZLESENE";R:1292;s:10:"JWPLATFORM";R:1292;s:3:"KHL";R:1292;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:1294;s:2:"id";R:1294;s:5:"video";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:6:"LIBSYN";R:1292;s:8:"LIVELEAK";R:1292;s:10:"LIVESTREAM";a:7:{s:10:"attributes";a:5:{s:10:"account_id";R:1294;s:7:"channel";R:1294;s:7:"clip_id";R:1294;s:8:"event_id";R:1294;s:8:"video_id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:6:"MAILRU";R:1292;s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:178;s:9:"bitNumber";i:0;s:7:"allowed";a:1:{i:0;i:770;}}s:6:"MEDIUM";R:1292;s:9:"MEGAPHONE";R:1292;s:8:"METACAFE";R:1292;s:8:"MIXCLOUD";R:1292;s:5:"MIXER";a:7:{s:10:"attributes";a:2:{s:7:"channel";R:1294;s:3:"vod";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:3:"MLB";R:1292;s:5:"MRCTV";R:1292;s:5:"MSNBC";R:1292;s:13:"NATGEOCHANNEL";R:1292;s:11:"NATGEOVIDEO";R:1292;s:7:"NBCNEWS";R:1292;s:9:"NBCSPORTS";R:1292;s:3:"NHL";a:7:{s:10:"attributes";a:2:{s:1:"c";R:1294;s:1:"t";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:3:"NPR";a:7:{s:10:"attributes";a:2:{s:1:"i";R:1294;s:1:"m";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"NYTIMES";R:1292;s:6:"ORFIUM";a:7:{s:10:"attributes";a:4:{s:8:"album_id";R:1294;s:11:"playlist_id";R:1294;s:6:"set_id";R:1294;s:8:"track_id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:8:"PASTEBIN";R:1292;s:9:"PINTEREST";R:1292;s:7:"PODBEAN";R:1292;s:5:"PREZI";R:1292;s:6:"REDDIT";R:1292;s:6:"RUTUBE";R:1292;s:6:"SCRIBD";R:1292;s:7:"SENDVID";R:1292;s:10:"SLIDESHARE";R:1292;s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:1294;s:11:"playlist_id";R:1294;s:12:"secret_token";R:1294;s:8:"track_id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"SPORCLE";R:1292;s:9:"SPORTSNET";R:1292;s:7:"SPOTIFY";R:1292;s:8:"SPREAKER";a:7:{s:10:"attributes";a:2:{s:10:"episode_id";R:1294;s:7:"show_id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:10:"STEAMSTORE";R:1292;s:8:"STITCHER";a:7:{s:10:"attributes";a:2:{s:3:"eid";R:1294;s:3:"fid";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:9:"STRAWPOLL";R:1292;s:10:"STREAMABLE";R:1292;s:8:"STREAMJA";R:1292;s:8:"TEAMCOCO";R:1292;s:3:"TED";R:1292;s:8:"TELEGRAM";R:1292;s:11:"THEATLANTIC";R:1292;s:11:"THEGUARDIAN";R:1292;s:8:"THEONION";R:1292;s:6:"TIKTOK";R:1292;s:3:"TMZ";R:1292;s:13:"TRAILERADDICT";R:1292;s:13:"TRENDINGVIEWS";R:1292;s:6:"TUMBLR";a:7:{s:10:"attributes";a:4:{s:3:"did";R:1294;s:2:"id";R:1294;s:3:"key";R:1294;s:4:"name";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:21:"TWENTYFOURSEVENSPORTS";a:7:{s:10:"attributes";a:2:{s:9:"player_id";R:1294;s:8:"video_id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:1294;s:7:"clip_id";R:1294;s:1:"t";R:1294;s:8:"video_id";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"TWITTER";R:1292;s:7:"USTREAM";a:7:{s:10:"attributes";a:2:{s:3:"cid";R:1294;s:3:"vid";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:5:"VBOX7";R:1292;s:4:"VEOH";R:1292;s:4:"VEVO";R:1292;s:14:"VIDEODETECTIVE";R:1292;s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1294;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:1332;}}s:8:"required";b:0;}}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:4:"VINE";R:1292;s:2:"VK";a:7:{s:10:"attributes";a:3:{s:4:"hash";R:1294;s:3:"oid";R:1294;s:3:"vid";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"VOCAROO";R:1292;s:3:"VOX";R:1292;s:14:"WASHINGTONPOST";R:1292;s:4:"WSHH";R:1292;s:3:"WSJ";R:1292;s:9:"XBOXCLIPS";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1294;s:4:"user";R:1294;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}s:7:"XBOXDVR";R:1499;s:5:"YOUKU";R:1292;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:4:"list";R:1294;s:1:"t";R:1486;}s:11:"filterChain";R:1296;s:12:"nestingLimit";i:10;s:5:"rules";R:1305;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1309;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:9:{s:20:"AMAZON_ASSOCIATE_TAG";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_CA";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_DE";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_ES";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_FR";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IN";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IT";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_JP";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_UK";s:0:"";}}');
	}
}