<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'en-gb',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 day',
	'1_MONTH'		=> '1 month',
	'1_YEAR'		=> '1 year',
	'2_WEEKS'		=> '2 weeks',
	'3_MONTHS'		=> '3 months',
	'6_MONTHS'		=> '6 months',
	'7_DAYS'		=> '7 days',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Your account has already been activated.',
	'ACCOUNT_DEACTIVATED'			=> 'Your account has been manually deactivated and is only able to be reactivated by an administrator.',
	'ACP'							=> 'Administration Control Panel',
	'ACP_SHORT'						=> 'ACP',
	'ACTIVE'						=> 'active',
	'ACTIVE_ERROR'					=> 'The specified username is currently inactive. If you have problems activating your account, please contact a board administrator.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administrators',
	'AGE'							=> 'Age',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'AJAX error',
	'AJAX_ERROR_TEXT'				=> 'Something went wrong when processing your request.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'User aborted request.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Your request timed out; please try again.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Something went wrong with the request and the server returned an invalid reply.',
	'ALLOWED'						=> 'Allowed',
	'ALL_FILES'						=> 'All files',
	'ALL_FORUMS'					=> 'All forums',
	'ALL_MESSAGES'					=> 'All messages',
	'ALL_POSTS'						=> 'All posts',
	'ALL_TIMES'						=> 'All times are <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'All Topics',
	'ALT_TEXT'						=> 'Alternative text',
	'AND'							=> 'And',
	'ARE_WATCHING_FORUM'			=> 'You have subscribed to be notified of new posts in this forum.',
	'ARE_WATCHING_TOPIC'			=> 'You have subscribed to be notified of new posts in this topic.',
	'ASCENDING'						=> 'Ascending',
	'ATTACHMENTS'					=> 'Attachments',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'The image file you tried to attach is invalid.',
	'AUTHOR'						=> 'Author',
	'AUTH_NO_PROFILE_CREATED'		=> 'The creation of a user profile was unsuccessful.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'This external service is already associated with another board account.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Invalid database entry.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Invalid service type provided to OAuth service handler.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Something went wrong when processing your OAuth request.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'OAuth service not created',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'OAuth token not stored.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'OAuth token incorrectly stored.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'The upload was rejected because the uploaded file was identified as a possible attack vector.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'This file cannot be displayed because the extension <strong>%s</strong> is not allowed.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'The specified avatar could not be uploaded because the remote data appears to be invalid or corrupted.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'The uploaded avatar file is empty.',
	'AVATAR_INVALID_FILENAME'		=> '%s is an invalid filename.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatar could not be uploaded.',
	'AVATAR_NO_TEMP_DIR'			=> 'Temporary folder could not be found or is not writable.',
	'AVATAR_NO_SIZE'				=> 'The width or height of the linked avatar could not be determined. Please enter them manually.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'Avatar storage path does not exist or is not writable.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'Avatar uploading is enabled but avatar storage path is not set.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'The specified file was only partially uploaded.',
	'AVATAR_PHP_SIZE_NA'			=> 'The avatar’s filesize is too large.<br />The maximum allowed filesize set in php.ini could not be determined.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'The avatar’s filesize is too large. The maximum allowed upload size is %1$d %2$s.<br />Please note this is set in php.ini and cannot be overridden.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'The specified avatar could not be uploaded because the request timed out.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'A PHP extension has stopped the file upload.',
	'AVATAR_URL_INVALID'			=> 'The URL you specified is invalid.',
	'AVATAR_URL_NOT_FOUND'			=> 'The file specified could not be found.',
	'AVATAR_WRONG_FILESIZE'			=> 'The avatar’s filesize must be between 0 and %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'The submitted avatar is %5$s wide and %6$s high. Avatars must be at least %1$s wide and %2$s high, but no larger than %3$s wide and %4$s high.',

	'BACK_TO_TOP'			=> 'Top',
	'BACK_TO_PREV'			=> 'Back to previous page',
	'BAN_TRIGGERED_BY_EMAIL'=> 'A ban has been issued on your email address.',
	'BAN_TRIGGERED_BY_IP'	=> 'A ban has been issued on your IP address.',
	'BAN_TRIGGERED_BY_USER'	=> 'A ban has been issued on your username.',
	'BBCODE_GUIDE'			=> 'BBCode guide',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Birthdays',
	'BOARD_BAN_PERM'		=> 'You have been <strong>permanently</strong> banned from this board.<br /><br />Please contact the %2$sBoard Administrator%3$s for more information.',
	'BOARD_BAN_REASON'		=> 'Reason given for ban: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'You have been banned from this board until <strong>%1$s</strong>.<br /><br />Please contact the %2$sBoard Administrator%3$s for more information.',
	'BOARD_DISABLE'			=> 'Sorry but this board is currently unavailable.',
	'BOARD_DISABLED'		=> 'This board is currently disabled.',
	'BOARD_UNAVAILABLE'		=> 'Sorry but the board is temporarily unavailable, please try again in a few minutes.',
	'BROWSING_FORUM'		=> 'Users browsing this forum: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Users browsing this forum: %2$s and %1$d guest',
		2	=> 'Users browsing this forum: %2$s and %1$d guests',
	),
	'BUTTON_DELETE'         => 'Delete',
	'BUTTON_EDIT'			=> 'Edit',
	'BUTTON_FORUM_LOCKED'	=> 'Locked',
	'BUTTON_INFORMATION'    => 'Information',
	'BUTTON_NEW_TOPIC'		=> 'New Topic',
	'BUTTON_PM'				=> 'PM',
	'BUTTON_PM_FORWARD'		=> 'Forward',
	'BUTTON_PM_NEW'			=> 'New PM',
	'BUTTON_PM_REPLY'		=> 'Send Reply',
	'BUTTON_PM_REPLY_ALL'	=> 'Reply All',
	'BUTTON_POST_REPLY'		=> 'Post Reply',
	'BUTTON_QUOTE'			=> 'Quote',
	'BUTTON_REPORT'         => 'Report',
	'BUTTON_TOPIC_LOCKED'	=> 'Locked',
	'BUTTON_WARN'           => 'Warn',
	'BYTES'					=> 'Bytes',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Cancel',
	'CHANGE'				=> 'Change',
	'CHANGE_FONT_SIZE'		=> 'Change font size',
	'CHANGING_PREFERENCES'	=> 'Changing board preferences',
	'CHANGING_PROFILE'		=> 'Changing profile settings',
	'CHARACTERS'			=> array(
		1	=> '%d character',
		2	=> '%d characters',
	),
	'COLLAPSE_VIEW'			=> 'Collapse view',
	'CLOSE_WINDOW'			=> 'Close window',
	'CODE'					=> 'Code',
	'COLOUR_SWATCH'			=> 'Colour swatch',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirm',
	'CONFIRM_CODE'			=> 'Confirmation code',
	'CONFIRM_CODE_EXPLAIN'	=> 'Enter the code exactly as it appears. All letters are case insensitive.',
	'CONFIRM_CODE_WRONG'	=> 'The confirmation code you entered was incorrect.',
	'CONFIRM_OPERATION'		=> 'Are you sure you wish to carry out this operation?',
	'CONFIRM_AVATAR_DELETE' => 'Are you sure you wish to delete this avatar?',
	'CONGRATULATIONS'		=> 'Congratulations to',
	'CONNECTION_FAILED'		=> 'Connection failed.',
	'CONNECTION_SUCCESS'	=> 'Connection was successful!',
	'CONTACT'				=> 'Contact',
	'CONTACT_USER'			=> 'Contact %s',
	'CONTACT_US'			=> 'Contact us',
	'COOKIE_CONSENT_INFO'	=> 'Learn more',
	'COOKIE_CONSENT_MSG'	=> 'This website uses cookies to ensure you get the best experience on our website.',
	'COOKIE_CONSENT_OK'		=> 'Got it!',
	'COOKIE_CONSENT_HREF'	=> 'http://cookiesandyou.com',
	'COOKIES_DELETED'		=> 'All board cookies successfully deleted.',
	'CURRENT_TIME'			=> 'It is currently %s',

	'DAY'					=> 'Day',
	'DAYS'					=> 'Days',
	'DELETE'				=> 'Delete',
	'DELETE_ALL'			=> 'Delete all',
	'DELETE_COOKIES'		=> 'Delete cookies',
	'DELETE_MARKED'			=> 'Delete marked',
	'DELETE_POST'			=> 'Delete post',
	'DELIMITER'				=> 'Delimiter',
	'DESCENDING'			=> 'Descending',
	'DISABLED'				=> 'Disabled',
	'DISPLAY'				=> 'Display',
	'DISPLAY_GUESTS'		=> 'Display guests',
	'DISPLAY_MESSAGES'		=> 'Display messages from previous',
	'DISPLAY_POSTS'			=> 'Display posts from previous',
	'DISPLAY_TOPICS'		=> 'Display topics from previous',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'The entered email domain has no valid MX record.',
	'DOWNLOADED'			=> 'Downloaded',
	'DOWNLOADING_FILE'		=> 'Downloading file',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Not downloaded yet',
		1	=> 'Downloaded %d time',
		2	=> 'Downloaded %d times',
	),

	'EDIT_POST'							=> 'Edit post',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'Email', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Email address',
	'EMAIL_INVALID_EMAIL'				=> 'The email address you entered is invalid.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ran into problems sending email at <strong>Line %1$s</strong>. Response: %2$s.',
	'EMPTY_SUBJECT'						=> 'You must specify a subject when posting a new topic.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'You must specify a subject when composing a new message.',
	'ENABLED'							=> 'Enabled',
	'ENCLOSURE'							=> 'Enclosure',
	'ENTER_USERNAME'					=> 'Enter username',
	'ERR_CHANGING_DIRECTORY'			=> 'Unable to change directory.',
	'ERR_CONNECTING_SERVER'				=> 'Error connecting to the server.',
	'ERR_JAB_AUTH'						=> 'Could not authorise on Jabber server.',
	'ERR_JAB_CONNECT'					=> 'Could not connect to Jabber server.',
	'ERR_UNABLE_TO_LOGIN'				=> 'The specified username or password is incorrect.',
	'ERR_UNWATCHING'					=> 'An error occurred while trying to unsubscribe.',
	'ERR_WATCHING'						=> 'An error occurred while trying to subscribe.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'The phpBB path specified appears to be invalid.',
	'ERROR'									=> 'Error',
	'EXPAND_VIEW'						=> 'Expand view',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED'				=> 'The extension <strong>%s</strong> is not enabled.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'The extension <strong>%s</strong> has been deactivated and can no longer be displayed.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'The extension <strong>%s</strong> does not exist.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Frequently Asked Questions',
	'FEATURE_NOT_AVAILABLE' => 'The requested feature is not available on this board.',
	'FILENAME'				=> 'Filename',
	'FILESIZE'				=> 'File size',
	'FILEDATE'				=> 'File date',
	'FILE_COMMENT'			=> 'File comment',
	'FILE_CONTENT_ERR'		=> 'Could not read the contents of file: %s',
	'FILE_JSON_DECODE_ERR'	=> 'Failed to decode json file: %s',
	'FILE_NOT_FOUND'		=> 'The requested file could not be found: %s',
	'FIND_USERNAME'			=> 'Find a member',
	'FOLDER'				=> 'Folder',
	'FORGOT_PASS'			=> 'I forgot my password',
	'FORM_INVALID'			=> 'The submitted form was invalid. Try submitting again.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Forums have been marked read.',
	'FORUM_CAT'				=> 'Forum category',
	'FORUM_INDEX'			=> 'Board index',
	'FORUM_LINK'			=> 'Forum link',
	'FORUM_LOCATION'		=> 'Forum location',
	'FORUM_LOCKED'			=> 'Forum locked',
	'FORUM_RULES'			=> 'Forum rules',
	'FORUM_RULES_LINK'		=> 'Please click here to view the forum rules',
	'FROM'					=> 'from',
	'FSOCK_DISABLED'		=> 'The operation could not be completed because the <var>fsockopen</var> function has been disabled or the server being queried could not be found.',
	'FSOCK_TIMEOUT'			=> 'A timeout occurred while reading from the network stream.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'Unable to change file group',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Unable to change file permissions',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'Unable to copy files',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'Unable to create a symlink',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'Unable to create directory',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'Unable to delete files from the system',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'Unable to dump into file',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'Unable to mirror directory',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'Unable to rename a file from the system',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'Unable to create file or change file timestamps',

	'FTP_FSOCK_HOST'				=> 'FTP host',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP server used to connect your site.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP password',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Password for your FTP username.',
	'FTP_FSOCK_PORT'				=> 'FTP port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port used to connect to your server.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Path to phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Path from the root to your phpBB board.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'The amount of time, in seconds, that the system will wait for a reply from your server.',
	'FTP_FSOCK_USERNAME'			=> 'FTP username',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Username used to connect to your server.',

	'FTP_HOST'					=> 'FTP host',
	'FTP_HOST_EXPLAIN'			=> 'FTP server used to connect your site.',
	'FTP_PASSWORD'				=> 'FTP password',
	'FTP_PASSWORD_EXPLAIN'		=> 'Password for your FTP username.',
	'FTP_PORT'					=> 'FTP port',
	'FTP_PORT_EXPLAIN'			=> 'Port used to connect to your server.',
	'FTP_ROOT_PATH'				=> 'Path to phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Path from the root to your phpBB board.',
	'FTP_TIMEOUT'				=> 'FTP timeout',
	'FTP_TIMEOUT_EXPLAIN'		=> 'The amount of time, in seconds, that the system will wait for a reply from your server.',
	'FTP_USERNAME'				=> 'FTP username',
	'FTP_USERNAME_EXPLAIN'		=> 'Username used to connect to your server.',

	'GENERAL_ERROR'				=> 'General Error',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Go',
	'GOTO_FIRST_POST'			=> 'Go to first post',
	'GOTO_LAST_POST'			=> 'Go to last post',
	'GOTO_PAGE'					=> 'Go to page',
	'GROUP'						=> 'Group',
	'GROUPS'					=> 'Groups',
	'GROUP_ERR_TYPE'			=> 'Inappropriate group type specified.',
	'GROUP_ERR_USERNAME'		=> 'No group name specified.',
	'GROUP_ERR_USER_LONG'		=> 'Group names cannot exceed 60 characters. The specified group name is too long.',
	'GUEST'						=> 'Guest',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'There is %d guest user online',
		2	=> 'There are %d guest users online',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d guest',
		2	=> '%d guests',
	),
	'G_ADMINISTRATORS'			=> 'Administrators',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Guests',
	'G_REGISTERED'				=> 'Registered users',
	'G_REGISTERED_COPPA'		=> 'Registered COPPA users',
	'G_GLOBAL_MODERATORS'		=> 'Global moderators',
	'G_NEWLY_REGISTERED'		=> 'Newly registered users',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d hidden user',
		2	=> '%d hidden users',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d hidden',
		2	=> '%d hidden',
	),
	'HIDE_GUESTS'					=> 'Hide guests',
	'HIDE_ME'						=> 'Hide my online status this session',
	'HOURS'							=> 'Hours',
	'HOME'							=> 'Home',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'If',
	'IMAGE'						=> 'Image',
	'IMAGE_FILETYPE_INVALID'	=> 'Image file type %d for mimetype %s not supported.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Image file type mismatch: expected extension %1$s but extension %2$s given.',
	'IN'						=> 'in',
	'INACTIVE'					=> 'Inactive',
	'INDEX'						=> 'Index page',
	'INFORMATION'				=> 'Information',
	'INSECURE_REDIRECT'			=> 'Tried to redirect to potentially insecure url.',
	'INTERESTS'					=> 'Interests',
	'INVALID_DIGEST_CHALLENGE'	=> 'Invalid digest challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> possibly an invalid email address?',
	'INVALID_FEED_ATTACHMENTS'	=> 'The selected feed tried fetching attachments with invalid constraints.',
	'INVALID_PLURAL_RULE'		=> 'The chosen plural rule is invalid. Valid values are integers between 0 and 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Your IP %1$s has been blocked because it is blacklisted. For details please see <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Joined',
	'JUMP_PAGE'				=> 'Enter the page number you wish to go to',
	'JUMP_TO'				=> 'Jump to',
	'JUMP_TO_PAGE'			=> 'Jump to page',
	'JUMP_TO_PAGE_CLICK'	=> 'Click to jump to page…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Last post',
	'LAST_UPDATED'						=> 'Last updated',
	'LAST_VISIT'						=> 'Last visit',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP extension not available.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Could not connect to LDAP server.',
	'LDAP_SEARCH_FAILED'				=> 'An error occurred while searching the LDAP directory.',
	'LEGEND'							=> 'Legend',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Live searches are not allowed.',
	'LOADING'							=> 'Loading',
	'LOCATION'							=> 'Location',
	'LOCK_POST'							=> 'Lock post',
	'LOCK_POST_EXPLAIN'					=> 'Prevent editing',
	'LOCK_TOPIC'						=> 'Lock topic',
	'LOGIN'								=> 'Login',
	'LOGIN_CHECK_PM'					=> 'Log in to check your private messages.',
	'LOGIN_CONFIRMATION'				=> 'Confirmation of login',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'To prevent brute forcing accounts the board requires you to enter a confirmation code after a maximum amount of failed logins. The code is displayed in the image you should see below. If you are visually impaired or cannot otherwise read this code please contact the %sBoard Administrator%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'You exceeded the maximum allowed number of login attempts. In addition to your username and password you now also have to pass the CAPTCHA test.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'You have not been authenticated by Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'A non-existant OAuth service has been requested.',
	'LOGIN_ERROR_PASSWORD'				=> 'You have specified an incorrect password. Please check your password and try again. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'It was not possible to convert your password when updating this bulletin board’s software. Please %srequest a new password%s. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_ERROR_USERNAME'				=> 'You have specified an incorrect username. Please check your username and try again. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_FORUM'						=> 'To view or post in this forum you must enter its password.',
	'LOGIN_INFO'						=> 'In order to login you must be registered. Registering takes only a few moments but gives you increased capabilities. The board administrator may also grant additional permissions to registered users. Before you register please ensure you are familiar with our terms of use and related policies. Please ensure you read any forum rules as you navigate around the board.',
	'LOGIN_VIEWFORUM'					=> 'The board requires you to be registered and logged in to view this forum.',
	'LOGIN_EXPLAIN_EDIT'				=> 'In order to edit posts in this forum you have to be registered and logged in.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'In order to view the online list you have to be registered and logged in.',
	'LOGIN_REQUIRED'					=> 'You need to login to perform this action.',
	'LOGOUT'							=> 'Logout',
	'LOGOUT_USER'						=> 'Logout [ %s ]',
	'LOG_ME_IN'							=> 'Remember me',

	'MAIN'					=> 'Main',
	'MARK'					=> 'Mark',
	'MARK_ALL'				=> 'Mark all',
	'MARK_ALL_READ'			=> 'Mark all read',
	'MARK_FORUMS_READ'		=> 'Mark forums read',
	'MARK_READ'				=> 'Mark read',
	'MARK_SUBFORUMS_READ'	=> 'Mark subforums read',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderator Control Panel',
	'MCP_SHORT'				=> 'MCP',
	'MEMBERLIST'			=> 'Members',
	'MEMBERLIST_EXPLAIN'	=> 'View complete list of members',
	'MERGE'					=> 'Merge',
	'MERGE_POSTS'			=> 'Move posts',
	'MERGE_TOPIC'			=> 'Merge topic',
	'MESSAGE'				=> 'Message',
	'MESSAGES'				=> 'Messages',
	'MESSAGES_COUNT'		=> array(
		1	=> '%d message',
		2	=> '%d messages',
	),
	'MESSAGE_BODY'			=> 'Message body',
	'MINUTES'				=> 'Minutes',
	'MODERATE'				=> 'Moderate',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderators',
	'MODULE_NOT_ACCESS'		=> 'Module not accessible',
	'MODULE_NOT_FIND'		=> 'Cannot find module %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Module file %s does not contain correct class [%s]',
	'MONTH'					=> 'Month',
	'MOVE'					=> 'Move',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Our newest member <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'New message',
	'NEW_MESSAGES'				=> 'New messages',
	'NEW_POST'					=> 'New post',	// Not used anymore
	'NEW_POSTS'					=> 'New posts',	// Not used anymore
	'NEXT'						=> 'Next',		// Used in pagination
	'NEXT_STEP'					=> 'Next',
	'NEVER'						=> 'Never',
	'NO'						=> 'No',
	'NO_NOTIFICATIONS'			=> 'You have no notifications',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'You are not allowed to manage this group.',
	'NOT_AUTHORISED'			=> 'You are not authorised to access this area.',
	'NOT_WATCHING_FORUM'		=> 'You are no longer subscribed to updates on this forum.',
	'NOT_WATCHING_TOPIC'		=> 'You are no longer subscribed to this topic.',
	'NOTIFICATIONS'				=> 'Notifications',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Reply</strong> from %1$s in bookmarked topic:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Group request</strong> from %1$s to join the group %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Group request approved</strong> to join the group %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'The method "%s" does not refer to a valid notification method.',
	'NOTIFICATION_PM'					=> '<strong>Private Message</strong> from %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Reply</strong> from %1$s in topic:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Post approved</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Post disapproved</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Post approval</strong> request by %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Quoted</strong> by %1$s in:',
	),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>Reason:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Private Message reported</strong> by %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Private Message report closed</strong> by %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Post reported</strong> by %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Report closed</strong> by %1$s for:',
	'NOTIFICATION_TOPIC'				=> '<strong>New topic</strong> by %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Topic approved</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Topic disapproved</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Topic approval</strong> request by %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'The notification type "%s" is missing from the file system.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Activation required</strong> for deactivated or newly registered user: “%1$s”',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'others',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d others',
	),
	'NOTIFY_ADMIN'				=> 'Please notify the board administrator or webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Please notify the board administrator or webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'You are not allowed to access this file.',
	'NO_ACTION'					=> 'No action specified.',
	'NO_ADMINISTRATORS'			=> 'There are no administrators.',
	'NO_AUTH_ADMIN'				=> 'Access to the Administration Control Panel is not allowed as you do not have administrative permissions.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'You are not able to re-authenticate as a different user.',
	'NO_AUTH_OPERATION'			=> 'You do not have the necessary permissions to complete this operation.',
	'NO_AVATARS'				=> 'No avatars currently available',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Could not connect to smtp host : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'No birthdays today',
	'NO_EMAIL_MESSAGE'			=> 'Email message was blank.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Could not get mail server response codes.',
	'NO_EMAIL_SUBJECT'			=> 'No email subject specified.',
	'NO_FORUM'					=> 'The forum you selected does not exist.',
	'NO_FORUMS'					=> 'This board has no forums.',
	'NO_GROUP'					=> 'The requested usergroup does not exist.',
	'NO_GROUP_MEMBERS'			=> 'This group currently has no members.',
	'NO_IPS_DEFINED'			=> 'No IP addresses or hostnames defined',
	'NO_MEMBERS'				=> 'No members found for this search criterion.',
	'NO_MESSAGES'				=> 'No messages',
	'NO_MODE'					=> 'No mode specified.',
	'NO_MODERATORS'				=> 'There are no moderators.',
	'NO_NEW_MESSAGES'			=> 'No new messages',
	'NO_NEW_POSTS'				=> 'No new posts',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'No registered users',
	'NO_POSTS'					=> 'No posts',
	'NO_POSTS_TIME_FRAME'		=> 'No posts exist inside this topic for the selected time frame.',
	'NO_FEED_ENABLED'			=> 'Feeds are not available on this board.',
	'NO_FEED'					=> 'The requested feed is not available.',
	'NO_STYLE_DATA'				=> 'Could not get style data for user_style %s and set for user_id %s',
	'NO_STYLE_CFG'				=> 'Could not get the style configuration file for: %s',
	'NO_SUBJECT'				=> 'No subject specified',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'The specified search backend doesn’t exist.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'No supported authentication methods.',
	'NO_TOPIC'					=> 'The requested topic does not exist.',
	'NO_TOPIC_FORUM'			=> 'The topic or forum no longer exists.',
	'NO_TOPICS'					=> 'There are no topics or posts in this forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'No topics exist inside this forum for the selected time frame.',
	'NO_UNREAD_POSTS'			=> 'No unread posts',
	'NO_UPLOAD_FORM_FOUND'		=> 'Upload initiated but no valid file upload form found.',
	'NO_USER'					=> 'The requested user does not exist.',
	'NO_USERS'					=> 'The requested users do not exist.',
	'NO_USER_SPECIFIED'			=> 'No username was specified.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d attachment',
		2	=> '%d attachments',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'No posts in queue',		// 0
		1			=> '1 post in queue',		// 1
		2			=> '%d posts in queue',		// 2+
	),

	'OCCUPATION'				=> 'Occupation',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Online friends',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'In total there is <strong>%1$d</strong> user online :: %2$s and %3$s',
		2	=> 'In total there are <strong>%1$d</strong> users online :: %2$s and %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'In total there is <strong>%1$d</strong> user online :: %2$s, %3$s and %4$s',
		2	=> 'In total there are <strong>%1$d</strong> users online :: %2$s, %3$s and %4$s',
	),
	'OPTIONS'					=> 'Options',

	'PAGE_NOT_FOUND'		=> 'The requested page could not be found.',
	'PAGE_OF'				=> 'Page <strong>%1$d</strong> of <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Page %s',
	'PASSWORD'				=> 'Password',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d pixel',
		2	=> '%d pixels',
	),
	'PLEASE_WAIT'			=> 'Please wait.',
	'PM'					=> 'PM',
	'PM_REPORTED'			=> 'Click to view report',
	'POSTING_MESSAGE'		=> 'Posting message in %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Composing private message',
	'POST'					=> 'Post',
	'POST_ANNOUNCEMENT'		=> 'Announce',
	'POST_STICKY'			=> 'Sticky',
	'POSTED'				=> 'Posted',
	'POSTED_IN_FORUM'		=> 'in',
	'POSTED_ON_DATE'		=> 'on',
	'POSTS'					=> 'Posts',
	'POSTS_UNAPPROVED'		=> 'At least one post in this topic has not been approved.',
	'POSTS_UNAPPROVED_FORUM'=> 'At least one post in this forum has not been approved.',
	'POST_BY_AUTHOR'		=> 'by',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>, who is currently on your ignore list, made this post.',
	'POST_DISPLAY'			=> '%1$sDisplay this post%2$s.',
	'POST_DAY'				=> '%.2f posts per day',
	'POST_DELETED_ACTION'	=> 'Deleted post:',
	'POST_DELETED'			=> 'This post has been deleted.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> deleted the post by <strong>%1$s</strong> on %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> deleted the post by <strong>%1$s</strong> on %3$s for the following reason: %4$s',
	'POST_DETAILS'			=> 'Post details',
	'POST_NEW_TOPIC'		=> 'Post new topic',
	'POST_PCT'				=> '%.2f%% of all posts',
	'POST_PCT_ACTIVE'		=> '%.2f%% of user’s posts',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% of your posts',
	'POST_REPLY'			=> 'Post a reply',
	'POST_REPORTED'			=> 'Click to view report',
	'POST_SUBJECT'			=> 'Post subject',
	'POST_TIME'				=> 'Post time',
	'POST_TOPIC'			=> 'Post a new topic',
	'POST_UNAPPROVED_ACTION'	=> 'Post awaiting approval:',
	'POST_UNAPPROVED'		=> 'This post has not been approved.',
	'POST_UNAPPROVED_EXPLAIN'	=> 'This post is not visible to other users until it has been approved by a moderator.',
	'POWERED_BY'			=> 'Powered by %s',

	'QUOTE'					=> 'Quote',

	'PREVIEW'				=> 'Preview',
	'PREVIOUS'				=> 'Previous',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Previous',
	'PRIVACY'				=> 'Privacy policy',
	'PRIVACY_LINK'			=> 'Privacy',
	'PRIVATE_MESSAGE'		=> 'Private message',
	'PRIVATE_MESSAGES'		=> 'Private messages',
	'PRIVATE_MESSAGING'		=> 'Private messaging',
	'PROFILE'				=> 'User Control Panel',

	'QUICK_LINKS'			=> 'Quick links',

	'RANK'						=> 'Rank',
	'READING_FORUM'				=> 'Viewing topics in %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Reading global announcement',
	'READING_LINK'				=> 'Following forum link %s',
	'READING_TOPIC'				=> 'Reading topic in %s',
	'READ_PROFILE'				=> 'Profile',
	'REASON'					=> 'Reason',
	'RECORD_ONLINE_USERS'		=> 'Most users ever online was <strong>%1$s</strong> on %2$s',
	'REDIRECT'					=> 'Redirect',
	'REDIRECTS'					=> 'Total redirects',
	'REGISTER'					=> 'Register',
	'REGISTERED_USERS'			=> 'Registered users:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'There is %1$d registered user and %2$s online',
		2	=> 'There are %1$d registered users and %2$s online',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d registered',
		2	=> '%d registered',
	),
	'REMOVE'					=> 'Remove',
	'REMOVE_INSTALL'			=> 'Please delete, move or rename the install directory before you use your board. If this directory is still present, only the Administration Control Panel (ACP) will be accessible.',
	'REPLIES'					=> 'Replies',
	'REPLY_WITH_QUOTE'			=> 'Reply with quote',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Replying to global announcement',
	'REPLYING_MESSAGE'			=> 'Replying to message in %s',
	'REPORT_BY'					=> 'Report by',
	'REPORT_POST'				=> 'Report this post',
	'REPORTING_POST'			=> 'Reporting post',
	'RESEND_ACTIVATION'			=> 'Resend activation email',
	'RESET'						=> 'Reset',
	'RESTORE_PERMISSIONS'		=> 'Restore permissions',
	'RETURN_INDEX'				=> '%sReturn to the index page%s',
	'RETURN_FORUM'				=> '%sReturn to the forum last visited%s',
	'RETURN_PAGE'				=> '%sReturn to the previous page%s',
	'RETURN_TOPIC'				=> '%sReturn to the topic last visited%s',
	'RETURN_TO'					=> 'Return to “%s”',
	'RETURN_TO_INDEX'			=> 'Return to Board Index',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'News',
	'FEED_TOPICS_ACTIVE'		=> 'Active Topics',
	'FEED_TOPICS_NEW'			=> 'New Topics',
	'RULES_ATTACH_CAN'			=> 'You <strong>can</strong> post attachments in this forum',
	'RULES_ATTACH_CANNOT'		=> 'You <strong>cannot</strong> post attachments in this forum',
	'RULES_DELETE_CAN'			=> 'You <strong>can</strong> delete your posts in this forum',
	'RULES_DELETE_CANNOT'		=> 'You <strong>cannot</strong> delete your posts in this forum',
	'RULES_DOWNLOAD_CAN'		=> 'You <strong>can</strong> download attachments in this forum',
	'RULES_DOWNLOAD_CANNOT'		=> 'You <strong>cannot</strong> download attachments in this forum',
	'RULES_EDIT_CAN'			=> 'You <strong>can</strong> edit your posts in this forum',
	'RULES_EDIT_CANNOT'			=> 'You <strong>cannot</strong> edit your posts in this forum',
	'RULES_LOCK_CAN'			=> 'You <strong>can</strong> lock your topics in this forum',
	'RULES_LOCK_CANNOT'			=> 'You <strong>cannot</strong> lock your topics in this forum',
	'RULES_POST_CAN'			=> 'You <strong>can</strong> post new topics in this forum',
	'RULES_POST_CANNOT'			=> 'You <strong>cannot</strong> post new topics in this forum',
	'RULES_REPLY_CAN'			=> 'You <strong>can</strong> reply to topics in this forum',
	'RULES_REPLY_CANNOT'		=> 'You <strong>cannot</strong> reply to topics in this forum',
	'RULES_VOTE_CAN'			=> 'You <strong>can</strong> vote in polls in this forum',
	'RULES_VOTE_CANNOT'			=> 'You <strong>cannot</strong> vote in polls in this forum',

	'SEARCH'					=> 'Search',
	'SEARCH_MINI'				=> 'Search…',
	'SEARCH_ADV'				=> 'Advanced search',
	'SEARCH_ADV_EXPLAIN'		=> 'View the advanced search options',
	'SEARCH_KEYWORDS'			=> 'Search for keywords',
	'SEARCHING_FORUMS'			=> 'Searching forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Active topics',
	'SEARCH_FOR'				=> 'Search for',
	'SEARCH_FORUM'				=> 'Search this forum…',
	'SEARCH_NEW'				=> 'New posts',
	'SEARCH_POSTS_BY'			=> 'Search posts by',
	'SEARCH_SELF'				=> 'Your posts',
	'SEARCH_TOPIC'				=> 'Search this topic…',
	'SEARCH_UNANSWERED'			=> 'Unanswered topics',
	'SEARCH_UNREAD'				=> 'Unread posts',
	'SEARCH_USER_POSTS'			=> 'Search user’s posts',
	'SECONDS'					=> 'Seconds',
	'SEE_ALL'					=> 'See All',
	'SELECT'					=> 'Select',
	'SELECT_ALL_CODE'			=> 'Select all',
	'SELECT_DESTINATION_FORUM'	=> 'Please select a destination forum',
	'SELECT_FORUM'				=> 'Select a forum',
	'SEND_EMAIL'				=> 'Send email',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Send email to %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Send private message',
	'SETTINGS'					=> 'Settings',
	'SIGNATURE'					=> 'Signature',
	'SKIP'						=> 'Skip to content',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP server does not support authentication.',
	'SORRY_AUTH_READ'			=> 'You are not authorised to read this forum.',
	'SORRY_AUTH_READ_TOPIC'		=> 'You are not authorised to read this topic.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'You are not authorised to download this attachment.',
	'SORT_BY'					=> 'Sort by',
	'SORT_DIRECTION'			=> 'Direction',
	'SORT_JOINED'				=> 'Joined date',
	'SORT_LOCATION'				=> 'Location',
	'SORT_OPTIONS'				=> 'Display and sorting options',
	'SORT_RANK'					=> 'Rank',
	'SORT_POSTS'				=> 'Posts',
	'SORT_TOPIC_TITLE'			=> 'Topic title',
	'SORT_USERNAME'				=> 'Username',
	'SPLIT_TOPIC'				=> 'Split topic',
	'SQL_ERROR_OCCURRED'		=> 'An SQL error occurred while fetching this page. Please contact the %sBoard Administrator%s if this problem persists.',
	'STATISTICS'				=> 'Statistics',
	'START_WATCHING_FORUM'		=> 'Subscribe forum',
	'START_WATCHING_TOPIC'		=> 'Subscribe topic',
	'STOP_WATCHING_FORUM'		=> 'Unsubscribe forum',
	'STOP_WATCHING_TOPIC'		=> 'Unsubscribe topic',
	'STRING_LIST_MULTI'			=> '%1$s, and %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s and %2$s',
	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subforums',
	'SUBJECT'					=> 'Subject',
	'SUBMIT'					=> 'Submit',

	'TB'				=> 'TB',
	'TERMS_LINK'		=> 'Terms',
	'TERMS_USE'			=> 'Terms of use',
	'TEST_CONNECTION'	=> 'Test connection',
	'THE_TEAM'			=> 'The team',
	'TIB'				=> 'TiB',
	'TIME'				=> 'Time',
	'TIMEOUT_PROCESSING_REQ'			=> 'Request timed out.',

	'TOO_LARGE'						=> 'The value you entered is too large.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'The value of <strong>Maximum number of allowed recipients per private message</strong> setting you entered is too large.',

	'TOO_LONG'						=> 'The value you entered is too long.',

	'TOO_LONG_CONFIRM_CODE'			=> 'The confirm code you entered is too long.',
	'TOO_LONG_DATEFORMAT'			=> 'The date format you entered is too long.',
	'TOO_LONG_JABBER'				=> 'The Jabber account name you entered is too long.',
	'TOO_LONG_NEW_PASSWORD'			=> 'The password you entered is too long.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'The password confirmation you entered is too long.',
	'TOO_LONG_USER_PASSWORD'		=> 'The password you entered is too long.',
	'TOO_LONG_USERNAME'				=> 'The username you entered is too long.',
	'TOO_LONG_EMAIL'				=> 'The email address you entered is too long.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'You have tried to vote for too many options.',

	'TOO_SHORT'						=> 'The value you entered is too short.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'The confirm code you entered is too short.',
	'TOO_SHORT_DATEFORMAT'			=> 'The date format you entered is too short.',
	'TOO_SHORT_JABBER'				=> 'The Jabber account name you entered is too short.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'The password you entered is too short.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'The password confirmation you entered is too short.',
	'TOO_SHORT_USER_PASSWORD'		=> 'The password you entered is too short.',
	'TOO_SHORT_USERNAME'			=> 'The username you entered is too short.',
	'TOO_SHORT_EMAIL'				=> 'The email address you entered is too short.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'The email address confirmation you entered is too short.',
	'TOO_SMALL'						=> 'The value you entered is too small.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'The value of <strong>Maximum number of allowed recipients per private message</strong> setting you entered is too small.',

	'TOPIC'				=> 'Topic',
	'TOPICS'			=> 'Topics',
	'TOPICS_UNAPPROVED'	=> 'At least one topic in this forum has not been approved.',
	'TOPIC_ICON'		=> 'Topic icon',
	'TOPIC_LOCKED'		=> 'This topic is locked, you cannot edit posts or make further replies.',
	'TOPIC_LOCKED_SHORT'=> 'Topic locked',
	'TOPIC_MOVED'		=> 'Moved topic',
	'TOPIC_REVIEW'		=> 'Topic review',
	'TOPIC_TITLE'		=> 'Topic title',
	'TOPIC_UNAPPROVED'	=> 'This topic has not been approved.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Topic awaiting approval',
		2	=> 'Topics awaiting approval',
	),
	'TOPIC_DELETED'		=> 'This topic has been deleted.',
	'TOTAL_ATTACHMENTS'	=> 'Attachment(s)',
	'TOTAL_LOGS'		=> array(
		1	=> '%d log',
		2	=> '%d logs',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d private message in total',
		2	=> '%d private messages in total',
	),
	'TOPIC_POLL'		=> 'This topic has a poll.',
	'TOTAL_POSTS'		=> 'Total posts',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Total posts <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'This topic has been reported',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Total topics <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Total members <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Tracked PHP errors: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'It was not possible to determine the dimensions of the image. Please verify that the URL you entered is correct.',
	'UNABLE_TO_DELIVER_FILE'=> 'Unable to deliver file.',
	'UNKNOWN_BROWSER'		=> 'Unknown browser',
	'UNMARK_ALL'			=> 'Unmark all',
	'UNREAD_MESSAGES'		=> 'Unread messages',
	'UNREAD_POST'			=> 'Unread post',
	'UNREAD_POSTS'			=> 'Unread posts',
	'UNWATCH_FORUM_CONFIRM'		=> 'Are you sure you wish to unsubscribe from this forum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Are you sure you wish to unsubscribe from the forum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Are you sure you wish to unsubscribe from this topic?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Are you sure you wish to unsubscribe from the topic “%s”?',
	'UNWATCHED_FORUMS'			=> 'You are no longer subscribed to the selected forums.',
	'UNWATCHED_TOPICS'			=> 'You are no longer subscribed to the selected topics.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'You are no longer subscribed to the selected entries.',
	'UPDATE'				=> 'Update',
	'UPLOAD_IN_PROGRESS'	=> 'The upload is currently in progress.',
	'URL_REDIRECT'			=> 'If your browser does not support meta redirection %splease click HERE to be redirected%s.',
	'USERGROUPS'			=> 'Groups',
	'USERNAME'				=> 'Username',
	'USERNAMES'				=> 'Usernames',
	'USER_AVATAR'			=> 'User avatar',
	'USER_CANNOT_READ'		=> 'You cannot read posts in this forum.',
	'USER_POSTS'			=> array(
		1	=> '%d Post',
		2	=> '%d Posts',
	),
	'USERS'					=> 'Users',
	'USE_PERMISSIONS'		=> 'Test out user’s permissions',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'We are sorry, but you are not authorised to use this feature. You may have just registered here and may need to participate more in discussions to be able to use this feature.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Viewed',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Not viewed yet',
		1	=> 'Viewed %d time',
		2	=> 'Viewed %d times',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Viewing contact page',
	'VIEWING_FAQ'				=> 'Viewing FAQ',
	'VIEWING_MEMBERS'			=> 'Viewing member details',
	'VIEWING_ONLINE'			=> 'Viewing who is online',
	'VIEWING_MCP'				=> 'Viewing moderator control panel',
	'VIEWING_MEMBER_PROFILE'	=> 'Viewing member profile',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Viewing private messages',
	'VIEWING_REGISTER'			=> 'Registering account',
	'VIEWING_UCP'				=> 'Viewing user control panel',
	'VIEWS'						=> 'Views',
	'VIEW_BOOKMARKS'			=> 'View bookmarks',
	'VIEW_FORUM_LOGS'			=> 'View Logs',
	'VIEW_LATEST_POST'			=> 'View the latest post',
	'VIEW_NEWEST_POST'			=> 'View first unread post',
	'VIEW_NOTES'				=> 'View user notes',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'based on users active over the past %d minute',
		2	=> 'based on users active over the past %d minutes',
	),
	'VIEW_TOPIC'				=> 'View topic',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Announcement: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Global Announcement: ',
	'VIEW_TOPIC_LOCKED'			=> 'Locked: ',
	'VIEW_TOPIC_LOGS'			=> 'View logs',
	'VIEW_TOPIC_MOVED'			=> 'Moved: ',
	'VIEW_TOPIC_POLL'			=> 'Poll: ',
	'VIEW_TOPIC_STICKY'			=> 'Sticky: ',
	'VISIT_WEBSITE'				=> 'Visit website',

	'WARNINGS'			=> 'Warnings',
	'WARN_USER'			=> 'Warn user',
	'WATCH_FORUM_CONFIRM'	=> 'Are you sure you wish to subscribe to this forum?',
	'WATCH_FORUM_DETAILED'	=> 'Are you sure you wish to subscribe to the forum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Are you sure you wish to subscribe to this topic?',
	'WATCH_TOPIC_DETAILED'	=> 'Are you sure you wish to subscribe to the topic “%s”?',
	'WELCOME_SUBJECT'	=> 'Welcome to %s forums',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Who is online',
	'WRONG_PASSWORD'	=> 'You entered an incorrect password.',

	'WRONG_DATA_COLOUR'			=> 'The colour value you entered is invalid.',
	'WRONG_DATA_JABBER'			=> 'The name you entered is not a valid Jabber account name.',
	'WRONG_DATA_LANG'			=> 'The language you specified is not valid.',
	'WRONG_DATA_POST_SD'		=> 'The post sort direction you specified is not valid.',
	'WRONG_DATA_POST_SK'		=> 'The post sort option you specified is not valid.',
	'WRONG_DATA_TOPIC_SD'		=> 'The topic sort direction you specified is not valid.',
	'WRONG_DATA_TOPIC_SK'		=> 'The topic sort option you specified is not valid.',
	'WROTE'						=> 'wrote',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Year',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'Yes',
	'YOU_LAST_VISIT'	=> 'Last visit was: %s',

	'datetime'			=> array(
		'TODAY'		=> 'Today',
		'TOMORROW'	=> 'Tomorrow',
		'YESTERDAY'	=> 'Yesterday',
		'AGO'		=> array(
			0		=> 'less than a minute ago',
			1		=> '%d minute ago',
			2		=> '%d minutes ago',
		),

		'Sunday'	=> 'Sunday',
		'Monday'	=> 'Monday',
		'Tuesday'	=> 'Tuesday',
		'Wednesday'	=> 'Wednesday',
		'Thursday'	=> 'Thursday',
		'Friday'	=> 'Friday',
		'Saturday'	=> 'Saturday',

		'Sun'		=> 'Sun',
		'Mon'		=> 'Mon',
		'Tue'		=> 'Tue',
		'Wed'		=> 'Wed',
		'Thu'		=> 'Thu',
		'Fri'		=> 'Fri',
		'Sat'		=> 'Sat',

		'January'	=> 'January',
		'February'	=> 'February',
		'March'		=> 'March',
		'April'		=> 'April',
		'May'		=> 'May',
		'June'		=> 'June',
		'July'		=> 'July',
		'August'	=> 'August',
		'September' => 'September',
		'October'	=> 'October',
		'November'	=> 'November',
		'December'	=> 'December',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Feb',
		'Mar'		=> 'Mar',
		'Apr'		=> 'Apr',
		'May_short'	=> 'May',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Jun',
		'Jul'		=> 'Jul',
		'Aug'		=> 'Aug',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Oct',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Dec',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Africa/Abidjan',
		'Africa/Accra'		=> 'Africa/Accra',
		'Africa/Addis_Ababa'	=> 'Africa/Addis Ababa',
		'Africa/Algiers'	=> 'Africa/Algiers',
		'Africa/Asmara'		=> 'Africa/Asmara',
		'Africa/Bamako'		=> 'Africa/Bamako',
		'Africa/Bangui'		=> 'Africa/Bangui',
		'Africa/Banjul'		=> 'Africa/Banjul',
		'Africa/Bissau'		=> 'Africa/Bissau',
		'Africa/Blantyre'	=> 'Africa/Blantyre',
		'Africa/Brazzaville'	=> 'Africa/Brazzaville',
		'Africa/Bujumbura'	=> 'Africa/Bujumbura',
		'Africa/Cairo'		=> 'Africa/Cairo',
		'Africa/Casablanca'	=> 'Africa/Casablanca',
		'Africa/Ceuta'		=> 'Africa/Ceuta',
		'Africa/Conakry'	=> 'Africa/Conakry',
		'Africa/Dakar'		=> 'Africa/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Africa/Dar es Salaam',
		'Africa/Djibouti'	=> 'Africa/Djibouti',
		'Africa/Douala'		=> 'Africa/Douala',
		'Africa/El_Aaiun'	=> 'Africa/El Aaiun',
		'Africa/Freetown'	=> 'Africa/Freetown',
		'Africa/Gaborone'	=> 'Africa/Gaborone',
		'Africa/Harare'		=> 'Africa/Harare',
		'Africa/Johannesburg'	=> 'Africa/Johannesburg',
		'Africa/Juba'		=> 'Africa/Juba',
		'Africa/Kampala'	=> 'Africa/Kampala',
		'Africa/Khartoum'	=> 'Africa/Khartoum',
		'Africa/Kigali'		=> 'Africa/Kigali',
		'Africa/Kinshasa'	=> 'Africa/Kinshasa',
		'Africa/Lagos'		=> 'Africa/Lagos',
		'Africa/Libreville'	=> 'Africa/Libreville',
		'Africa/Lome'		=> 'Africa/Lome',
		'Africa/Luanda'		=> 'Africa/Luanda',
		'Africa/Lubumbashi'	=> 'Africa/Lubumbashi',
		'Africa/Lusaka'		=> 'Africa/Lusaka',
		'Africa/Malabo'		=> 'Africa/Malabo',
		'Africa/Maputo'		=> 'Africa/Maputo',
		'Africa/Maseru'		=> 'Africa/Maseru',
		'Africa/Mbabane'	=> 'Africa/Mbabane',
		'Africa/Mogadishu'	=> 'Africa/Mogadishu',
		'Africa/Monrovia'	=> 'Africa/Monrovia',
		'Africa/Nairobi'	=> 'Africa/Nairobi',
		'Africa/Ndjamena'	=> 'Africa/Ndjamena',
		'Africa/Niamey'		=> 'Africa/Niamey',
		'Africa/Nouakchott'	=> 'Africa/Nouakchott',
		'Africa/Ouagadougou'	=> 'Africa/Ouagadougou',
		'Africa/Porto-Novo'	=> 'Africa/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Africa/Sao Tome',
		'Africa/Tripoli'	=> 'Africa/Tripoli',
		'Africa/Tunis'		=> 'Africa/Tunis',
		'Africa/Windhoek'	=> 'Africa/Windhoek',

		'America/Adak'		=> 'America/Adak',
		'America/Anchorage'	=> 'America/Anchorage',
		'America/Anguilla'	=> 'America/Anguilla',
		'America/Antigua'	=> 'America/Antigua',
		'America/Araguaina'	=> 'America/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'America/Argentina/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'America/Argentina/Catamarca',
		'America/Argentina/Cordoba'		=> 'America/Argentina/Cordoba',
		'America/Argentina/Jujuy'		=> 'America/Argentina/Jujuy',
		'America/Argentina/La_Rioja'	=> 'America/Argentina/La Rioja',
		'America/Argentina/Mendoza'		=> 'America/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'America/Argentina/Rio Gallegos',
		'America/Argentina/Salta'		=> 'America/Argentina/Salta',
		'America/Argentina/San_Juan'	=> 'America/Argentina/San Juan',
		'America/Argentina/San_Luis'	=> 'America/Argentina/San Luis',
		'America/Argentina/Tucuman'		=> 'America/Argentina/Tucuman',
		'America/Argentina/Ushuaia'		=> 'America/Argentina/Ushuaia',

		'America/Aruba'			=> 'America/Aruba',
		'America/Asuncion'		=> 'America/Asuncion',
		'America/Atikokan'		=> 'America/Atikokan',
		'America/Bahia'			=> 'America/Bahia',
		'America/Bahia_Banderas'	=> 'America/Bahia Banderas',
		'America/Barbados'		=> 'America/Barbados',
		'America/Belem'			=> 'America/Belem',
		'America/Belize'		=> 'America/Belize',
		'America/Blanc-Sablon'	=> 'America/Blanc-Sablon',
		'America/Boa_Vista'		=> 'America/Boa Vista',
		'America/Bogota'		=> 'America/Bogota',
		'America/Boise'			=> 'America/Boise',
		'America/Cambridge_Bay'	=> 'America/Cambridge Bay',
		'America/Campo_Grande'	=> 'America/Campo Grande',
		'America/Cancun'		=> 'America/Cancun',
		'America/Caracas'		=> 'America/Caracas',
		'America/Cayenne'		=> 'America/Cayenne',
		'America/Cayman'		=> 'America/Cayman',
		'America/Chicago'		=> 'America/Chicago',
		'America/Chihuahua'		=> 'America/Chihuahua',
		'America/Costa_Rica'	=> 'America/Costa Rica',
		'America/Creston'		=> 'America/Creston',
		'America/Cuiaba'		=> 'America/Cuiaba',
		'America/Curacao'		=> 'America/Curacao',
		'America/Danmarkshavn'	=> 'America/Danmarkshavn',
		'America/Dawson'		=> 'America/Dawson',
		'America/Dawson_Creek'	=> 'America/Dawson Creek',
		'America/Denver'		=> 'America/Denver',
		'America/Detroit'		=> 'America/Detroit',
		'America/Dominica'		=> 'America/Dominica',
		'America/Edmonton'		=> 'America/Edmonton',
		'America/Eirunepe'		=> 'America/Eirunepe',
		'America/El_Salvador'	=> 'America/El Salvador',
		'America/Fortaleza'		=> 'America/Fortaleza',
		'America/Glace_Bay'		=> 'America/Glace Bay',
		'America/Godthab'		=> 'America/Godthab',
		'America/Goose_Bay'		=> 'America/Goose Bay',
		'America/Grand_Turk'	=> 'America/Grand Turk',
		'America/Grenada'		=> 'America/Grenada',
		'America/Guadeloupe'	=> 'America/Guadeloupe',
		'America/Guatemala'		=> 'America/Guatemala',
		'America/Guayaquil'		=> 'America/Guayaquil',
		'America/Guyana'		=> 'America/Guyana',
		'America/Halifax'		=> 'America/Halifax',
		'America/Havana'		=> 'America/Havana',
		'America/Hermosillo'		=> 'America/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'America/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'America/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'America/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'America/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'America/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'America/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'America/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'America/Indiana/Winamac',
		'America/Inuvik'		=> 'America/Inuvik',
		'America/Iqaluit'		=> 'America/Iqaluit',
		'America/Jamaica'		=> 'America/Jamaica',
		'America/Juneau'		=> 'America/Juneau',
		'America/Kentucky/Louisville'	=> 'America/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'America/Kentucky/Monticello',
		'America/Kralendijk'	=> 'America/Kralendijk',
		'America/La_Paz'		=> 'America/La Paz',
		'America/Lima'			=> 'America/Lima',
		'America/Los_Angeles'	=> 'America/Los Angeles',
		'America/Lower_Princes'	=> 'America/Lower Princes',
		'America/Maceio'		=> 'America/Maceio',
		'America/Managua'		=> 'America/Managua',
		'America/Manaus'		=> 'America/Manaus',
		'America/Marigot'		=> 'America/Marigot',
		'America/Martinique'	=> 'America/Martinique',
		'America/Matamoros'		=> 'America/Matamoros',
		'America/Mazatlan'		=> 'America/Mazatlan',
		'America/Menominee'		=> 'America/Menominee',
		'America/Merida'		=> 'America/Merida',
		'America/Metlakatla'	=> 'America/Metlakatla',
		'America/Mexico_City'	=> 'America/Mexico City',
		'America/Miquelon'		=> 'America/Miquelon',
		'America/Moncton'		=> 'America/Moncton',
		'America/Monterrey'		=> 'America/Monterrey',
		'America/Montevideo'	=> 'America/Montevideo',
		'America/Montreal'		=> 'America/Montreal',
		'America/Montserrat'	=> 'America/Montserrat',
		'America/Nassau'		=> 'America/Nassau',
		'America/New_York'		=> 'America/New York',
		'America/Nipigon'		=> 'America/Nipigon',
		'America/Nome'			=> 'America/Nome',
		'America/Noronha'		=> 'America/Noronha',
		'America/North_Dakota/Beulah'		=> 'America/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'America/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'America/North Dakota/New Salem',
		'America/Ojinaga'		=> 'America/Ojinaga',
		'America/Panama'		=> 'America/Panama',
		'America/Pangnirtung'	=> 'America/Pangnirtung',
		'America/Paramaribo'	=> 'America/Paramaribo',
		'America/Phoenix'		=> 'America/Phoenix',
		'America/Port-au-Prince'	=> 'America/Port-au-Prince',
		'America/Port_of_Spain'	=> 'America/Port of Spain',
		'America/Porto_Velho'	=> 'America/Porto Velho',
		'America/Puerto_Rico'	=> 'America/Puerto Rico',
		'America/Rainy_River'	=> 'America/Rainy River',
		'America/Rankin_Inlet'	=> 'America/Rankin Inlet',
		'America/Recife'		=> 'America/Recife',
		'America/Regina'		=> 'America/Regina',
		'America/Resolute'		=> 'America/Resolute',
		'America/Rio_Branco'	=> 'America/Rio Branco',
		'America/Santa_Isabel'	=> 'America/Santa Isabel',
		'America/Santarem'		=> 'America/Santarem',
		'America/Santiago'		=> 'America/Santiago',
		'America/Santo_Domingo'	=> 'America/Santo Domingo',
		'America/Sao_Paulo'		=> 'America/Sao Paulo',
		'America/Scoresbysund'	=> 'America/Scoresbysund',
		'America/Shiprock'		=> 'America/Shiprock',
		'America/Sitka'			=> 'America/Sitka',
		'America/St_Barthelemy'	=> 'America/St. Barthelemy',
		'America/St_Johns'		=> 'America/St. Johns',
		'America/St_Kitts'		=> 'America/St. Kitts',
		'America/St_Lucia'		=> 'America/St. Lucia',
		'America/St_Thomas'		=> 'America/St. Thomas',
		'America/St_Vincent'	=> 'America/St. Vincent',
		'America/Swift_Current'	=> 'America/Swift Current',
		'America/Tegucigalpa'	=> 'America/Tegucigalpa',
		'America/Thule'			=> 'America/Thule',
		'America/Thunder_Bay'	=> 'America/Thunder Bay',
		'America/Tijuana'		=> 'America/Tijuana',
		'America/Toronto'		=> 'America/Toronto',
		'America/Tortola'		=> 'America/Tortola',
		'America/Vancouver'		=> 'America/Vancouver',
		'America/Whitehorse'	=> 'America/Whitehorse',
		'America/Winnipeg'		=> 'America/Winnipeg',
		'America/Yakutat'		=> 'America/Yakutat',
		'America/Yellowknife'	=> 'America/Yellowknife',

		'Antarctica/Casey'		=> 'Antarctica/Casey',
		'Antarctica/Davis'		=> 'Antarctica/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarctica/DumontDUrville',
		'Antarctica/Macquarie'	=> 'Antarctica/Macquarie',
		'Antarctica/Mawson'		=> 'Antarctica/Mawson',
		'Antarctica/McMurdo'	=> 'Antarctica/McMurdo',
		'Antarctica/Palmer'		=> 'Antarctica/Palmer',
		'Antarctica/Rothera'	=> 'Antarctica/Rothera',
		'Antarctica/South_Pole'	=> 'Antarctica/South Pole',
		'Antarctica/Syowa'		=> 'Antarctica/Syowa',
		'Antarctica/Vostok'		=> 'Antarctica/Vostok',

		'Arctic/Longyearbyen'	=> 'Arctic/Longyearbyen',

		'Asia/Aden'			=> 'Asia/Aden',
		'Asia/Almaty'		=> 'Asia/Almaty',
		'Asia/Amman'		=> 'Asia/Amman',
		'Asia/Anadyr'		=> 'Asia/Anadyr',
		'Asia/Aqtau'		=> 'Asia/Aqtau',
		'Asia/Aqtobe'		=> 'Asia/Aqtobe',
		'Asia/Ashgabat'		=> 'Asia/Ashgabat',
		'Asia/Baghdad'		=> 'Asia/Baghdad',
		'Asia/Bahrain'		=> 'Asia/Bahrain',
		'Asia/Baku'			=> 'Asia/Baku',
		'Asia/Bangkok'		=> 'Asia/Bangkok',
		'Asia/Beirut'		=> 'Asia/Beirut',
		'Asia/Bishkek'		=> 'Asia/Bishkek',
		'Asia/Brunei'		=> 'Asia/Brunei',
		'Asia/Choibalsan'	=> 'Asia/Choibalsan',
		'Asia/Chongqing'	=> 'Asia/Chongqing',
		'Asia/Colombo'		=> 'Asia/Colombo',
		'Asia/Damascus'		=> 'Asia/Damascus',
		'Asia/Dhaka'		=> 'Asia/Dhaka',
		'Asia/Dili'			=> 'Asia/Dili',
		'Asia/Dubai'		=> 'Asia/Dubai',
		'Asia/Dushanbe'		=> 'Asia/Dushanbe',
		'Asia/Gaza'			=> 'Asia/Gaza',
		'Asia/Harbin'		=> 'Asia/Harbin',
		'Asia/Hebron'		=> 'Asia/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Asia/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Asia/Hong Kong',
		'Asia/Hovd'			=> 'Asia/Hovd',
		'Asia/Irkutsk'		=> 'Asia/Irkutsk',
		'Asia/Jakarta'		=> 'Asia/Jakarta',
		'Asia/Jayapura'		=> 'Asia/Jayapura',
		'Asia/Jerusalem'	=> 'Asia/Jerusalem',
		'Asia/Kabul'		=> 'Asia/Kabul',
		'Asia/Kamchatka'	=> 'Asia/Kamchatka',
		'Asia/Karachi'		=> 'Asia/Karachi',
		'Asia/Kashgar'		=> 'Asia/Kashgar',
		'Asia/Kathmandu'	=> 'Asia/Kathmandu',
		'Asia/Khandyga'		=> 'Asia/Khandyga',
		'Asia/Kolkata'		=> 'Asia/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Asia/Krasnoyarsk',
		'Asia/Kuala_Lumpur'	=> 'Asia/Kuala Lumpur',
		'Asia/Kuching'		=> 'Asia/Kuching',
		'Asia/Kuwait'		=> 'Asia/Kuwait',
		'Asia/Macau'		=> 'Asia/Macau',
		'Asia/Magadan'		=> 'Asia/Magadan',
		'Asia/Makassar'		=> 'Asia/Makassar',
		'Asia/Manila'		=> 'Asia/Manila',
		'Asia/Muscat'		=> 'Asia/Muscat',
		'Asia/Nicosia'		=> 'Asia/Nicosia',
		'Asia/Novokuznetsk'	=> 'Asia/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Asia/Novosibirsk',
		'Asia/Omsk'			=> 'Asia/Omsk',
		'Asia/Oral'			=> 'Asia/Oral',
		'Asia/Phnom_Penh'	=> 'Asia/Phnom Penh',
		'Asia/Pontianak'	=> 'Asia/Pontianak',
		'Asia/Pyongyang'	=> 'Asia/Pyongyang',
		'Asia/Qatar'		=> 'Asia/Qatar',
		'Asia/Qyzylorda'	=> 'Asia/Qyzylorda',
		'Asia/Rangoon'		=> 'Asia/Rangoon',
		'Asia/Riyadh'		=> 'Asia/Riyadh',
		'Asia/Sakhalin'		=> 'Asia/Sakhalin',
		'Asia/Samarkand'	=> 'Asia/Samarkand',
		'Asia/Seoul'		=> 'Asia/Seoul',
		'Asia/Shanghai'		=> 'Asia/Shanghai',
		'Asia/Singapore'	=> 'Asia/Singapore',
		'Asia/Taipei'		=> 'Asia/Taipei',
		'Asia/Tashkent'		=> 'Asia/Tashkent',
		'Asia/Tbilisi'		=> 'Asia/Tbilisi',
		'Asia/Tehran'		=> 'Asia/Tehran',
		'Asia/Thimphu'		=> 'Asia/Thimphu',
		'Asia/Tokyo'		=> 'Asia/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Asia/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Asia/Urumqi',
		'Asia/Ust-Nera'		=> 'Asia/Ust-Nera',
		'Asia/Vientiane'	=> 'Asia/Vientiane',
		'Asia/Vladivostok'	=> 'Asia/Vladivostok',
		'Asia/Yakutsk'		=> 'Asia/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Asia/Yekaterinburg',
		'Asia/Yerevan'		=> 'Asia/Yerevan',

		'Atlantic/Azores'		=> 'Atlantic/Azores',
		'Atlantic/Bermuda'		=> 'Atlantic/Bermuda',
		'Atlantic/Canary'		=> 'Atlantic/Canary',
		'Atlantic/Cape_Verde'	=> 'Atlantic/Cape Verde',
		'Atlantic/Faroe'		=> 'Atlantic/Faroe',
		'Atlantic/Madeira'		=> 'Atlantic/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlantic/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlantic/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlantic/St. Helena',
		'Atlantic/Stanley'		=> 'Atlantic/Stanley',

		'Australia/Adelaide'	=> 'Australia/Adelaide',
		'Australia/Brisbane'	=> 'Australia/Brisbane',
		'Australia/Broken_Hill'	=> 'Australia/Broken Hill',
		'Australia/Currie'		=> 'Australia/Currie',
		'Australia/Darwin'		=> 'Australia/Darwin',
		'Australia/Eucla'		=> 'Australia/Eucla',
		'Australia/Hobart'		=> 'Australia/Hobart',
		'Australia/Lindeman'	=> 'Australia/Lindeman',
		'Australia/Lord_Howe'	=> 'Australia/Lord Howe',
		'Australia/Melbourne'	=> 'Australia/Melbourne',
		'Australia/Perth'		=> 'Australia/Perth',
		'Australia/Sydney'		=> 'Australia/Sydney',

		'Europe/Amsterdam'	=> 'Europe/Amsterdam',
		'Europe/Andorra'	=> 'Europe/Andorra',
		'Europe/Athens'		=> 'Europe/Athens',
		'Europe/Belgrade'	=> 'Europe/Belgrade',
		'Europe/Berlin'		=> 'Europe/Berlin',
		'Europe/Bratislava'	=> 'Europe/Bratislava',
		'Europe/Brussels'	=> 'Europe/Brussels',
		'Europe/Bucharest'	=> 'Europe/Bucharest',
		'Europe/Budapest'	=> 'Europe/Budapest',
		'Europe/Busingen'	=> 'Europe/Busingen',
		'Europe/Chisinau'	=> 'Europe/Chisinau',
		'Europe/Copenhagen'	=> 'Europe/Copenhagen',
		'Europe/Dublin'		=> 'Europe/Dublin',
		'Europe/Gibraltar'	=> 'Europe/Gibraltar',
		'Europe/Guernsey'	=> 'Europe/Guernsey',
		'Europe/Helsinki'	=> 'Europe/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europe/Isle of Man',
		'Europe/Istanbul'	=> 'Europe/Istanbul',
		'Europe/Jersey'		=> 'Europe/Jersey',
		'Europe/Kaliningrad'	=> 'Europe/Kaliningrad',
		'Europe/Kiev'		=> 'Europe/Kiev',
		'Europe/Lisbon'		=> 'Europe/Lisbon',
		'Europe/Ljubljana'	=> 'Europe/Ljubljana',
		'Europe/London'		=> 'Europe/London',
		'Europe/Luxembourg'	=> 'Europe/Luxembourg',
		'Europe/Madrid'		=> 'Europe/Madrid',
		'Europe/Malta'		=> 'Europe/Malta',
		'Europe/Mariehamn'	=> 'Europe/Mariehamn',
		'Europe/Minsk'		=> 'Europe/Minsk',
		'Europe/Monaco'		=> 'Europe/Monaco',
		'Europe/Moscow'		=> 'Europe/Moscow',
		'Europe/Oslo'		=> 'Europe/Oslo',
		'Europe/Paris'		=> 'Europe/Paris',
		'Europe/Podgorica'	=> 'Europe/Podgorica',
		'Europe/Prague'		=> 'Europe/Prague',
		'Europe/Riga'		=> 'Europe/Riga',
		'Europe/Rome'		=> 'Europe/Rome',
		'Europe/Samara'		=> 'Europe/Samara',
		'Europe/San_Marino'	=> 'Europe/San Marino',
		'Europe/Sarajevo'	=> 'Europe/Sarajevo',
		'Europe/Simferopol'	=> 'Europe/Simferopol',
		'Europe/Skopje'		=> 'Europe/Skopje',
		'Europe/Sofia'		=> 'Europe/Sofia',
		'Europe/Stockholm'	=> 'Europe/Stockholm',
		'Europe/Tallinn'	=> 'Europe/Tallinn',
		'Europe/Tirane'		=> 'Europe/Tirane',
		'Europe/Uzhgorod'	=> 'Europe/Uzhgorod',
		'Europe/Vaduz'		=> 'Europe/Vaduz',
		'Europe/Vatican'	=> 'Europe/Vatican',
		'Europe/Vienna'		=> 'Europe/Vienna',
		'Europe/Vilnius'	=> 'Europe/Vilnius',
		'Europe/Volgograd'	=> 'Europe/Volgograd',
		'Europe/Warsaw'		=> 'Europe/Warsaw',
		'Europe/Zagreb'		=> 'Europe/Zagreb',
		'Europe/Zaporozhye'	=> 'Europe/Zaporozhye',
		'Europe/Zurich'		=> 'Europe/Zurich',

		'Indian/Antananarivo'	=> 'Indian/Antananarivo',
		'Indian/Chagos'		=> 'Indian/Chagos',
		'Indian/Christmas'	=> 'Indian/Christmas',
		'Indian/Cocos'		=> 'Indian/Cocos',
		'Indian/Comoro'		=> 'Indian/Comoro',
		'Indian/Kerguelen'	=> 'Indian/Kerguelen',
		'Indian/Mahe'		=> 'Indian/Mahe',
		'Indian/Maldives'	=> 'Indian/Maldives',
		'Indian/Mauritius'	=> 'Indian/Mauritius',
		'Indian/Mayotte'	=> 'Indian/Mayotte',
		'Indian/Reunion'	=> 'Indian/Reunion',

		'Pacific/Apia'		=> 'Pacific/Apia',
		'Pacific/Auckland'	=> 'Pacific/Auckland',
		'Pacific/Chatham'	=> 'Pacific/Chatham',
		'Pacific/Chuuk'		=> 'Pacific/Chuuk',
		'Pacific/Easter'	=> 'Pacific/Easter',
		'Pacific/Efate'		=> 'Pacific/Efate',
		'Pacific/Enderbury'	=> 'Pacific/Enderbury',
		'Pacific/Fakaofo'	=> 'Pacific/Fakaofo',
		'Pacific/Fiji'		=> 'Pacific/Fiji',
		'Pacific/Funafuti'	=> 'Pacific/Funafuti',
		'Pacific/Galapagos'	=> 'Pacific/Galapagos',
		'Pacific/Gambier'	=> 'Pacific/Gambier',
		'Pacific/Guadalcanal'	=> 'Pacific/Guadalcanal',
		'Pacific/Guam'		=> 'Pacific/Guam',
		'Pacific/Honolulu'	=> 'Pacific/Honolulu',
		'Pacific/Johnston'	=> 'Pacific/Johnston',
		'Pacific/Kiritimati'	=> 'Pacific/Kiritimati',
		'Pacific/Kosrae'	=> 'Pacific/Kosrae',
		'Pacific/Kwajalein'	=> 'Pacific/Kwajalein',
		'Pacific/Majuro'	=> 'Pacific/Majuro',
		'Pacific/Marquesas'	=> 'Pacific/Marquesas',
		'Pacific/Midway'	=> 'Pacific/Midway',
		'Pacific/Nauru'		=> 'Pacific/Nauru',
		'Pacific/Niue'		=> 'Pacific/Niue',
		'Pacific/Norfolk'	=> 'Pacific/Norfolk',
		'Pacific/Noumea'	=> 'Pacific/Noumea',
		'Pacific/Pago_Pago'	=> 'Pacific/Pago Pago',
		'Pacific/Palau'		=> 'Pacific/Palau',
		'Pacific/Pitcairn'	=> 'Pacific/Pitcairn',
		'Pacific/Pohnpei'	=> 'Pacific/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pacific/Port Moresby',
		'Pacific/Rarotonga'	=> 'Pacific/Rarotonga',
		'Pacific/Saipan'	=> 'Pacific/Saipan',
		'Pacific/Tahiti'	=> 'Pacific/Tahiti',
		'Pacific/Tarawa'	=> 'Pacific/Tarawa',
		'Pacific/Tongatapu'	=> 'Pacific/Tongatapu',
		'Pacific/Wake'		=> 'Pacific/Wake',
		'Pacific/Wallis'	=> 'Pacific/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));
