<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2020 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){function aa(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
var c=[""],e=[256],f=["","t"],p=["","id"],ba=["","vid"],ca=["","type"],r=["","width"],t={flags:3089},u=["","height"],da=/embed\\/(\\d+)/,ea=["","video_id"],v=[[/(?:)/,c]],fa=["","track_id"],ha=["","album_id"],ia=["","user","id"],ja=["","id","type"],ka=["","fid","eid"],la=["","episode_id"],ma=["","playlist_id"],na=["","oid","vid","hash"],w=["","channel","clip_id"],oa=["","athlete","highlight"],pa=["","account_id","event_id"],z={d:[],s:!0},B={d:[],s:!1},qa=[[/globalnews\\.ca\\/video\\/(\\d+)/,p]],ra=[/hudl\\.com\\/video\\/(\\w+)(?![\\w\\/])/,
p],sa=[/flickr\\.com\\/photos\\/[^\\/]+\\/(\\d+)/,p],ta=[[/([-\\w]+)\\.castos\\.com\\/player\\/(\\d+)/,["","host","id"]]],ua=[[/247sports\\.com\\/PlayerSport\\/[-\\w]*(\\d+)\\/Embed/,["","player_id"]]],va=[/hudl\\.com\\/video\\/\\d+\\/(\\d+)\\/([\\da-f]+)/,oa],wa=[[/(?:open|play)\\.spotify\\.com\\/(?:user\\/[-.\\w]+\\/)?((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,p]],xa=[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],G=[function(a,b){var d={},g;for(g in b.b){var q=b.b[g],h=!1;if(g in a.b){h=q.d;var l=g,
n=a.b[g];C.k=l;for(var k=0;k<h.length&&(n=h[k](n,l),!1!==n);++k);delete C.k;h=n}!1!==h?d[g]=h:"undefined"!==typeof q.x?d[g]=q.x:q.s&&D(a)}E(a,d)}],ya={d:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],s:!1},za={x:360,d:xa,s:!1},Aa={x:640,d:xa,s:!1},H={e:e,b:{id:B},h:1,d:G,f:10,j:t,g:5E3},Ba={e:e,b:{id:B,user:B},h:1,d:G,f:10,j:t,g:5E3},Ca={e:e,b:{height:za,id:B,width:Aa},h:1,d:G,f:10,j:t,g:5E3},
Da=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$uAMAZON_ASSOCIATE_TAG"/><xsl:param$uAMAZON_ASSOCIATE_TAG_CA"/><xsl:param$uAMAZON_ASSOCIATE_TAG_DE"/><xsl:param$uAMAZON_ASSOCIATE_TAG_ES"/><xsl:param$uAMAZON_ASSOCIATE_TAG_FR"/><xsl:param$uAMAZON_ASSOCIATE_TAG_IN"/><xsl:param$uAMAZON_ASSOCIATE_TAG_IT"/><xsl:param$uAMAZON_ASSOCIATE_TAG_JP"/><xsl:param$uAMAZON_ASSOCIATE_TAG_UK"/><xsl:param$uMEDIAEMBED_THEME"/>$eABCNEWS"><$q$dabcnews"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//abcnews.go.com/video/embed?id={@id}"$g$b/></$q></$q>$i$eAMAZON"><$q$damazon"$g$c120px"><$q$g$a200%"><$m$f"$l$p$kno"$gbackground:url(https://www.amazon.com/favicon.ico) center no-repeat;$b><$n$usrc">//ws-<$w><$v$t@tld=\\\'jp\\\'">fe</$v><$v$t@tld and contains(\\\'desfrinituk\\\',@tld)">eu</$v><$s>na</$s></$w>.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=<$w><$v$t@tld=\\\'ca\\\'">15&amp;t=$h$AMAZON_ASSOCIATE_TAG_CA"/></$v><$v$t@tld=\\\'de\\\'">3&amp;t=$h$AMAZON_ASSOCIATE_TAG_DE"/></$v><$v$t@tld=\\\'es\\\'">30&amp;t=$h$AMAZON_ASSOCIATE_TAG_ES"/></$v><$v$t@tld=\\\'fr\\\'">8&amp;t=$h$AMAZON_ASSOCIATE_TAG_FR"/></$v><$v$t@tld=\\\'in\\\'">31&amp;t=$h$AMAZON_ASSOCIATE_TAG_IN"/></$v><$v$t@tld=\\\'it\\\'">29&amp;t=$h$AMAZON_ASSOCIATE_TAG_IT"/></$v><$v$t@tld=\\\'jp\\\'">9&amp;t=$h$AMAZON_ASSOCIATE_TAG_JP"/></$v><$v$t@tld=\\\'uk\\\'">2&amp;t=$h$AMAZON_ASSOCIATE_TAG_UK"/></$v><$s>1&amp;t=$h$AMAZON_ASSOCIATE_TAG"/></$s></$w>&amp;asins=$h@id"/></$n></$m></$q></$q>$i$eANCHOR"><$m$danchor"$f"$l$p$kno"$o//anchor.fm/embed/episodes/x-{@id}"$gborder:0;height:102px;max-width:700px;width:100%"/>$i$eAUDIOBOOM"><$m$daudioboom"$f"$l$p$kno"$o//audioboom.com/posts/{@id}/embed/v3"$gborder:0;height:150px;max-width:700px;width:100%"/>$i$eAUDIOMACK"><$m$daudiomack"$f"$l$p$kno"><$w><$v$t@mode=\\\'album\\\'"><$n$usrc">https://www.audiomack.com/embed/album/<$w><$v$t@id">$h@id"/></$v><$s>$h@artist"/>/$h@title"/></$s></$w></$n><$n$u$z>border:0;height:400px;max-width:900px;width:100%</$n></$v><$s><$n$usrc">https://www.audiomack.com/embed/song/<$w><$v$t@id">$h@id"/></$v><$s>$h@artist"/>/$h@title"/></$s></$w></$n><$n$u$z>border:0;height:252px;max-width:900px;width:100%</$n></$s></$w></$m>$i$eBANDCAMP"><$q$dbandcamp"$g$c400px"><$q$g$a100%"><$m$f"$l$p$kno"$g$b><$n$usrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$w><$v$t@album_id">album=$h@album_id"/><xsl:if$t@track_num">/t=$h@track_num"/></xsl:if></$v><$s>track=$h@track_id"/></$s></$w><xsl:if$t$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</xsl:if></$n></$m></$q></$q>$i$eBBCNEWS"><$q$dbbcnews"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//www.bbc.com/news/av/video-<$w><$v$tstarts-with(@playlist,\\\'/news/\\\')">$hsubstring-after(@playlist,\\\'/news/\\\')"/></$v><$v$tcontains(@id,\\\'/\\\')">$hsubstring-after(@id,\\\'/\\\')"/></$v><$s>$h@id"/></$s></$w>/embed</$n></$m></$q></$q>$i$eBITCHUTE"><$q$dbitchute"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.bitchute.com/embed/{@id}/"$g$b/></$q></$q>$i$eBLEACHERREPORT"><$q$dbleacherreport"$g$c320px"><$q$g$a100%"><$m$f"$l$p$kno"$o//bleacherreport.com/video_embed?id={@id}&amp;library=video-cms"$g$b/></$q></$q>$i$eBREAK"><$q$dbreak"$g$c464px"><$q$g$a60.344828%"><$m$f"$l$p$kno"$o//break.com/embed/{@id}"$g$b/></$q></$q>$i$eBRIGHTCOVE"><$q$dbrightcove"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">https://<$w><$v$t@bckey">link.brightcove.com/services/player/bcpid$h@bcpid"/>?bckey=$h@bckey"/>&amp;bctid=$h@bctid"/>&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640</$v><$s>players.brightcove.net/$h@bcpid"/>/default_default/index.html?videoId=$h@bctid"/></$s></$w></$n></$m></$q></$q>$i$eCASTOS"><$m$dcastos"$f"$l$p$kno"$ohttps://player.castos.com/player/{@id}"$gborder:0;height:150px;max-width:900px;width:100%"/>$i$eCBSNEWS"><$q$dcbsnews"$g$c640px"><$q><$w><$v$tcontains(@id,\\\'-\\\')"><$n$u$z>$a56.25%</$n><$m$f"$l$p$kno"$ohttps://www.cbsnews.com/embed/videos/{@id}/"$g$b/></$v><$v$t@pid"><$n$u$z>$a62.1875%;padding-bottom:calc(56.25% + 38px)</$n><object data="//www.cbsnews.com/common/video/cbsnews_player.swf"$g$x type="application/x-shockwave-flash" typemustmatch="">$y<param$uflashvars" value="pType=embed&amp;si=254&amp;pid={@pid}"/></object></$v><$s><$n$u$z>$a62.5%;padding-bottom:calc(56.25% + 40px)</$n><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf"$g$x type="application/x-shockwave-flash" typemustmatch="">$y<param$uflashvars" value="si=254&amp;contentValue={@id}"/></object></$s></$w></$q></$q>$i$eCLYP"><$m$dclyp"$f"$l$p$kno"$ohttps://clyp.it/{@id}/widget"$gborder:0;height:265px;max-width:900px;width:100%"/>$i$eCNBC"><$q$dcnbc"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid={@id}&amp;size=640_360"$g$b/></$q></$q>$i$eCNN"><$q$dcnn"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//fave.api.cnn.io/v1/fav/?video={@id}&amp;customer=cnn&amp;edition=international&amp;env=prod"$g$b/></$q></$q>$i$eCNNMONEY"><$q$dcnnmoney"$g$c560px"><$q$g$a64.285714%"><$m$f"$l$p$kno"$o//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&amp;width=560&amp;height=360"$g$b/></$q></$q>$i$eCODEPEN"><$m$dcodepen"$f"$l$p$kno"$ohttps://codepen.io/{@user}/embed/{@id}?height=400&amp;default-tab=html,result"$gborder:0;height:400px;width:100%"/>$i$eCOMEDYCENTRAL"><$q$dcomedycentral"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//media.mtvnservices.com/embed/{@id}"$g$b/></$q></$q>$i$eCOUB"><$q$dcoub"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//coub.com/embed/{@id}"$g$b/></$q></$q>$i$eDAILYMOTION"><$q$ddailymotion"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//www.dailymotion.com/embed/video/$h@id"/><xsl:if$t@t">?start=$h@t"/></xsl:if></$n></$m></$q></$q>$i$eDEMOCRACYNOW"><$q$ddemocracynow"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//www.democracynow.org/embed/<$w><$v$tcontains(@id,\\\'/headlines\\\')">headlines/$hsubstring-before(@id,\\\'/headlines\\\')"/></$v><$v$tstarts-with(@id,\\\'2\\\')">story/$h@id"/></$v><$v$tstarts-with(@id,\\\'shows/\\\')">show/$hsubstring-after(@id,\\\'/\\\')"/></$v><$s>$h@id"/></$s></$w></$n></$m></$q></$q>$i$eDUMPERT"><$q$ddumpert"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.dumpert.nl/embed/{translate(@id,\\\'/\\\',\\\'_\\\')}"$g$b/></$q></$q>$i$eEIGHTTRACKS"><$q$deighttracks"$g$c400px"><$q$g$a100%"><$m$f"$l$p$kno"$o//8tracks.com/mixes/{@id}/player_v3_universal"$g$b/></$q></$q>$i$eESPN"><$q$despn"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.espn.com/core/video/$m?id={@id}"$g$b/></$q></$q>$i$eFACEBOOK"><$m$dfacebook"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/facebook.min.html#{@type}{@id}"$gborder:0;height:360px;max-width:640px;width:100%"/>$i$eFALSTAD"><$m$dfalstad"$f"$l$p$kno"$gborder:0;height:500px;max-height:90vh;width:100%"><$n$usrc">https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c<$w><$v$t@cct">ct=$h@cct"/></$v><$s>tz=$h@ctz"/></$s></$w></$n></$m>$i$eFLICKR"><$q$dflickr"$g$c500px"><$q$g$a100%"><$m$f"$l$p$kno"$ohttps://www.flickr.com/photos/_/{@id}/player/"$g$b/></$q></$q>$i$eFOXNEWS"><$q$dfoxnews"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//video.foxnews.com/v/video-embed.html?video_id={@id}"$g$b/></$q></$q>$i$eFUNNYORDIE"><$q$dfunnyordie"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.funnyordie.com/embed/{@id}"$g$b/></$q></$q>$i$eGAMESPOT"><$q$dgamespot"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.gamespot.com/videos/embed/{@id}/"$g$b/></$q></$q>$i$eGAMETRAILERS"><$q$dgametrailers"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//<$w><$v$tstarts-with(@id,\\\'mgid:\\\')">media.mtvnservices.com/embed/$h@id"/></$v><$s>embed.gametrailers.com/embed/$h@id"/>?embed=1&amp;suppressBumper=1</$s></$w></$n></$m></$q></$q>$i$eGETTY"><$q$dgetty"$g$c{@width}px"><$q><$n$u$z>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$o//embed.gettyimages.com/embed/{@id}?et={@et}&amp;tld=com&amp;sig={@sig}&amp;caption=false&amp;ver=1"$g$b/></$q></$q>$i$eGFYCAT"><$q$dgfycat"$g$c{@width}px"><$q><$n$u$z>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*(@height+44)div@width"/>%;padding-bottom:calc($h100*@height div@width"/>% + 44px)</xsl:if></$n><$m$f"$l$p$kno"$o//gfycat.com/ifr/{@id}?hd=1"$g$b/></$q></$q>$i$eGIFS"><$q$dgifs"$g$c{@width}px"><$q><$n$u$z>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$o//gifs.com/embed/{@id}"$g$b/></$q></$q>$i$eGIPHY"><$q$dgiphy"$g$c{@width}px"><$q><$n$u$z>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$g$b><$n$usrc">//giphy.com/embed/$h@id"/><xsl:if$t@type=\\\'video\\\'">/video</xsl:if></$n></$m></$q></$q>$i$eGIST"><$m$dgist"$f"$r$z$l$p onload="$j$k"$ohttps://s9e.github.io/$m/2/gist.min.html#{@id}"$gborder:0;height:180px;width:100%"/>$i$eGLOBALNEWS"><$q$dglobalnews"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//globalnews.ca/video/embed/{@id}/"$g$b/></$q></$q>$i$eGOFUNDME"><$q$dgofundme"$g$c349px"><$q$g$a118.911175%;padding-bottom:calc(59.312321% + 208px)"><$m$f"$l$p$kno"$o//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund={@id}&amp;image=1&amp;coinfo=1"$g$b/></$q></$q>$i$eGOOGLEDRIVE"><$q$dgoogledrive"$g$c640px"><$q$g$a75%"><$m$f"$l$p$kno"$o//drive.google.com/file/d/{@id}/preview"$g$b/></$q></$q>$i$eGOOGLEPLUS"><$m$dgoogleplus"$f"$r$z$l$p onload="$j$kno"$gborder:0;height:240px;max-width:450px;width:100%"><$n$usrc">https://s9e.github.io/$m/2/googleplus.min.html#<$w><$v$t@oid">$h@oid"/></$v><$s>+$h@name"/></$s></$w>/posts/$h@pid"/></$n></$m>$i$eGOOGLESHEETS"><$w><$v$t@type=\\\'chart\\\'"><$q$dgooglesheets"$g$c600px"><$q$g$a62%"><$m$f"$l$p$kno"$ohttps://docs.google.com/spreadsheets/d/{@id}/pubchart?oid={@oid}&amp;format=interactive"$g$b/></$q></$q></$v><$s><$m$dgooglesheets"$f"$l$p$kno"$gborder:0;height:500px;resize:vertical;width:100%"><$n$usrc">https://docs.google.com/spreadsheets/d/$h@id"/>/p<$w><$v$tstarts-with(@id,\\\'e/\\\')">ubhtml?widget=true&amp;headers=false</$v><$s>review</$s></$w>#gid=$h@gid"/></$n></$m></$s></$w>$i$eHUDL"><$q$dhudl"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//www.hudl.com/embed/<$w><$v$t@id">video/$h@id"/></$v><$s>athlete/$h@athlete"/>/highlights/$h@highlight"/></$s></$w></$n></$m></$q></$q>$i$eHULU"><$q$dhulu"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://secure.hulu.com/embed/{@id}"$g$b/></$q></$q>$i$eIGN"><$q$dign"$g$c468px"><$q$g$a56.196581%"><$m$f"$l$p$kno"$o//widgets.ign.com/video/embed/content.html?url={@id}"$g$b/></$q></$q>$i$eIMDB"><$q$dimdb"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&amp;width=640"$g$b/></$q></$q>$i$eIMGUR"><$m$dimgur"$f"$r$z$l$p onload="var c=new MessageChannel;c.port1.onmessage=function(e){{var d=e.data.split(\\\' \\\');style.height=d[0]+\\\'px\\\';style.width=d[1]+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$kno"$gborder:0;height:400px;max-width:100%;width:542px"><$n$usrc">https://s9e.github.io/$m/2/imgur.min.html#<xsl:if$t@type=\\\'album\\\'">a/</xsl:if>$h@id"/></$n></$m>$i$eINDIEGOGO"><$q$dindiegogo"$g$c222px"><$q$g$a200.45045%"><$m$f"$l$p$kno"$o//www.indiegogo.com/project/{@id}/embedded"$g$b/></$q></$q>$i$eINSTAGRAM"><$m$dinstagram"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/instagram.min.html#{@id}"$gbackground:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"/>$i$eINTERNETARCHIVE"><$w><$v$tcontains(@id,\\\'playlist=1\\\')"><$m$dinternetarchive"$f"$l$p$kno"$ohttps://archive.org/embed/{@id}&amp;list_height=150"$gborder:0;height:170px;max-width:640px;width:100%"/></$v><$s><$q$dinternetarchive"$g$c{@width}px"><$q><$n$u$z>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$ohttps://archive.org/embed/{@id}"$g$b/></$q></$q></$s></$w>$i$eIZLESENE"><$q$dizlesene"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.izlesene.com/embedplayer/{@id}?autoplay=0"$g$b/></$q></$q>$i$eJSFIDDLE"><$m$djsfiddle"$f"$l$p$kno"$o//jsfiddle.net/{@id}/{@revision}/embedded/{$MEDIAEMBED_THEME}/"$gborder:0;height:400px;width:100%"/>$i$eJWPLATFORM"><$q$djwplatform"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//content.jwplatform.com/players/{@id}.html"$g$b/></$q></$q>$i$eKALTURA"><$q$dkaltura"$g$c640px"><$q$g$a61.875%;padding-bottom:calc(56.25% + 36px)"><$m$f"$l$p$kno"$g$b><$n$usrc">https://cdnapisec.kaltura.com/p/$h@partner_id"/>/sp/<$w><$v$t@sp">$h@sp"/></$v><$s>$h@partner_id"/>00</$s></$w>/embedIframeJs/uiconf_id/$h@uiconf_id"/>/partner_id/$h@partner_id"/>?$membed=true&amp;entry_id=$h@entry_id"/></$n></$m></$q></$q>$i$eKHL"><$q$dkhl"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//video.khl.ru/$m/feed/start/{@id}?type_id=18&amp;width=560&amp;height=315"$g$b/></$q></$q>$i$eKICKSTARTER"><$q$dkickstarter"><$w><$v$t@video"><$n$u$z>$c640px</$n><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.kickstarter.com/projects/{@id}/widget/video.html"$g$b/></$q></$v><$s><$n$u$z>$c220px</$n><$q$g$a190.909091%"><$m$f"$l$p$kno"$o//www.kickstarter.com/projects/{@id}/widget/card.html"$g$b/></$q></$s></$w></$q>$i$eLIBSYN"><$m$dlibsyn"$f"$l$p$kno"$o//html5-player.libsyn.com/embed/episode/id/{@id}/thumbnail/no"$gborder:0;height:90px;max-width:900px;width:100%"/>$i$eLIVELEAK"><$q$dliveleak"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.liveleak.com/e/{@id}"$g$b/></$q></$q>$i$eLIVESTREAM"><$q$dlivestream"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//<$w><$v$t@clip_id">cdn.livestream.com/embed/$h@channel"/>?layout=4&amp;autoplay=false&amp;clip=$h@clip_id"/></$v><$s>livestream.com/accounts/$h@account_id"/>/events/$h@event_id"/><xsl:if$t@video_id">/videos/$h@video_id"/></xsl:if>/player?autoPlay=false</$s></$w></$n></$m></$q></$q>$i$eMAILRU"><$q$dmailru"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://my.mail.ru/video/embed/{@id}"$g$b/></$q></$q>$i$eMEDIUM"><$m$dmedium"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/medium.min.html#{@id}"$gborder:0;height:316px;max-width:900px;width:100%"/>$i$eMEGAPHONE"><$m$dmegaphone"$f"$l$p$kno"$ohttps://player.megaphone.fm/{@id}"$gborder:0;height:200px;max-width:900px;width:100%"/>$i$eMETACAFE"><$q$dmetacafe"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.metacafe.com/embed/{@id}/"$g$b/></$q></$q>$i$eMIXCLOUD"><$q$dmixcloud"$g$c400px"><$q$g$a100%"><$m$f"$l$p$kno"$o//www.mixcloud.com/widget/$m/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&amp;embed_type=widget_standard"$g$b/></$q></$q>$i$eMIXER"><$q$dmixer"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">https://mixer.com/embed/player/$h@channel"/><xsl:if$t@vod">?vod=$h@vod"/></xsl:if></$n></$m></$q></$q>$i$eMLB"><$q$dmlb"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.mlb.com/video/share/c-{@id}"$g$b/></$q></$q>$i$eMRCTV"><$q$dmrctv"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.mrctv.org/embed/{@id}"$g$b/></$q></$q>$i$eMSNBC"><$q$dmsnbc"$g$c640px"><$q><$w><$v$tcontains(@id,\\\'_\\\')"><$n$u$z>$a68.75%;padding-bottom:calc(56.25% + 80px)</$n><$m$f"$l$p$kno"$o//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid={@id}"$g$b/></$v><$s><$n$u$z>$a56.25%</$n><$m$f"$l$p$kno"$ohttps://www.msnbc.com/msnbc/embedded-video/{@id}"$g$b/></$s></$w></$q></$q>$i$eNATGEOCHANNEL"><$q$dnatgeochannel"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//channel.nationalgeographic.com/{@id}/embed/"$g$b/></$q></$q>$i$eNATGEOVIDEO"><$q$dnatgeovideo"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}"$g$b/></$q></$q>$i$eNBCNEWS"><$q$dnbcnews"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.nbcnews.com/widget/video-embed/{@id}"$g$b/></$q></$q>$i$eNBCSPORTS"><$q$dnbcsports"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl="$g$b/></$q></$q>$i$eNHL"><$q$dnhl"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">https://www.nhl.com/video/embed<xsl:if$t@t">/t-$h@t"/></xsl:if><xsl:if$t@c">/c-$h@c"/></xsl:if>?autostart=false</$n></$m></$q></$q>$i$eNPR"><$m$dnpr"$f"$l$p$kno"$o//www.npr.org/player/embed/{@i}/{@m}"$gborder:0;height:228px;max-width:800px;width:100%"/>$i$eNYTIMES"><$q$dnytimes"$g$c585px"><$q$g$a68.376068%"><$m$f"$l$p$kno"$o//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}"$g$b/></$q></$q>$i$eORFIUM"><$m$dorfium"$f"$l$p$kno"><$n$usrc">https://www.orfium.com/embedded/<$w><$v$t@album_id">album/$h@album_id"/></$v><$v$t@playlist_id">playlist/$h@playlist_id"/></$v><$v$t@set_id">live-set/$h@set_id"/></$v><$s>track/$h@track_id"/></$s></$w></$n><$n$u$z>border:0;height:<$w><$v$t@album_id">550</$v><$s>275</$s></$w>px;max-width:900px;width:100%</$n></$m>$i$ePASTEBIN"><$m$dpastebin"$f"$l$p$k"$o//pastebin.com/embed_$m.php?i={@id}"$gborder:0;height:300px;resize:vertical;width:100%"/>$i$ePINTEREST"><$m$dpinterest"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/pinterest.min.html#{@id}"><$n$u$z>border:0;height:360px;max-width:<$w><$v$tcontains(@id,\\\'/\\\')">730</$v><$s>345</$s></$w>px;width:100%</$n></$m>$i$ePODBEAN"><$m$dpodbean"$f"$l$p$kno"$o//www.podbean.com/media/player/{@id}"$gborder:0;height:100px;max-width:900px;width:100%"/>$i$ePREZI"><$q$dprezi"$g$c550px"><$q$g$a72.727273%"><$m$f"$l$p$kno"$o//prezi.com/embed/{@id}/"$g$b/></$q></$q>$i$eREDDIT"><$m$dreddit"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/reddit.min.html#{@id}{@path}"$gborder:0;height:165px;max-width:800px;width:100%"/>$i$eRUMBLE"><$q$drumble"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://rumble.com/embed/{@id}/"$g$b/></$q></$q>$i$eRUTUBE"><$q$drutube"$g$c720px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//rutube.ru/play/embed/{@id}"$g$b/></$q></$q>$i$eSCRIBD"><$m$dscribd"$f"$l$p$kno"$ohttps://www.scribd.com/embeds/{@id}/content?view_mode=scroll&amp;show_recommendations=false"$gborder:0;height:500px;resize:vertical;width:100%"/>$i$eSENDVID"><$q$dsendvid"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//sendvid.com/embed/{@id}"$g$b/></$q></$q>$i$eSLIDESHARE"><$q$dslideshare"$g$c427px"><$q$g$a83.372365%"><$m$f"$l$p$kno"$o//www.slideshare.net/slideshow/embed_code/{@id}"$g$b/></$q></$q>$i$eSOUNDCLOUD"><$m$dsoundcloud"$f"$l$p$kno"><$n$usrc">https://w.soundcloud.com/player/?url=<$w><$v$t@playlist_id">https%3A//api.soundcloud.com/playlists/$h@playlist_id"/></$v><$v$t@track_id">https%3A//api.soundcloud.com/tracks/$h@track_id"/>&amp;secret_token=$h@secret_token"/></$v><$s><xsl:if$tnot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</xsl:if>$h@id"/></$s></$w></$n><$n$u$z>border:0;height:<$w><$v$t@playlist_id or contains(@id,\\\'/sets/\\\')">450</$v><$s>166</$s></$w>px;max-width:900px;width:100%</$n></$m>$i$eSPORCLE"><$m$dsporcle"$f"$r$z$l$p onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'*\\\',[c.port2])"$kno"$ohttps://s9e.github.io/$m/2/sporcle.min.html#{@id}"$gborder:0;height:535px;max-width:820px;width:100%"/>$i$eSPORTSNET"><$q$dsportsnet"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://images.rogersdigitalmedia.com/video_service.php?videoId={@id}&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25"$g$b/></$q></$q>$i$eSPOTIFY"><$w><$v$tstarts-with(@id,\\\'episode/\\\')or starts-with(@id,\\\'show/\\\')"><$m$dspotify" allow="encrypted-media"$f"$l$p$kno"$ohttps://open.spotify.com/embed/{@id}"$gborder:0;height:152px;max-width:900px;width:100%"/></$v><$s><$q$dspotify"$g$c320px"><$q$g$a125%;padding-bottom:calc(100% + 80px)"><$m allow="encrypted-media"$f"$l$p$kno"$ohttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$g$b/></$q></$q></$s></$w>$i$eSPREAKER"><$m$dspreaker"$f"$l$p$kno"$ohttps://widget.spreaker.com/player?episode_id={@episode_id}&amp;show_id={@show_id}&amp;theme={$MEDIAEMBED_THEME}"$gborder:0;height:{400-200*boolean(@episode_id)}px;max-width:900px;width:100%"/>$i$eSTEAMSTORE"><$m$dsteamstore"$f"$l$p$kno"$o//store.steampowered.com/widget/{@id}"$gborder:0;height:190px;max-width:900px;width:100%"/>$i$eSTITCHER"><$m$dstitcher"$f"$l$p$kno"$ohttps://www.stitcher.com/embed/{@fid}/{@eid}"$gborder:0;height:150px;max-width:900px;width:100%"/>$i$eSTRAWPOLL"><$q$dstrawpoll"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$k"$o//www.strawpoll.me/embed_1/{@id}"$g$b/></$q></$q>$i$eSTREAMABLE"><$q$dstreamable"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//streamable.com/e/{@id}"$g$b/></$q></$q>$i$eSTREAMJA"><$q$dstreamja"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://streamja.com/embed/{@id}"$g$b/></$q></$q>$i$eTEAMCOCO"><$q$dteamcoco"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//teamcoco.com/embed/v/{@id}"$g$b/></$q></$q>$i$eTED"><$q$dted"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//embed.ted.com/$h@id"/><xsl:if$tnot(contains(@id,\\\'.html\\\'))">.html</xsl:if></$n></$m></$q></$q>$i$eTELEGRAM"><$m$dtelegram"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/telegram.min.html#{@id}"$gborder:0;height:96px;max-width:500px;width:100%"/>$i$eTHEATLANTIC"><$q$dtheatlantic"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.theatlantic.com/video/$m/{@id}/"$g$b/></$q></$q>$i$eTHEGUARDIAN"><$q$dtheguardian"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//embed.theguardian.com/embed/video/{@id}"$g$b/></$q></$q>$i$eTHEONION"><$q$dtheonion"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.theonion.com/video_embed/?id={@id}"$g$b/></$q></$q>$i$eTIKTOK"><$q$dtiktok"$g$c340px"><$q$g$a205.882353%"><$m$f"$l$p$kno"$o//www.tiktok.com/embed/{@id}"$g$b/></$q></$q>$i$eTMZ"><$q$dtmz"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}"$g$b/></$q></$q>$i$eTRADINGVIEW"><$m$dtradingview"$f"$l$p$kno"$gborder:0;height:400px;width:100%"><$n$usrc">https://s.tradingview.com/<$w><$v$t@symbol">widgetembed/?interval=D&amp;symbol=$htranslate(@symbol,\\\'-\\\',\\\':\\\')"/></$v><$s>embed/$h@chart"/></$s></$w></$n></$m>$i$eTRAILERADDICT"><$q$dtraileraddict"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//v.traileraddict.com/{@id}"$g$b/></$q></$q>$i$eTRENDINGVIEWS"><$q$dtrendingviews"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://trendingviews.co/embed/{@id}"$g$b/></$q></$q>$i$eTUMBLR"><$m$dtumblr"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/tumblr.min.html#{@key}/{@id}"$gborder:0;height:300px;max-width:520px;width:100%"/>$i$eTWENTYFOURSEVENSPORTS"><$w><$v$t@video_id"><$q$dtwentyfoursevensports"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.cbssports.com/video/player/embed?args=player_id%3D{@video_id}%26channel%3Dmobilevideo%26pcid%3D{@video_id}%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue"$g$b/></$q></$q></$v><$s><$m$dtwentyfoursevensports"$f"$l$p onload="window.addEventListener(\\\'message\\\',function(e){{if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\\\'px\\\'}})"$kno"$ohttps://247sports.com/PlayerSport/{@player_id}/Embed/"$gborder:0;height:200px;max-width:600px;width:100%"/></$s></$w>$i$eTWITCH"><$q$dtwitch"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p onload="contentWindow.postMessage(\\\'\\\',\\\'https://s9e.github.io\\\')"$kno"$ohttps://s9e.github.io/$m/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$g$b/></$q></$q>$i$eTWITTER"><$m$dtwitter" allow="autoplay *"$f"$r$z$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/twitter.min.html#{@id}{$MEDIAEMBED_THEME}"$gborder:0;height:250px;max-width:550px;width:100%"/>$i$eUSTREAM"><$q$dustream"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//www.ustream.tv/embed/<$w><$v$t@vid">recorded/$h@vid"/></$v><$s>$h@cid"/></$s></$w>?html5ui</$n></$m></$q></$q>$i$eVBOX7"><$q$dvbox7"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//vbox7.com/emb/external.php?vid={@id}"$g$b/></$q></$q>$i$eVEOH"><$q$dveoh"$g$c640px"><$q$g$a62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v{@id}&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous"$g$x type="application/x-shockwave-flash" typemustmatch="">$y</object></$q></$q>$i$eVEVO"><$q$dvevo"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://embed.vevo.com/?isrc={@id}"$g$b/></$q></$q>$i$eVIDEODETECTIVE"><$q$dvideodetective"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid={@id}"$g$b/></$q></$q>$i$eVIMEO"><$q$dvimeo"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$usrc">//player.vimeo.com/video/$h@id"/><xsl:if$t@t">#t=$h@t"/></xsl:if></$n></$m></$q></$q>$i$eVINE"><$q$dvine"$g$c480px"><$q$g$a100%"><$m$f"$l$p$kno"$ohttps://vine.co/v/{@id}/embed/simple?audio=1"$g$b/></$q></$q>$i$eVK"><$q$dvk"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//vk.com/video_ext.php?oid={@oid}&amp;id={@vid}&amp;hash={@hash}&amp;hd=1"$g$b/></$q></$q>$i$eVOCAROO"><$q$dvocaroo"><$w><$v$tstarts-with(@id,\\\'s0\\\')or starts-with(@id,\\\'s1\\\')"><$n$u$z>$c148px</$n><$q$g$a29.72973%"><object data="//vocaroo.com/player.swf?playMediaID={@id}&amp;autoplay=0"$g$x type="application/x-shockwave-flash" typemustmatch="">$y</object></$q></$v><$s><$n$u$z>$c300px</$n><$q$g$a20%"><$m$f"$l$p$kno"$ohttps://vocaroo.com/embed/{@id}"$g$b/></$q></$s></$w></$q>$i$eVOX"><$q$dvox"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//player.ooyala.com/$m.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec={@id}"$g$b/></$q></$q>$i$eWASHINGTONPOST"><$q$dwashingtonpost"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.washingtonpost.com/video/c/embed/{@id}"$g$b/></$q></$q>$i$eWISTIA"><$q$dwistia"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$ohttps://fast.wistia.net/embed/$m/{@id}"$g$b/></$q></$q>$i$eWSHH"><$q$dwshh"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//www.worldstarhiphop.com/embed/{@id}"$g$b/></$q></$q>$i$eWSJ"><$q$dwsj"$g$c512px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//video-api.wsj.com/api-video/player/$m.html?guid={@id}"$g$b/></$q></$q>$i$eXBOXCLIPS"><$q$dxboxclips"$g$c560px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//gameclips.io/{@user}/{@id}/embed"$g$b/></$q></$q>$i$eXBOXDVR"><$q$dxboxdvr"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//gamerdvr.com/gamer/{@user}/video/{@id}/embed"$g$b/></$q></$q>$i$eYOUKU"><$q$dyouku"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$o//player.youku.com/embed/{@id}"$g$b/></$q></$q>$i$eYOUTUBE"><$q$dyoutube"$g$c640px"><$q$g$a56.25%"><$m$f"$l$p$kno"$gbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$b><$n$usrc">https://www.youtube.com/embed/$h@id"/><xsl:if$t@list">?list=$h@list"/></xsl:if><xsl:if$t@t"><$w><$v$t@list">&amp;</$v><$s>?</$s></$w>start=$h@t"/></xsl:if></$n></$m></$q></$q>$i$ebr"><br/>$i$ee|i|s"/>$ep"><p><xsl:apply-templates/></p>$i</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$c:"display:inline-block;width:100%;max-width:",$d:\' data-s9e-mediaembed="\',$e:\'<xsl:template match="\',$f:\' allowfullscreen="\',$g:\' style="\',$h:\'<xsl:value-of select="\',$i:"</xsl:template>",$j:"var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\'px\'}};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])\\"",
$k:\' scrolling="\',$l:\' loading="\',$m:"iframe",$n:"xsl:attribute",$o:\' src="\',$p:\'lazy"\',$q:"span",$r:\' data-s9e-livepreview-ignore-attrs="\',$s:"xsl:otherwise",$t:\' test="\',$u:\' name="\',$v:"xsl:when",$w:"xsl:choose",$x:\'height:100%;left:0;position:absolute;width:100%"\',$y:\'<param name="allowfullscreen" value="true"/>\',$z:\'style"\'}[a]});function Ea(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(d){return b[d]})}
function Fa(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(d){return b[d]})}function Ga(){this.n={};this.r=[]}Ga.prototype.add=function(a,b,d){d=d||{};"attrName"in d||!this.k||(d.attrName=this.k);"tag"in d||!this.l||(d.tag=this.l);this.n[a]&&this.n[a].forEach(function(g){g(b,d)});this.r.push([a,b,d])};Ga.prototype.getLogs=function(){return this.r};Ga.prototype.on=function(a,b){this.n[a].push(b)};function Ha(a,b){C.add("debug",a,b)}
function J(a,b,d,g,q){this.o=+a;this.name=b;this.k=+d;this.l=+g;this.w=+q||0;this.b={};this.y=[];isNaN(a+d+g)&&D(this)}J.prototype.n=!1;function D(a){a.n||(a.n=!0,a.y.forEach(function(b){D(b)}))}function Ia(a,b){Ja(a,b)?(a.u=b,b.r=a,a.y.push(b),a.n&&D(b)):Ja(b,a)&&(a.r=b,b.u=a)}function Ja(a,b){return a.name===b.name&&1===a.o&&2===b.o&&a.k<=a.k}function Ka(a){var b={},d;for(d in a.b)b[d]=a.b[d];return b}function La(a,b){return a.n||!Ja(b,a)||a.r&&a.r!==b||b.u&&b.u!==a?!1:!0}
function E(a,b){a.b={};for(var d in b)a.b[d]=b[d]}
var K,Ma,L,M,N,Na,C=new Ga,O,P,R={MediaEmbed:{F:function(a,b){b.forEach(function(d){var g=d[0][0];Q(3,"MEDIA",d[0][1],g.length,-10).b.url=g})},A:"://",B:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,C:5E4}},S,Oa={"MediaEmbed.hosts":{"247sports.com":"twentyfoursevensports","8tracks.com":"eighttracks","abcnews.go.com":"abcnews","amazon.ca":"amazon","amazon.co.jp":"amazon","amazon.co.uk":"amazon","amazon.com":"amazon","amazon.de":"amazon","amazon.es":"amazon","amazon.fr":"amazon","amazon.in":"amazon","amazon.it":"amazon",
"anchor.fm":"anchor","archive.org":"internetarchive","audioboo.fm":"audioboom","audioboom.com":"audioboom","audiomack.com":"audiomack","bandcamp.com":"bandcamp","bbc.co.uk":"bbcnews","bbc.com":"bbcnews","bitchute.com":"bitchute","bleacherreport.com":"bleacherreport","break.com":"break","castos.com":"castos","cbsnews.com":"cbsnews","cc.com":"comedycentral","channel.nationalgeographic.com":"natgeochannel","clyp.it":"clyp","cnbc.com":"cnbc","cnn.com":"cnn","codepen.io":"codepen","comedycentral.com":"comedycentral",
"coub.com":"coub","dai.ly":"dailymotion","dailymotion.com":"dailymotion","democracynow.org":"democracynow","docs.google.com":"googlesheets","drive.google.com":"googledrive","dumpert.nl":"dumpert","espn.com":"espn","espn.go.com":"espn","facebook.com":"facebook","falstad.com":"falstad","flic.kr":"flickr","flickr.com":"flickr","funnyordie.com":"funnyordie","gameclips.io":"xboxclips","gamerdvr.com":"xboxdvr","gamespot.com":"gamespot","gametrailers.com":"gametrailers","gettyimages.be":"getty","gettyimages.cn":"getty",
"gettyimages.co.jp":"getty","gettyimages.co.uk":"getty","gettyimages.com":"getty","gettyimages.com.au":"getty","gettyimages.de":"getty","gettyimages.dk":"getty","gettyimages.es":"getty","gettyimages.fr":"getty","gettyimages.ie":"getty","gettyimages.it":"getty","gettyimages.nl":"getty","gettyimages.pt":"getty","gettyimages.se":"getty","gfycat.com":"gfycat","gifs.com":"gifs","giphy.com":"giphy","github.com":"gist","globalnews.ca":"globalnews","gofundme.com":"gofundme","gty.im":"getty","hudl.com":"hudl",
"hulu.com":"hulu","ign.com":"ign","imdb.com":"imdb","imgur.com":"imgur","indiegogo.com":"indiegogo","instagram.com":"instagram","izlesene.com":"izlesene","jsfiddle.net":"jsfiddle","jwplatform.com":"jwplatform","kaltura.com":"kaltura","kickstarter.com":"kickstarter","libsyn.com":"libsyn","link.brightcove.com":"brightcove","link.tospotify.com":"spotify","liveleak.com":"liveleak","livestre.am":"livestream","livestream.com":"livestream","medium.com":"medium","megaphone.fm":"megaphone","megaphone.link":"megaphone",
"metacafe.com":"metacafe","mixcloud.com":"mixcloud","mixer.com":"mixer","mlb.com":"mlb","money.cnn.com":"cnnmoney","mrctv.org":"mrctv","msnbc.com":"msnbc","my.mail.ru":"mailru","n.pr":"npr","nbcnews.com":"nbcnews","nbcsports.com":"nbcsports","nhl.com":"nhl","npr.org":"npr","nytimes.com":"nytimes","open.spotify.com":"spotify","orfium.com":"orfium","pastebin.com":"pastebin","pinterest.com":"pinterest","play.spotify.com":"spotify","players.brightcove.net":"brightcove","plus.google.com":"googleplus",
"podbean.com":"podbean","prezi.com":"prezi","reddit.com":"reddit","rumble.com":"rumble","rutube.ru":"rutube","scribd.com":"scribd","sendvid.com":"sendvid","slideshare.net":"slideshare","soundcloud.com":"soundcloud","sporcle.com":"sporcle","sportsnet.ca":"sportsnet","spreaker.com":"spreaker","stitcher.com":"stitcher","store.steampowered.com":"steamstore","strawpoll.me":"strawpoll","streamable.com":"streamable","streamja.com":"streamja","t.me":"telegram","teamcoco.com":"teamcoco","ted.com":"ted","theatlantic.com":"theatlantic",
"theguardian.com":"theguardian","theonion.com":"theonion","tiktok.com":"tiktok","tmz.com":"tmz","tradingview.com":"tradingview","traileraddict.com":"traileraddict","trendingviews.co":"trendingviews","tumblr.com":"tumblr","twitch.tv":"twitch","twitter.com":"twitter","ustream.tv":"ustream","vbox7.com":"vbox7","veoh.com":"veoh","vevo.com":"vevo","video.foxnews.com":"foxnews","video.khl.ru":"khl","video.nationalgeographic.com":"natgeovideo","videodetective.com":"videodetective","vimeo.com":"vimeo","vine.co":"vine",
"vk.com":"vk","vkontakte.ru":"vk","voca.ro":"vocaroo","vocaroo.com":"vocaroo","vox.com":"vox","washingtonpost.com":"washingtonpost","wistia.com":"wistia","worldstarhiphop.com":"wshh","wsj.com":"wsj","xboxclips.com":"xboxclips","xboxdvr.com":"xboxdvr","youku.com":"youku","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{abcnews:[[[/abcnews\\.go\\.com\\/(?:video\\/embed\\?id=|[^\\/]+\\/video\\/[^\\/]+-)(\\d+)/,p]],[]],amazon:[[[/\\/(?:dp|gp\\/product)\\/([A-Z0-9]+)/,p],[/amazon\\.(?:co\\.)?(ca|de|es|fr|in|it|jp|uk)/,
["","tld"]]],[]],anchor:[[[/anchor.fm\\/[-\\w]+\\/episodes\\/(?:[-\\w]+-)(\\w+)(?![-\\w])/,p]],[]],audioboom:[[[/audioboo(?:\\.f|m\\.co)m\\/(?:boo|post)s\\/(\\d+)/,p]],[]],audiomack:[[[/audiomack\\.com\\/(album|song)\\/([-\\w]+)\\/([-\\w]+)/,["","mode","artist","title"]],[/audiomack\\.com\\/([-\\w]+)\\/(album|song)\\/([-\\w]+)/,["","artist","mode","title"]]],[]],bandcamp:[[],[{a:[[/\\/album=(\\d+)/,ha]],match:[[/bandcamp\\.com\\/album\\/./,c]]},{a:[[/"album_id":(\\d+)/,ha],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,
fa]],match:[[/bandcamp\\.com\\/track\\/./,c]]}]],bbcnews:[[[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/(?:\\w+-)+(\\d+)/,p],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/embed\\/(\\w+\\/\\d+)/,p],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/\\w+\\/(\\d+)/,p]],[]],bitchute:[[[/bitchute\\.com\\/(?:embed|video)\\/([-\\w]+)/,p]],[]],bleacherreport:[[],[{a:[[/id="video-([-\\w]+)/,p],[/video_embed\\?id=([-\\w]+)/,p]],match:[[/\\/articles\\/./,c]]}]],"break":[[[/break\\.com\\/video\\/.*-(\\d+)$/,p]],[]],brightcove:[[[/link\\.brightcove\\.com\\/services\\/player\\/bcpid(\\d+).*?bckey=([-,~\\w]+).*?bctid=(\\d+)/,
["","bcpid","bckey","bctid"]],[/players\\.brightcove\\.net\\/(\\d+)\\/.*?videoId=(\\d+)/,["","bcpid","bctid"]]],[]],castos:[ta,[{a:ta,match:[[/castos\\.com\\/(?:podcasts\\/[^\\/]*\\/)?episodes\\/./,c]]}]],cbsnews:[[[/cbsnews\\.com\\/videos?\\/(?!watch\\/)([-\\w]+)/,p],[/cbsnews\\.com\\/video\\/watch\\/\\?id=(\\d+)/,p]],[]],clyp:[[[/clyp\\.it\\/(?!user\\/)(\\w+)/,p]],[]],cnbc:[[[/cnbc\\.com\\/gallery\\/\\?video=(\\d+)/,p]],[{a:[[/byGuid=(\\d+)/,p]],match:[[/cnbc\\.com\\/video\\/20\\d\\d\\/\\d\\d\\/\\d\\d\\/\\w/,c]]}]],cnn:[[[/cnn.com\\/videos\\/(.*\\.cnn)/,
p],[/cnn\\.com\\/video\\/data\\/2\\.0\\/video\\/(.*\\.cnn)/,p]],[]],cnnmoney:[[[/money\\.cnn\\.com\\/video\\/(.*\\.cnnmoney)/,p]],[]],codepen:[[[/codepen\\.io\\/([-\\w]+)\\/(?:details|embed|full|live|pen)\\/(\\w+)/,ia]],[]],comedycentral:[[],[{a:[[/(mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)/,p]],match:[[/c(?:c|omedycentral)\\.com\\/(?:full-episode|video-clip)s\\//,c]]}]],coub:[[[/coub\\.com\\/view\\/(\\w+)/,p]],[]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,p],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,
p],[/start=(\\d+)/,f]],[]],democracynow:[[[/democracynow.org\\/(?:embed\\/)?((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)/,p]],[{a:[[/democracynow\\.org\\/((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)\' rel=\'canonical/,p]],match:[[/m\\.democracynow\\.org\\/stories\\/\\d/,c]]}]],dumpert:[[[/dumpert\\.nl\\/(?:item|mediabase)\\/(\\d+[\\/_]\\w+)/,p]],[]],eighttracks:[[[/8tracks\\.com\\/[-\\w]+\\/(\\d+)(?=#|$)/,p]],[{a:[[/eighttracks:\\/\\/mix\\/(\\d+)/,p]],match:[[/8tracks\\.com\\/[-\\w]+\\/\\D/,c]]}]],espn:[[[/video\\/(?:clip(?:\\?id=|\\/_\\/id\\/))?(\\d+)/,
p]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,p],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,ca],[/facebook\\.com\\/watch\\/\\?([pv])=/,ca]],[]],falstad:[[[/falstad\\.com\\/circuit\\/circuitjs\\.html\\?c(?:ct=([^&]+)|tz=([-+=\\w]+))/,["","cct","ctz"]]],[]],flickr:[[sa,[/flic\\.kr\\/(?!p\\/)[^\\/]+\\/(\\d+)/,p]],
[{a:[sa],match:[[/flic\\.kr\\/p\\/(\\w+)/,["","short"]]],p:"https://www.flickr.com/photo.gne?rb=1&short={@short}"}]],foxnews:[[[/video\\.foxnews\\.com\\/v\\/(\\d+)/,p]],[]],funnyordie:[[[/funnyordie\\.com\\/videos\\/([0-9a-f]+)/,p]],[]],gamespot:[[[/gamespot\\.com.*?\\/(?:events|videos)\\/.*?-(\\d+)\\/(?:[#?].*)?$/,p]],[]],gametrailers:[[],[{a:[[da,p]],match:[[/gametrailers\\.com\\/(?:full-episode|review|video)s\\//,c]]}]],getty:[[[/gty\\.im\\/(\\d+)/,p],[/gettyimages\\.[.\\w]+\\/detail(?=\\/).*?\\/(\\d+)/,p],[/#[-\\w]*picture-id(\\d+)$/,
p]],[{a:[[/"height":[ "]*(\\d+)/,u],[/"width":[ "]*(\\d+)/,r],[/\\bid[=:][\'"]?([-=\\w]+)/,["","et"]],[/\\bsig[=:][\'"]?([-=\\w]+)/,["","sig"]]],match:v,p:"https://embed.gettyimages.com/preview/{@id}"}]],gfycat:[[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?(\\w+)/,p]],[{a:[[/\\/ifr\\/(\\w+)/,p]],match:[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?[a-z]/,c]],p:"https://gfycat.com/ifr/{@id}"},{a:[[/"height":(\\d+)/,u],[/"width":(\\d+)/,
r]],match:v,p:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}"}]],gifs:[[[/gifs\\.com\\/(?:gif\\/)?(\\w+)/,p]],[{a:[[/meta property="og:image:width" content="(\\d+)/,r],[/meta property="og:image:height" content="(\\d+)/,u]],match:v,p:"https://gifs.com/gif/{@id}"}]],giphy:[[[/giphy\\.com\\/(gif|video|webp)\\w+\\/(?:[-\\w]+-)*(\\w+)/,["","type","id"]],[/giphy\\.com\\/media\\/(\\w+)\\/\\w+\\.(gif|webp)/,ja],[/i\\.giphy\\.com\\/(\\w+)\\.(gif|webp)/,ja]],[{a:[[/"height"\\s*:\\s*(\\d+)/,u],[/"width"\\s*:\\s*(\\d+)/,r]],
match:v,p:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif"}]],gist:[[[/gist\\.github\\.com\\/((?:\\w+\\/)?[\\da-f]+(?:\\/[\\da-f]+)?)/,p]],[]],globalnews:[qa,[{a:qa,match:[[/globalnews\\.ca\\/video\\/rd\\//,c]]}]],gofundme:[[[/gofundme\\.com\\/(\\w+)(?![^#?])/,p]],[]],googledrive:[[[/drive\\.google\\.com\\/.*?(?:file\\/d\\/|id=)([-\\w]+)/,p]],[]],googleplus:[[[/\\/\\/plus\\.google\\.com\\/(?:u\\/\\d+\\/)?(?:\\+([^\\/]+)|(\\d+))\\/posts\\/(\\w+)/,["","name","oid","pid"]]],[]],googlesheets:[[[/docs\\.google\\.com\\/spreadsheet(?:\\/ccc\\?key=|(?:[^e]\\/)+)((?:e\\/)?[-\\w]+)/,
p],[/oid=(\\d+)/,["","oid"]],[/#gid=(\\d+)/,["","gid"]],[/\\/pub(chart)/,ca]],[]],hudl:[[[/hudl\\.com\\/athlete\\/(\\d+)\\/highlights\\/([\\da-f]+)/,oa],va,ra],[{a:[va,ra],match:[[/hudl\\.com\\/v\\//,c]]}]],hulu:[[],[{a:[[/eid=([-\\w]+)/,p]],match:[[/hulu\\.com\\/watch\\//,c]]}]],ign:[[[/(https?:\\/\\/.*?ign\\.com\\/videos\\/.+)/i,p]],[]],imdb:[[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)/,p]],[]],imgur:[[[/imgur\\.com\\/(a\\/\\w+)/,p],[/i\\.imgur\\.com\\/(\\w{5,7})[lms]?\\./,p],[/imgur\\.com\\/(\\w+)(?![\\w.\\/])/,p]],[{a:[[/data-id="([\\w\\/]+)"/,
p]],match:[[/imgur\\.com\\/(?![art]\\/|user\\/)((?:gallery\\/)?\\w+)(?![\\w.])/,["","path"]]],p:"https://api.imgur.com/oembed.xml?url=/{@path}"}]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,p]],[]],instagram:[[[/instagram\\.com\\/(?:p|tv)\\/([-\\w]+)/,p]],[]],internetarchive:[[],[{a:[[/meta property="twitter:player" content="https:\\/\\/archive.org\\/embed\\/([^\\/"]+)/,p],[/meta property="og:video:width" content="(\\d+)/,r],[/meta property="og:video:height" content="(\\d+)/,u]],match:[[/archive\\.org\\/(?:details|embed)\\//,
c]]}]],izlesene:[[[/izlesene\\.com\\/video\\/[-\\w]+\\/(\\d+)/,p]],[]],jsfiddle:[[[/jsfiddle.net\\/(?:(\\w+)\\/)?(?!\\d+\\b|embedded\\b|show\\b)(\\w+)\\b(?:\\/(\\d+)\\b)?/,["","user","id","revision"]]],[]],jwplatform:[[[/jwplatform\\.com\\/\\w+\\/([-\\w]+)/,p]],[]],kaltura:[[[/\\/p(?:artner_id)?\\/(\\d+)\\//,["","partner_id"]],[/\\/sp\\/(\\d+)\\//,["","sp"]],[/\\/uiconf_id\\/(\\d+)\\//,["","uiconf_id"]],[/\\bentry_id[=\\/](\\w+)/,["","entry_id"]]],[{a:[[/kaltura\\.com\\/+p\\/(\\d+)\\/sp\\/(\\d+)\\/\\w*\\/uiconf_id\\/(\\d+)\\/.*?\\bentry_id=(\\w+)/,
["","partner_id","sp","uiconf_id","entry_id"]]],match:[[/kaltura\\.com\\/(?:media\\/t|tiny)\\/./,c]]}]],khl:[[],[{a:[[/\\/feed\\/start\\/([\\/\\w]+)/,p]],match:[[/video\\.khl\\.ru\\/(?:event|quote)s\\/\\d/,c]]}]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],libsyn:[[],[{a:[[/embed\\/episode\\/id\\/(\\d+)/,p]],match:[[/(?!\\.mp3)....$/,c]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,p]],[{a:[[/liveleak\\.com\\/e\\/(\\w+)/,p]],match:[[/liveleak\\.com\\/view\\?t=/,
c]]}]],livestream:[[[/livestream\\.com\\/accounts\\/(\\d+)\\/events\\/(\\d+)/,pa],[/\\/videos\\/(\\d+)/,ea],[/original\\.livestream\\.com\\/(\\w+)\\/video\\?clipId=([-\\w]+)/,w]],[{a:[[/accounts\\/(\\d+)\\/events\\/(\\d+)/,pa]],match:[[/livestream\\.com\\/(?!accounts\\/\\d+\\/events\\/\\d)/,c]]},{a:[[/\\/\\/original\\.livestream\\.com\\/(\\w+)\\/video\\/([-\\w]+)/,w]],match:[[/livestre.am/,c]]}]],mailru:[[],[{a:[[/"itemId": ?"?(\\d+)/,p]],match:[[/my\\.mail\\.ru\\/\\w+\\/\\w+\\/video\\/\\w+\\/\\d/,c]]}]],medium:[[[/medium\\.com\\/(?:s\\/\\w+\\/|@?\\w+\\/)?(?:\\w+-)*([0-9a-f]+)/,
p]],[]],megaphone:[[[/megaphone\\.fm\\/.*?\\?(?:e|selected)=(\\w+)/,p],[/(?:dcs|player|traffic)\\.megaphone\\.fm\\/(\\w+)/,p],[/megaphone\\.link\\/(\\w+)/,p]],[]],metacafe:[[[/metacafe\\.com\\/watch\\/(\\d+)/,p]],[]],mixcloud:[[[/mixcloud\\.com\\/(?!categories|tag)([-\\w]+\\/[^\\/&]+)\\//,p]],[]],mixer:[[[/mixer.com\\/(?!browse\\/)(\\w+)(?!\\?clip|\\w)(?:\\?vod=([-\\w]+))?/,["","channel","vod"]]],[]],mlb:[[[/mlb\\.com\\/video\\/(?:[-\\w\\/]+\\/)?(?:c-|v|[-\\w]+-c)(\\d+)/,p]],[]],mrctv:[[],[{a:[[/mrctv\\.org\\/embed\\/(\\d+)/,p]],match:[[/mrctv\\.org\\/videos\\/./,
c]]}]],msnbc:[[],[{a:[[/embedded-video\\/(?!undefined)(\\w+)/,p]],match:[[/msnbc\\.com\\/[-\\w]+\\/watch\\//,c],[/on\\.msnbc\\.com\\/./,c]]}]],natgeochannel:[[[/channel\\.nationalgeographic\\.com\\/([-\\/\\w]+\\/videos\\/[-\\w]+)/,p]],[]],natgeovideo:[[],[{a:[[/guid="([-\\w]+)"/,p]],match:[[/video\\.nationalgeographic\\.com\\/(?:tv|video)\\/\\w/,c]]}]],nbcnews:[[[/nbcnews\\.com\\/(?:widget\\/video-embed\\/|video\\/[-\\w]+-)(\\d+)/,p]],[]],nbcsports:[[],[{a:[[/select\\/media\\/(\\w+)/,p]],match:[[/nbcsports\\.com\\/video\\/./,c]]}]],
nhl:[[[/nhl\\.com\\/(?:\\w+\\/)?video(?:\\/(?![ct]-)[-\\w]+)?(?:\\/t-(\\d+))?(?:\\/c-(\\d+))?/,["","t","c"]]],[]],npr:[[],[{a:[[/player\\/embed\\/(\\d+)\\/(\\d+)/,["","i","m"]]],q:"Cookie: trackingChoice=false; choiceVersion=1",match:[[/npr\\.org\\/[\\/\\w]+\\/\\d+/,c],[/n\\.pr\\/\\w/,c]]}]],nytimes:[[[/nytimes\\.com\\/video\\/[a-z]+\\/(?:[a-z]+\\/)?(\\d+)/,p],[/nytimes\\.com\\/video\\/\\d+\\/\\d+\\/\\d+\\/[a-z]+\\/(\\d+)/,p]],[{a:[[/\\/video\\/movies\\/(\\d+)/,p]],match:[[/nytimes\\.com\\/movie(?:s\\/movie)?\\/(\\d+)\\/[-\\w]+\\/trailers/,["","playlist"]]],
p:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true"}]],orfium:[[[/album\\/(\\d+)/,ha],[/playlist\\/(\\d+)/,ma],[/live-set\\/(\\d+)/,["","set_id"]],[/track\\/(\\d+)/,fa]],[]],pastebin:[[[/pastebin\\.com\\/(?!u\\/)(?:\\w+(?:\\.php\\?i=|\\/))?(\\w+)/,p]],[]],pinterest:[[[/pinterest.com\\/pin\\/(\\d+)/,p],[/pinterest.com\\/(?!_\\/|discover\\/|explore\\/|news_hub\\/|pin\\/|search\\/)([-\\w]+\\/[-\\w]+)/,p]],[]],podbean:[[[/podbean\\.com\\/media\\/(?:player\\/|share\\/pb-)([-\\w]+)/,p]],[{a:[[/podbean\\.com\\/media\\/player\\/([-\\w]+)/,
p]],match:[[/podbean\\.com\\/(?:media\\/shar)?e\\/(?!pb-)/,c]]}]],prezi:[[[/\\/\\/prezi\\.com\\/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)\\/)(\\w+)\\//,p]],[]],reddit:[[[/(\\w+\\/comments\\/\\w+(?:\\/\\w+\\/\\w+)?)/,p]],[]],rumble:[[[/rumble\\.com\\/embed\\/(\\w+)/,p]],[{a:[[/video"?:"(\\w+)/,p]],match:[[/rumble\\.com\\/(?!embed\\/)./,c]]}]],rutube:[[[/rutube\\.ru\\/tracks\\/(\\d+)/,
p]],[{a:[[/rutube\\.ru\\/play\\/embed\\/(\\d+)/,p]],q:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/rutube\\.ru\\/video\\/([0-9a-f]{32})/,ba]],p:"http://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/"}]],scribd:[[[/scribd\\.com\\/(?:mobile\\/)?(?:doc(?:ument)?|presentation)\\/(\\d+)/,p]],[]],sendvid:[[[/sendvid\\.com\\/(\\w+)/,p]],[]],slideshare:[[[/slideshare\\.net\\/[^\\/]+\\/[-\\w]+-(\\d{6,})$/,p]],[{a:[[/"presentationId":(\\d+)/,p]],match:[[/slideshare\\.net\\/[^\\/]+\\/\\w(?![-\\w]+-\\d{6,}$)/,
c]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,p],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,ma],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{a:[[/soundcloud:tracks:(\\d+)/,fa]],q:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,c]]},{a:[[/soundcloud:\\/\\/playlists:(\\d+)/,
ma]],q:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/\\w+\\/sets\\//,c]]}]],sporcle:[[[/sporcle.com\\/framed\\/.*?gid=(\\w+)/,p]],[{a:[[/encodedGameID\\W+(\\w+)/,p]],match:[[/sporcle\\.com\\/games\\/(?!\\w*category\\/)[-\\w]+\\/[-\\w]/,c]]}]],sportsnet:[[],[{a:[[/vid(?:eoId)?=(\\d+)/,p],[/param name="@videoPlayer" value="(\\d+)"/,p]],match:v}]],spotify:[wa,[{a:wa,q:"User-agent: PHP (not Mozilla)",match:[[/link\\.tospotify\\.com\\/./,c]]}]],spreaker:[[[/spreaker\\.com\\/episode\\/(\\d+)/,la]],[{a:[[/episode_id=(\\d+)/,
la],[/show_id=(\\d+)/,["","show_id"]]],match:[[/(.+\\/(?:show\\/|user\\/.+\\/).+)/,["","url"]]],p:"https://api.spreaker.com/oembed?format=json&url={@url}"}]],steamstore:[[[/store.steampowered.com\\/app\\/(\\d+)/,p]],[]],stitcher:[[[/\\/(?:embed|splayer\\/f)\\/(\\d+)\\/(\\d+)/,ka]],[{a:[[/\\/embed\\/(\\d+)\\/(\\d+)/,ka]],match:[[/\\/(?:podcast\\/|show\\/|s\\?)/,c]]}]],strawpoll:[[[/strawpoll\\.me\\/(\\d+)/,p]],[]],streamable:[[[/streamable\\.com\\/(\\w+)/,p]],[]],streamja:[[[/streamja\\.com\\/(?!login|signup|terms|videos)(\\w+)/,
p]],[]],teamcoco:[[[/teamcoco\\.com\\/video\\/(\\d+)/,p]],[{a:[[/embed\\/v\\/(\\d+)/,p]],match:[[/teamcoco\\.com\\/video\\/\\D/,c]]}]],ted:[[[/ted\\.com\\/((?:talk|playlist)s\\/[-\\w]+(?:\\.html)?)(?![-\\w]|\\/transcript)/i,p]],[]],telegram:[[[/\\/\\/t.me\\/(?!addstickers\\/|joinchat\\/)(\\w+\\/\\d+)/,p]],[]],theatlantic:[[[/theatlantic\\.com\\/video\\/index\\/(\\d+)/,p]],[]],theguardian:[[[/theguardian\\.com\\/(\\w+\\/video\\/20(?:0[0-9]|1[0-7])[-\\/\\w]+)/,p]],[]],theonion:[[[/theonion\\.com\\/video\\/[-\\w]+[-,](\\d+)/,p]],[]],tiktok:[[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|i18n\\/share\\/video)\\/(\\d+)/,
p]],[{a:[[/tiktok\\.com\\/@[.\\w]+\\/video\\/(\\d+)/,p]],q:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/\\/\\/vm\\.tiktok\\.com\\/./,c]]}]],tmz:[[[/tmz\\.com\\/videos\\/(\\w+)/,p]],[]],tradingview:[[[/tradingview\\.com\\/(?:chart\\/[^\\/]+|i)\\/(\\w+)/,["","chart"]],[/tradingview\\.com\\/symbols\\/([-:\\w]+)/,["","symbol"]]],[]],traileraddict:[[],[{a:[[/v\\.traileraddict\\.com\\/(\\d+)/,p]],match:[[/traileraddict\\.com\\/(?!tags\\/)[^\\/]+\\/./,c]]}]],trendingviews:[[[/trendingviews.co\\/(?:video|embed)\\/(?:[^\\/]+-)?(\\d+)/,
p]],[]],tumblr:[[[/([-\\w]+)\\.tumblr\\.com\\/post\\/(\\d+)/,["","name","id"]]],[{a:[[/did=\\\\u0022([-\\w]+)/,["","did"]],[/embed\\\\\\/post\\\\\\/([-\\w]+)/,["","key"]]],q:"User-agent: curl",match:[[/\\w\\.tumblr\\.com\\/post\\/\\d/,c]],p:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}"}]],twentyfoursevensports:[ua,[{a:ua,q:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Player\\/[-\\w]*\\d/,c]]},
{a:[[/player_id%3[Dd](\\d+)/,ea]],q:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Video\\/./,c]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,ea],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/(\\w+))?/,w],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,f],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?(\\w+)/,w]],[]],twitter:[[[/twitter\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,p]],[]],ustream:[[[/ustream\\.tv\\/recorded\\/(\\d+)/,
ba]],[{a:[[da,["","cid"]]],match:[[/ustream\\.tv\\/(?!explore\\/|platform\\/|recorded\\/|search\\?|upcoming$|user\\/)(?:channel\\/)?[-\\w]+/,c]]}]],vbox7:[[[/vbox7\\.com\\/play:([\\da-f]+)/,p]],[]],veoh:[[[/veoh\\.com\\/(?:m\\/watch\\.php\\?v=|watch\\/)v(\\w+)/,p]],[]],vevo:[[[/vevo\\.com\\/watch\\/(.*?\\/)?([A-Z]+\\d+)/,["","","id"]]],[]],videodetective:[[[/videodetective\\.com\\/\\w+\\/[-\\w]+\\/(?:trailer\\/P0*)?(\\d+)/,p]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,p],[/#t=([\\dhms]+)/,f]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,
p]],[]],vk:[[[/vk(?:\\.com|ontakte\\.ru)\\/(?:[\\w.]+\\?z=)?video(-?\\d+)_(\\d+).*?hash=([0-9a-f]+)/,na],[/vk(?:\\.com|ontakte\\.ru)\\/video_ext\\.php\\?oid=(-?\\d+)&id=(\\d+)&hash=([0-9a-f]+)/,na]],[{a:[[/meta property="og:video" content=".*?oid=(-?\\d+).*?id=(\\d+).*?hash=([0-9a-f]+)/,na]],q:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/^(?!.*?hash=)/,c]]}]],vocaroo:[[[/voca(?:\\.ro|roo\\.com)\\/(?:i\\/)?(\\w+)/,p]],[]],vox:[[[/vox.com\\/.*#ooid=([-\\w]+)/,p]],[]],washingtonpost:[[[/washingtonpost\\.com\\/video\\/c\\/\\w+\\/([-0-9a-f]+)/,
p],[/washingtonpost\\.com\\/video\\/[-\\/\\w]+\\/([-0-9a-f]+)_video\\.html/,p]],[]],wistia:[[[/wistia.com\\/medias\\/(\\w+)/,p]],[]],wshh:[[[/worldstarhiphop\\.com\\/featured\\/(\\d+)/,p]],[{a:[[/v: ?"?(\\d+)/,p]],match:[[/worldstarhiphop\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,c]]}]],wsj:[[[/wsj\\.com\\/[^#]*#!([-0-9A-F]{36})/,p],[/wsj\\.com\\/video\\/[^\\/]+\\/([-0-9A-F]{36})/,p]],[{a:[[/guid=([-0-9A-F]{36})/,p]],match:[[/on\\.wsj\\.com\\/\\w/,c]]}]],xboxclips:[[[/(?:gameclips\\.io|xboxclips\\.com)\\/(?!game\\/)([^\\/]+)\\/(?!screenshots\\/)([-0-9a-f]+)/,
ia]],[]],xboxdvr:[[[/(?:gamer|xbox)dvr\\.com\\/gamer\\/([^\\/]+)\\/video\\/(\\d+)/,ia]],[]],youku:[[[/youku\\.com\\/v(?:_show|ideo)\\/id_(\\w+=*)/,p]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|v\\/|attribution_link.*?v%3D)([-\\w]+)/,p],[/youtu\\.be\\/([-\\w]+)/,p],[/[#&?]t=(\\d[\\dhms]*)/,f],[/[&?]list=([-\\w]+)/,["","list"]]],[{a:[[/\\/vi\\/([-\\w]+)/,p]],match:[[/\\/shared\\?ci=/,c]]}]]},urlConfig:{G:/^https?$/i}},Pa={e:[771],flags:0},T={ABCNEWS:H,AMAZON:{e:e,b:{id:z,tld:B},h:1,d:G,f:10,j:t,g:5E3},ANCHOR:H,AUDIOBOOM:H,
AUDIOMACK:{e:e,b:{artist:B,mode:B,title:B},h:1,d:G,f:10,j:t,g:5E3},BANDCAMP:{e:e,b:{album_id:B,track_id:B,track_num:B},h:1,d:G,f:10,j:t,g:5E3},BBCNEWS:H,BITCHUTE:H,BLEACHERREPORT:H,BREAK:H,BRIGHTCOVE:{e:e,b:{bckey:B,bcpid:B,bctid:B},h:1,d:G,f:10,j:t,g:5E3},CASTOS:{e:e,b:{host:B,id:B},h:1,d:G,f:10,j:t,g:5E3},CBSNEWS:H,CLYP:H,CNBC:H,CNN:H,CNNMONEY:H,CODEPEN:Ba,COMEDYCENTRAL:H,COUB:H,DAILYMOTION:{e:e,b:{id:B,t:B},h:1,d:G,f:10,j:t,g:5E3},DEMOCRACYNOW:H,DUMPERT:H,EIGHTTRACKS:H,ESPN:H,FACEBOOK:{e:e,b:{id:B,
type:B,user:B},h:1,d:G,f:10,j:t,g:5E3},FALSTAD:{e:e,b:{cct:B,ctz:B},h:1,d:G,f:10,j:t,g:5E3},FLICKR:H,FOXNEWS:H,FUNNYORDIE:H,GAMESPOT:H,GAMETRAILERS:H,GETTY:{e:e,b:{et:B,height:za,id:B,sig:B,width:Aa},h:1,d:G,f:10,j:t,g:5E3},GFYCAT:Ca,GIFS:Ca,GIPHY:{e:e,b:{height:za,id:B,type:B,width:Aa},h:1,d:G,f:10,j:t,g:5E3},GIST:H,GLOBALNEWS:H,GOFUNDME:H,GOOGLEDRIVE:H,GOOGLEPLUS:{e:e,b:{name:{d:[function(a){return decodeURIComponent(""+a)}],s:!1},oid:B,pid:B},h:1,d:G,f:10,j:t,g:5E3},GOOGLESHEETS:{e:e,b:{gid:B,
id:B,oid:B,type:B},h:1,d:G,f:10,j:t,g:5E3},HUDL:{e:e,b:{athlete:B,highlight:B,id:B},h:1,d:G,f:10,j:t,g:5E3},HULU:H,IGN:H,IMDB:H,IMGUR:H,INDIEGOGO:H,INSTAGRAM:H,INTERNETARCHIVE:{e:e,b:{height:za,id:{d:[function(){return!1}],s:!1},width:Aa},h:1,d:G,f:10,j:t,g:5E3},IZLESENE:H,JSFIDDLE:{e:e,b:{id:B,revision:B,user:B},h:1,d:G,f:10,j:t,g:5E3},JWPLATFORM:H,KALTURA:{e:e,b:{entry_id:z,partner_id:z,sp:B,uiconf_id:z},h:1,d:G,f:10,j:t,g:5E3},KHL:H,KICKSTARTER:{e:e,b:{card:B,id:B,video:B},h:1,d:G,f:10,j:t,g:5E3},
LIBSYN:H,LIVELEAK:H,LIVESTREAM:{e:e,b:{account_id:B,channel:B,clip_id:B,event_id:B,video_id:B},h:1,d:G,f:10,j:t,g:5E3},MAILRU:H,MEDIA:{e:[770],b:{},h:0,d:[function(a){return function(b,d,g){function q(h,l,n){var k=!1;n.forEach(function(m){var x=m[1],A=m[0].exec(l);A&&(k=!0,x.forEach(function(I,y){""<A[y]&&""<I&&(h[I]=A[y])}))});return k}(function(h,l,n){D(h);if("url"in h.b){var k=h.b.url,m;a:{for(m=/^https?:\\/\\/([^\\/]+)/.exec(k.toLowerCase())[1]||"";""<m;){if(l[m]){m=l[m];break a}m=m.replace(/^[^.]*./,
"")}m=""}if(n[m]){l={};q(l,k,n[m][0]);a:{for(var x in l){n=!1;break a}n=!0}if(!n){n=h.k;x=h.u;if(x){var A=h.l;k=x.k;x=x.l}else A=0,k=h.k+h.l,x=0;m=m.toUpperCase();h=h.w;k=Q(2,m,k,x,-h||0);h=Q(1,m,n,A,h||0);Ia(h,k);E(h,l)}}}})(b,d,g)}(a,Oa["MediaEmbed.hosts"],Oa["MediaEmbed.sites"],Oa.cacheDir)}],f:10,j:{flags:513},g:5E3},MEDIUM:H,MEGAPHONE:H,METACAFE:H,MIXCLOUD:H,MIXER:{e:e,b:{channel:B,vod:B},h:1,d:G,f:10,j:t,g:5E3},MLB:H,MRCTV:H,MSNBC:H,NATGEOCHANNEL:H,NATGEOVIDEO:H,NBCNEWS:H,NBCSPORTS:H,NHL:{e:e,
b:{c:B,t:B},h:1,d:G,f:10,j:t,g:5E3},NPR:{e:e,b:{i:B,m:B},h:1,d:G,f:10,j:t,g:5E3},NYTIMES:H,ORFIUM:{e:e,b:{album_id:B,playlist_id:B,set_id:B,track_id:B},h:1,d:G,f:10,j:t,g:5E3},PASTEBIN:H,PINTEREST:H,PODBEAN:H,PREZI:H,REDDIT:H,RUMBLE:H,RUTUBE:H,SCRIBD:H,SENDVID:H,SLIDESHARE:H,SOUNDCLOUD:{e:e,b:{id:B,playlist_id:B,secret_token:B,track_id:B},h:1,d:G,f:10,j:t,g:5E3},SPORCLE:H,SPORTSNET:H,SPOTIFY:H,SPREAKER:{e:e,b:{episode_id:B,show_id:B},h:1,d:G,f:10,j:t,g:5E3},STEAMSTORE:H,STITCHER:{e:e,b:{eid:B,fid:B},
h:1,d:G,f:10,j:t,g:5E3},STRAWPOLL:H,STREAMABLE:H,STREAMJA:H,TEAMCOCO:H,TED:H,TELEGRAM:H,THEATLANTIC:H,THEGUARDIAN:H,THEONION:H,TIKTOK:H,TMZ:H,TRADINGVIEW:{e:e,b:{chart:B,symbol:B},h:1,d:G,f:10,j:t,g:5E3},TRAILERADDICT:H,TRENDINGVIEWS:H,TUMBLR:{e:e,b:{did:B,id:B,key:B,name:B},h:1,d:G,f:10,j:t,g:5E3},TWENTYFOURSEVENSPORTS:{e:e,b:{player_id:B,video_id:B},h:1,d:G,f:10,j:t,g:5E3},TWITCH:{e:e,b:{channel:B,clip_id:B,t:B,video_id:B},h:1,d:G,f:10,j:t,g:5E3},TWITTER:H,USTREAM:{e:e,b:{cid:B,vid:B},h:1,d:G,f:10,
j:t,g:5E3},VBOX7:H,VEOH:H,VEVO:H,VIDEODETECTIVE:H,VIMEO:{e:e,b:{id:B,t:ya},h:1,d:G,f:10,j:t,g:5E3},VINE:H,VK:{e:e,b:{hash:B,oid:B,vid:B},h:1,d:G,f:10,j:t,g:5E3},VOCAROO:H,VOX:H,WASHINGTONPOST:H,WISTIA:H,WSHH:H,WSJ:H,XBOXCLIPS:Ba,XBOXDVR:Ba,YOUKU:H,YOUTUBE:{e:e,b:{id:{d:[function(a){return/^[-0-9A-Za-z_]+$/.test(a)?a:!1}],s:!1},list:B,t:ya},h:1,d:G,f:10,j:t,g:5E3}},U,Qa,V,W,Ra=0,X;
function Sa(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=C;b.r=[];delete b.k;delete b.l;K={};Ma={};M=0;N=null;Na=!1;O=[];P="";S=0;U=[];Qa=!1;V=a;W=V.length;X=0;L=Pa;L.z=!1;++Ra;a=Ra;for(var d in R)if(!R[d].v)a:{b=d;var g=R[b];if(!(g.A&&0>V.indexOf(g.A))){var q=[];if("undefined"!==typeof g.B&&"undefined"!==typeof g.C){q=void 0;var h=g.B;g=g.C;h.lastIndex=0;for(var l=[],n=0;++n<=g&&(q=h.exec(V));){for(var k=q.index,m=[[q[0],k]],x=0;++x<q.length;){var A=q[x];void 0===
A?m.push(["",-1]):(m.push([A,V.indexOf(A,k)]),k+=A.length)}l.push(m)}q=l;if(!q.length)break a}(0,R[b].F)(V,q)}}Ta();Y(W,!0);do d=P,P=P.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(P!==d);P=P.replace(/<\\/i><i>/g,"");P=P.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");P=P.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Ua);d=Na?"r":"t";P="<"+d+">"+P+"</"+d+">";if(Ra!==a)throw"The parser has been reset during execution";1E4<M&&C.add("warn","Fixing cost limit exceeded",void 0);return P}
function Va(a){var b={},d;for(d in T[a])b[d]=T[a][d];return T[a]=b}function Ua(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function Wa(a){Na=!0;var b=a.name,d=a.k,g=a.l,q=0,h=!1;a.o&1||(h=!0);Y(d,h);h=g?Fa(V.substr(d,g)):"";if(a.o&1){P+="<"+b;var l=Ka(a),n=[],k;for(k in l)n.push(k);n.sort(function(m,x){return m>x?1:-1});n.forEach(function(m){P+=" "+m+\'="\'+Ea(l[m].toString()).replace(/\\n/g,"&#10;")+\'"\'});P=3===a.o?g?P+(">"+h+"</"+b+">"):P+"/>":g?P+("><s>"+h+"</s>"):P+">"}else g&&(P+="<e>"+h+"</e>"),P+="</"+b+">";for(X=S=d+g;q&&X<W&&"\\n"===V[X];)--q,++X}
function Y(a,b){var d=0;b&&(L.flags&8?d=-1:b=!1);S>=a&&b&&Xa();if(X>S){var g=Math.min(a,X);P+=V.substr(S,g-S);S=g;S>=a&&b&&Xa()}var q=a;for(g=0;d&&--q>=S;){var h=V[q];if(" "!==h&&"\\n"!==h&&"\\t"!==h)break;"\\n"===h&&--d;++g}a-=g;a>S&&(d=Fa(V.substr(S,a-S)),P+=d);b&&Xa();g&&(P+=V.substr(a,g));S=a+g}function Ya(a){var b=a.k;a=a.l;var d=V.substr(b,a);Y(b,!1);P+="<i>"+Fa(d)+"</i>";Na=!0;S=b+a}function Xa(){L.z&&(P+="</p>",L.z=!1)}
function Ta(){if(U.length){for(var a in T)K[a]=0,Ma[a]=0;do{for(;U.length;)Qa||Za(),N=U.pop(),$a();O.forEach(function(b){var d=Q(2,b.name,W,0,0);Ia(d,b)})}while(U.length)}}
function $a(){L.flags&64&&!La(N,O[O.length-1])&&!(-1<"br i pb v".indexOf(N.name))&&D(N);var a=N.k,b=N.l;if(S>a&&!N.n){var d;if((d=N.r)&&0<=O.indexOf(d)){Ia(Q(2,d.name,S,Math.max(0,a+b-S),0),d);return}if("i"===N.name&&(a=a+b-S,0<a)){b=S;Q(3,"i",b,Math.min(a,W-b),0);return}D(N)}if(!N.n)if("i"===N.name)Ya(N);else if("br"===N.name)L.flags&1024||(Y(N.k,!1),P+="<br/>");else if("pb"===N.name)Y(N.k,!0);else if("v"===N.name)a=L.flags,L.flags=N.flags,Y(N.k+N.l,!1),L.flags=a;else if(N.o&1)if(a=N,b=a.name,d=
T[b],Ma[b]>=d.g)C.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:d.g}),D(a);else{var g=a,q=T[g.name];C.l=g;for(var h=0;h<q.d.length&&!g.n;++h)q.d[h](g,q);delete C.l;a.n||(K[b]>=d.f?(C.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:d.f}),D(a)):(d=T[b].h,L.e[d>>3]&1<<(d&7)?(!(a.flags&1&&3!==a.o)||a.u||U.length&&La(U[U.length-1],a)||(b=new J(3,b,a.k,a.l),E(b,Ka(a)),b.flags=a.flags,a=b),Wa(a),ab(a)):(b={tag:a,tagName:b},0<a.l?C.add("warn","Tag is not allowed in this context",
b):Ha("Tag is not allowed in this context",b),D(a))))}else bb()}
function bb(){var a=N;if(K[a.name]){for(var b=[],d=O.length;0<=--d;){var g=O[d];if(La(a,g))break;b.push(g);++M}if(0>d)Ha("Skipping end tag with no start tag",{tag:a});else{b.forEach(function(){});var q=0,h=[];b.forEach(function(k){var m=k.name;q&&(k.flags&2?h.push(k):q=!1);m=new J(2,m,a.k,0);m.flags=k.flags;Wa(m);cb()});Wa(a);cb();if(b.length&&1E4>M){g=S;for(d=U.length;0<=--d&&1E4>++M;){var l=U[d];if(l.k>g||l.o&1)break;for(var n=b.length;0<=--n&&1E4>++M;)if(La(l,b[n])){b.splice(n,1);h[n]&&h.splice(n,
1);g=Math.max(g,l.k+l.l);break}}g>S&&Ya(new J(3,"i",S,g-S))}h.forEach(function(k){var m=Q(k.o,k.name,S,0,k.w);E(m,Ka(k));(k=k.u)&&Ia(m,k)})}}}function cb(){var a=O.pop();--K[a.name];L=L.D}function ab(a){var b=a.name,d=a.flags,g=T[b];++Ma[b];if(3!==a.o){var q=[];L.e.forEach(function(l,n){d&512||(l=l&65280|l>>8);q.push(g.e[n]&l)});var h=d|L.flags&32;h&16&&(h&=-33);++K[b];O.push(a);L={D:L};L.e=q;L.flags=h}}
function Q(a,b,d,g,q){a=new J(a,b,d,g,q||0);T[b]&&(a.flags=T[b].j.flags);if(!(T[b]||-1<"br i pb v".indexOf(a.name))||0>g||0>d||d+g>W||/[\\uDC00-\\uDFFF]/.test(V.substr(d,1)+V.substr(d+g,1)))D(a);else if(T[b]&&T[b].v)C.add("warn","Tag is disabled",{tag:a,tagName:b}),D(a);else if(Qa){b=U.length;for(d=db(a);0<b&&d>db(U[b-1]);)U[b]=U[b-1],--b;U[b]=a}else U.push(a);return a}
function Za(){for(var a={},b=[],d=U.length;0<=--d;){var g=U[d],q=db(g,d);b.push(q);a[q]=g}b.sort();d=b.length;for(U=[];0<=--d;)U.push(a[b[d]]);Qa=!0}function db(a,b){var d=0<=a.w,g=a.w;d||(g+=1073741824);var q=0<a.l,h;q?h=W-a.l:h={2:0,3:1,1:2}[a.o];return eb(a.k)+ +d+eb(g)+ +q+eb(h)+eb(b||0)}function eb(a){a=a.toString(16);return"        ".substr(a.length)+a}var fb="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function gb(a){if(fb){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function hb(a,b){if(fb){var d=b.createElement("div");b=b.createDocumentFragment();Z.input=gb(a);Z.transform();for(d.innerHTML=Z.output;d.firstChild;)b.appendChild(d.firstChild);return b}return Z.transformToFragment(gb(a),b)}var Z,ib=gb(Da);
if(fb){var jb=new ActiveXObject("MSXML2.XSLTemplate.6.0");jb.stylesheet=ib;Z=jb.createProcessor()}else Z=new XSLTProcessor,Z.importStylesheet(ib);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){R[a]&&(R[a].v=!0)},disableTag:function(a){T[a]&&(Va(a).v=!0)},enablePlugin:function(a){R[a]&&(R[a].v=!1)},enableTag:function(a){T[a]&&(Va(a).v=!1)},getLogger:function(){return C},parse:Sa,preview:function(a,b){function d(l,n){var k=l.childNodes;n=n.childNodes;for(var m=k.length,x=n.length,A,I,y=0,F=0;y<m&&y<x;){A=k[y];I=n[y];if(!g(A,I))break;++y}for(var kb=Math.min(m-y,x-y);F<kb;){A=k[m-(F+1)];I=n[x-(F+1)];if(!g(A,I))break;++F}for(m-=F;--m>=y;)l.removeChild(k[m]),
h=l;k=x-F;if(!(y>=k)){x=q.createDocumentFragment();m=y;do I=n[m],h=x.appendChild(I);while(m<--k);F?l.insertBefore(x,l.childNodes[y]):l.appendChild(x)}}function g(l,n){if(l.nodeName!==n.nodeName||l.nodeType!==n.nodeType)return!1;if(l instanceof HTMLElement&&n instanceof HTMLElement){if(!l.isEqualNode(n)){for(var k=l.attributes,m=n.attributes,x=m.length,A=k.length,I=" "+l.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--A;){var y=k[A],F=y.namespaceURI;y=y.name;-1<I.indexOf(" "+y+" ")||n.hasAttributeNS(F,
y)||(l.removeAttributeNS(F,y),h=l)}for(A=x;0<=--A;)k=m[A],F=k.namespaceURI,y=k.name,k=k.value,-1<I.indexOf(" "+y+" ")||k===l.getAttributeNS(F,y)||(l.setAttributeNS(F,y,k),h=l);d(l,n)}}else 3!==l.nodeType&&8!==l.nodeType||l.nodeValue===n.nodeValue||(l.nodeValue=n.nodeValue,h=l);return!0}var q=b.ownerDocument;if(!q)throw"Target does not have a ownerDocument";a=hb(Sa(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),q);var h=b;"undefined"!==typeof window&&"chrome"in window&&a.querySelectorAll("script").forEach(function(l){var n=
document.createElement("script");var k=l.attributes;var m="undefined"!=typeof Symbol&&Symbol.iterator&&k[Symbol.iterator];k=m?m.call(k):{next:aa(k)};for(m=k.next();!m.done;m=k.next())m=m.value,n.setAttribute(m.name,m.value);n.textContent=l.textContent;l.parentNode.replaceChild(n,l)});d(b,a);return h},registeredVars:Oa,setNestingLimit:function(a,b){T[a]&&(Va(a).f=b)},setParameter:function(a,b){fb?Z.addParameter(a,b,""):Z.setParameter(null,a,b)},setTagLimit:function(a,b){T[a]&&(Va(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:169:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"amazon.ca";s:6:"amazon";s:12:"amazon.co.uk";s:6:"amazon";s:12:"amazon.co.jp";s:6:"amazon";s:10:"amazon.com";s:6:"amazon";s:9:"amazon.de";s:6:"amazon";s:9:"amazon.es";s:6:"amazon";s:9:"amazon.fr";s:6:"amazon";s:9:"amazon.in";s:6:"amazon";s:9:"amazon.it";s:6:"amazon";s:9:"anchor.fm";s:6:"anchor";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:12:"bandcamp.com";s:8:"bandcamp";s:9:"bbc.co.uk";s:7:"bbcnews";s:7:"bbc.com";s:7:"bbcnews";s:12:"bitchute.com";s:8:"bitchute";s:18:"bleacherreport.com";s:14:"bleacherreport";s:9:"break.com";s:5:"break";s:19:"link.brightcove.com";s:10:"brightcove";s:22:"players.brightcove.net";s:10:"brightcove";s:10:"castos.com";s:6:"castos";s:11:"cbsnews.com";s:7:"cbsnews";s:7:"clyp.it";s:4:"clyp";s:8:"cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:10:"codepen.io";s:7:"codepen";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:11:"falstad.com";s:7:"falstad";s:7:"flic.kr";s:6:"flickr";s:10:"flickr.com";s:6:"flickr";s:17:"video.foxnews.com";s:7:"foxnews";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:16:"gametrailers.com";s:12:"gametrailers";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:10:"gfycat.com";s:6:"gfycat";s:8:"gifs.com";s:4:"gifs";s:9:"giphy.com";s:5:"giphy";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:12:"jsfiddle.net";s:8:"jsfiddle";s:14:"jwplatform.com";s:10:"jwplatform";s:11:"kaltura.com";s:7:"kaltura";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:10:"libsyn.com";s:6:"libsyn";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:10:"medium.com";s:6:"medium";s:12:"megaphone.fm";s:9:"megaphone";s:14:"megaphone.link";s:9:"megaphone";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:9:"mixer.com";s:5:"mixer";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:13:"nbcsports.com";s:9:"nbcsports";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"orfium.com";s:6:"orfium";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:10:"rumble.com";s:6:"rumble";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:11:"sendvid.com";s:7:"sendvid";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:11:"sporcle.com";s:7:"sporcle";s:12:"sportsnet.ca";s:9:"sportsnet";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:12:"spreaker.com";s:8:"spreaker";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"stitcher.com";s:8:"stitcher";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"streamja.com";s:8:"streamja";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:4:"t.me";s:8:"telegram";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:10:"tiktok.com";s:6:"tiktok";s:7:"tmz.com";s:3:"tmz";s:15:"tradingview.com";s:11:"tradingview";s:17:"traileraddict.com";s:13:"traileraddict";s:16:"trendingviews.co";s:13:"trendingviews";s:10:"tumblr.com";s:6:"tumblr";s:13:"247sports.com";s:21:"twentyfoursevensports";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:18:"videodetective.com";s:14:"videodetective";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:7:"voca.ro";s:7:"vocaroo";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:10:"wistia.com";s:6:"wistia";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:12:"gameclips.io";s:9:"xboxclips";s:13:"xboxclips.com";s:9:"xboxclips";s:12:"gamerdvr.com";s:7:"xboxdvr";s:11:"xboxdvr.com";s:7:"xboxdvr";s:9:"youku.com";s:5:"youku";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:129:{s:7:"abcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:68:"!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}}i:1;a:0:{}}s:6:"amazon";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:1;R:186;}i:1;a:2:{i:0;s:50:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|in|it|jp|uk)#";i:1;a:2:{i:0;s:0:"";i:1;s:3:"tld";}}}i:1;R:189;}s:6:"anchor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"@anchor.fm/[-\\w]+/episodes/(?:[-\\w]+-)(?\'id\'\\w+)(?![-\\w])@";i:1;R:186;}}i:1;R:189;}s:9:"audioboom";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:9:"audiomack";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:71:"!audiomack\\.com/(?\'mode\'album|song)/(?\'artist\'[-\\w]+)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:6:"artist";i:3;s:5:"title";}}i:1;a:2:{i:0;s:71:"!audiomack\\.com/(?\'artist\'[-\\w]+)/(?\'mode\'album|song)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:6:"artist";i:2;s:4:"mode";i:3;s:5:"title";}}}i:1;R:189;}s:8:"bandcamp";a:2:{i:0;R:189;i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:229;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:235;}}}}}s:7:"bbcnews";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:67:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/(?:\\w+-)+(?\'id\'\\d+)@";i:1;R:186;}i:1;a:2:{i:0;s:68:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/embed/(?\'id\'\\w+/\\d+)@";i:1;R:186;}i:2;a:2:{i:0;s:62:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/\\w+/(?\'id\'\\d+)@";i:1;R:186;}}i:1;R:189;}s:8:"bitchute";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"@bitchute\\.com/(?:embed|video)/(?\'id\'[-\\w]+)@";i:1;R:186;}}i:1;R:189;}s:14:"bleacherreport";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!id="video-(?\'id\'[-\\w]+)!";i:1;R:186;}i:1;a:2:{i:0;s:31:"!video_embed\\?id=(?\'id\'[-\\w]+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!/articles/.!";i:1;R:235;}}}}}s:5:"break";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!break\\.com/video/.*-(?\'id\'\\d+)$!";i:1;R:186;}}i:1;R:189;}s:10:"brightcove";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:107:"@link\\.brightcove\\.com/services/player/bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bckey";i:3;s:5:"bctid";}}i:1;a:2:{i:0;s:65:"@players\\.brightcove\\.net/(?\'bcpid\'\\d+)/.*?videoId=(?\'bctid\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}i:1;R:189;}s:6:"castos";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:48:"@(?\'host\'[-\\w]+)\\.castos\\.com/player/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"host";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:297;s:5:"match";a:1:{i:0;a:2:{i:0;s:45:"@castos\\.com/(?:podcasts/[^/]*+/)?episodes/.@";i:1;R:235;}}}}}s:7:"cbsnews";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"#cbsnews\\.com/videos?/(?!watch/)(?\'id\'[-\\w]+)#";i:1;R:186;}i:1;a:2:{i:0;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:1;R:186;}}i:1;R:189;}s:4:"clyp";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"@clyp\\.it/(?!user/)(?\'id\'\\w+)@";i:1;R:186;}}i:1;R:189;}s:4:"cnbc";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!byGuid=(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"!cnbc\\.com/video/20\\d\\d/\\d\\d/\\d\\d/\\w!";i:1;R:235;}}}}}s:3:"cnn";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;R:186;}i:1;a:2:{i:0;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:1;R:186;}}i:1;R:189;}s:8:"cnnmoney";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:1;R:186;}}i:1;R:189;}s:7:"codepen";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:72:"!codepen\\.io/(?\'user\'[-\\w]+)/(?:details|embed|full|live|pen)/(?\'id\'\\w+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}}i:1;R:189;}s:13:"comedycentral";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;R:235;}}}}}s:4:"coub";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:1;R:186;}}i:1;R:189;}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;R:186;}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:186;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:189;}s:12:"democracynow";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;R:235;}}}}}s:7:"dumpert";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!dumpert\\.nl/(?:item|mediabase)/(?\'id\'\\d+[/_]\\w+)!";i:1;R:186;}}i:1;R:189;}s:11:"eighttracks";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!8tracks\\.com/[-\\w]+/\\D!";i:1;R:235;}}}}}s:4:"espn";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:1;R:186;}}i:1;R:189;}s:8:"facebook";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:186;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:417;}}i:1;R:189;}s:7:"falstad";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:81:"!falstad\\.com/circuit/circuitjs\\.html\\?c(?:ct=(?\'cct\'[^&]+)|tz=(?\'ctz\'[-+=\\w]+))!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"cct";i:2;s:3:"ctz";}}}i:1;R:189;}s:6:"flickr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"@flickr\\.com/photos/[^/]+/(?\'id\'\\d+)@";i:1;R:186;}i:1;a:2:{i:0;s:33:"@flic\\.kr/(?!p/)[^/]+/(?\'id\'\\d+)@";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;R:432;}s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"@flic\\.kr/p/(?\'short\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:5:"short";}}}s:3:"url";s:52:"https://www.flickr.com/photo.gne?rb=1&short={@short}";}}}s:7:"foxnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:10:"funnyordie";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:1;R:186;}}i:1;R:189;}s:8:"gamespot";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:1;R:186;}}i:1;R:189;}s:12:"gametrailers";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:18:"!embed/(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:51:"!gametrailers\\.com/(?:full-episode|review|video)s/!";i:1;R:235;}}}}}s:5:"getty";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:20:"!gty\\.im/(?\'id\'\\d+)!";i:1;R:186;}i:1;a:2:{i:0;s:47:"!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!";i:1;R:186;}i:2;a:2:{i:0;s:30:"!#[-\\w]*picture-id(?\'id\'\\d+)$!";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:4:{i:0;a:2:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"height";}}i:1;a:2:{i:0;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"width";}}i:2;a:2:{i:0;s:29:"!\\bid[=:][\'"]?(?\'et\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"et";}}i:3;a:2:{i:0;s:31:"!\\bsig[=:][\'"]?(?\'sig\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"sig";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:2:"//";i:1;R:235;}}s:3:"url";s:43:"https://embed.gettyimages.com/preview/{@id}";}}}s:6:"gfycat";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?(?\'id\'\\w+)#";i:1;R:186;}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:17:"!/ifr/(?\'id\'\\w+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:87:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?[a-z]#";i:1;R:235;}}s:3:"url";s:28:"https://gfycat.com/ifr/{@id}";}i:1;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!"height":(?\'height\'\\d+)!";i:1;R:480;}i:1;a:2:{i:0;s:23:"!"width":(?\'width\'\\d+)!";i:1;R:485;}}s:5:"match";R:498;s:3:"url";s:61:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}";}}}s:4:"gifs";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;R:485;}i:1;a:2:{i:0;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";i:1;R:480;}}s:5:"match";R:498;s:3:"url";s:26:"https://gifs.com/gif/{@id}";}}}s:5:"giphy";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:62:"!giphy\\.com/(?\'type\'gif|video|webp)\\w+/(?:[-\\w]+-)*(?\'id\'\\w+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}i:1;a:2:{i:0;s:52:"!giphy\\.com/media/(?\'id\'\\w+)/\\w+\\.(?\'type\'gif|webp)!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"type";}}i:2;a:2:{i:0;s:45:"!i\\.giphy\\.com/(?\'id\'\\w+)\\.(?\'type\'gif|webp)!";i:1;R:544;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!"height"\\s*:\\s*(?\'height\'\\d+)!";i:1;R:480;}i:1;a:2:{i:0;s:29:"!"width"\\s*:\\s*(?\'width\'\\d+)!";i:1;R:485;}}s:5:"match";R:498;s:3:"url";s:83:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif";}}}s:4:"gist";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"!gist\\.github\\.com/(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)!";i:1;R:186;}}i:1;R:189;}s:10:"globalnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:563;s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!globalnews\\.ca/video/rd/!";i:1;R:235;}}}}}s:8:"gofundme";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:1;R:186;}}i:1;R:189;}s:11:"googledrive";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!";i:1;R:186;}}i:1;R:189;}s:10:"googleplus";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}i:1;R:189;}s:12:"googlesheets";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:76:"@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|(?:[^e]/)+)(?\'id\'(?:e/)?[-\\w]+)@";i:1;R:186;}i:1;a:2:{i:0;s:17:"@oid=(?\'oid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"oid";}}i:2;a:2:{i:0;s:18:"@#gid=(?\'gid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"gid";}}i:3;a:2:{i:0;s:20:"@/pub(?\'type\'chart)@";i:1;R:417;}}i:1;R:189;}s:4:"hudl";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:2:{i:0;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:1;R:608;}i:2;a:2:{i:0;s:37:"@hudl\\.com/video/(?\'id\'\\w+)(?![\\w/])@";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;R:612;i:1;R:614;}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!hudl\\.com/v/!";i:1;R:235;}}}}}s:4:"hulu";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!eid=(?\'id\'[-\\w]+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:18:"!hulu\\.com/watch/!";i:1;R:235;}}}}}s:3:"ign";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:40:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!i";i:1;R:186;}}i:1;R:189;}s:4:"imdb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!imdb\\.com/[/\\w]+/vi(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:5:"imgur";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:25:"@imgur\\.com/(?\'id\'a/\\w+)@";i:1;R:186;}i:1;a:2:{i:0;s:38:"@i\\.imgur\\.com/(?\'id\'\\w{5,7})[lms]?\\.@";i:1;R:186;}i:2;a:2:{i:0;s:33:"@imgur\\.com/(?\'id\'\\w+)(?![\\w./])@";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"@data-id="(?\'id\'[\\w/]+)"@";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:63:"@imgur\\.com/(?![art]/|user/)(?\'path\'(?:gallery/)?\\w+)(?![\\w.])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:3:"url";s:45:"https://api.imgur.com/oembed.xml?url=/{@path}";}}}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:186;}}i:1;R:189;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!instagram\\.com/(?:p|tv)/(?\'id\'[-\\w]+)!";i:1;R:186;}}i:1;R:189;}s:15:"internetarchive";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;R:186;}i:1;a:2:{i:0;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:1;R:485;}i:2;a:2:{i:0;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";i:1;R:480;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!archive\\.org/(?:details|embed)/!";i:1;R:235;}}}}}s:8:"izlesene";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:8:"jsfiddle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:96:"@jsfiddle.net/(?:(?\'user\'\\w+)/)?(?!\\d+\\b|embedded\\b|show\\b)(?\'id\'\\w+)\\b(?:/(?\'revision\'\\d+)\\b)?@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";i:3;s:8:"revision";}}}i:1;R:189;}s:10:"jwplatform";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:1;R:186;}}i:1;R:189;}s:7:"kaltura";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:38:"@/p(?:artner_id)?/(?\'partner_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"partner_id";}}i:1;a:2:{i:0;s:17:"@/sp/(?\'sp\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:2:"sp";}}i:2;a:2:{i:0;s:31:"@/uiconf_id/(?\'uiconf_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:9:"uiconf_id";}}i:3;a:2:{i:0;s:32:"@\\bentry_id[=/](?\'entry_id\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:8:"entry_id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:113:"@kaltura\\.com/+p/(?\'partner_id\'\\d+)/sp/(?\'sp\'\\d+)/\\w*/uiconf_id/(?\'uiconf_id\'\\d+)/.*?\\bentry_id=(?\'entry_id\'\\w+)@";i:1;a:5:{i:0;s:0:"";i:1;s:10:"partner_id";i:2;s:2:"sp";i:3;s:9:"uiconf_id";i:4;s:8:"entry_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"@kaltura\\.com/(?:media/t|tiny)/.@";i:1;R:235;}}}}}s:3:"khl";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;R:235;}}}}}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:189;}s:6:"libsyn";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;R:235;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:235;}}}}}s:10:"livestream";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:2:{i:0;s:26:"!/videos/(?\'video_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:2:{i:0;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;R:776;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@livestream\\.com/(?!accounts/\\d+/events/\\d)@";i:1;R:235;}}}i:1;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:1;R:787;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!livestre.am!";i:1;R:235;}}}}}s:6:"mailru";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!"itemId": ?"?(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;R:235;}}}}}s:6:"medium";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"!medium\\.com/(?:s/\\w+/|@?\\w+/)?(?:\\w+-)*(?\'id\'[0-9a-f]+)!";i:1;R:186;}}i:1;R:189;}s:9:"megaphone";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:46:"@megaphone\\.fm/.*?\\?(?:e|selected)=(?\'id\'\\w+)@";i:1;R:186;}i:1;a:2:{i:0;s:50:"@(?:dcs|player|traffic)\\.megaphone\\.fm/(?\'id\'\\w+)@";i:1;R:186;}i:2;a:2:{i:0;s:28:"@megaphone\\.link/(?\'id\'\\w+)@";i:1;R:186;}}i:1;R:189;}s:8:"metacafe";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:8:"mixcloud";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:1;R:186;}}i:1;R:189;}s:5:"mixer";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#mixer.com/(?!browse/)(?\'channel\'\\w+)(?!\\?clip|\\w)(?:\\?vod=(?\'vod\'[-\\w]+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:3:"vod";}}}i:1;R:189;}s:3:"mlb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"#mlb\\.com/video/(?:[-\\w/]+/)?(?:c-|v|[-\\w]+-c)(?\'id\'\\d+)#";i:1;R:186;}}i:1;R:189;}s:5:"mrctv";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;R:235;}}}}}s:5:"msnbc";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:40:"@embedded-video/(?!undefined)(?\'id\'\\w+)@";i:1;R:186;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;R:235;}i:1;a:2:{i:0;s:18:"@on\\.msnbc\\.com/.@";i:1;R:235;}}}}}s:13:"natgeochannel";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:1;R:186;}}i:1;R:189;}s:11:"natgeovideo";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;R:235;}}}}}s:7:"nbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:9:"nbcsports";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!select/media/(?\'id\'\\w+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!nbcsports\\.com/video/.!";i:1;R:235;}}}}}s:3:"nhl";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}}i:1;R:189;}s:3:"npr";a:2:{i:0;R:189;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:1:"i";i:2;s:1:"m";}}}s:6:"header";s:45:"Cookie: trackingChoice=false; choiceVersion=1";s:5:"match";a:2:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;R:235;}i:1;a:2:{i:0;s:10:"!n\\.pr/\\w!";i:1;R:235;}}}}}s:7:"nytimes";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;R:186;}i:1;a:2:{i:0;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:26:"!/video/movies/(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"playlist";}}}s:3:"url";s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}}s:6:"orfium";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:24:"@album/(?\'album_id\'\\d+)@";i:1;R:229;}i:1;a:2:{i:0;s:30:"@playlist/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:25:"@live-set/(?\'set_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:6:"set_id";}}i:3;a:2:{i:0;s:24:"@track/(?\'track_id\'\\d+)@";i:1;R:248;}}i:1;R:189;}s:8:"pastebin";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:1;R:186;}}i:1;R:189;}s:9:"pinterest";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:1;R:186;}i:1;a:2:{i:0;s:84:"@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@";i:1;R:186;}}i:1;R:189;}s:7:"podbean";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!podbean\\.com/media/(?:player/|share/pb-)(?\'id\'[-\\w]+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:41:"!podbean\\.com/media/player/(?\'id\'[-\\w]+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"@podbean\\.com/(?:media/shar)?e/(?!pb-)@";i:1;R:235;}}}}}s:5:"prezi";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:1;R:186;}}i:1;R:189;}s:6:"reddit";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!(?\'id\'\\w+/comments/\\w+(?:/\\w+/\\w+)?)!";i:1;R:186;}}i:1;R:189;}s:6:"rumble";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rumble\\.com/embed/(?\'id\'\\w+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:21:"!video"?:"(?\'id\'\\w+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"#rumble\\.com/(?!embed/).#";i:1;R:235;}}}}}s:6:"rutube";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rutube\\.ru/tracks/(?\'id\'\\d+)!";i:1;R:186;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!rutube\\.ru/play/embed/(?\'id\'\\d+)!";i:1;R:186;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"!rutube\\.ru/video/(?\'vid\'[0-9a-f]{32})!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}s:3:"url";s:64:"http://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/";}}}s:6:"scribd";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:67:"!scribd\\.com/(?:mobile/)?(?:doc(?:ument)?|presentation)/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:7:"sendvid";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!sendvid\\.com/(?\'id\'\\w+)!";i:1;R:186;}}i:1;R:189;}s:10:"slideshare";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!"presentationId":(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@slideshare\\.net/[^/]+/\\w(?![-\\w]+-\\d{6,}$)@";i:1;R:235;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:186;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;R:941;}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:248;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:235;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:941;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;R:235;}}}}}s:7:"sporcle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"#sporcle.com/framed/.*?gid=(?\'id\'\\w+)#";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"#encodedGameID\\W+(?\'id\'\\w+)#";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"#sporcle\\.com/games/(?!\\w*category/)[-\\w]+/[-\\w]#";i:1;R:235;}}}}}s:9:"sportsnet";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"/vid(?:eoId)?=(?\'id\'\\d+)/";i:1;R:186;}i:1;a:2:{i:0;s:46:"/param name="@videoPlayer" value="(?\'id\'\\d+)"/";i:1;R:186;}}s:5:"match";R:498;}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?:user/[-.\\w]+/)?(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1085;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!link\\.tospotify\\.com/.!";i:1;R:235;}}}}}s:8:"spreaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!spreaker\\.com/episode/(?\'episode_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:10:"episode_id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!episode_id=(?\'episode_id\'\\d+)!";i:1;R:1098;}i:1;a:2:{i:0;s:25:"!show_id=(?\'show_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:7:"show_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!(?\'url\'.+/(?:show/|user/.+/).+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"url";}}}s:3:"url";s:54:"https://api.spreaker.com/oembed?format=json&url={@url}";}}}s:10:"steamstore";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:8:"stitcher";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!/(?:embed|splayer/f)/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"fid";i:2;s:3:"eid";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:32:"!/embed/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;R:1126;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!/(?:podcast/|show/|s\\?)!";i:1;R:235;}}}}}s:9:"strawpoll";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:10:"streamable";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"!streamable\\.com/(?\'id\'\\w+)!";i:1;R:186;}}i:1;R:189;}s:8:"streamja";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@streamja\\.com/(?!login|signup|terms|videos)(?\'id\'\\w+)@";i:1;R:186;}}i:1;R:189;}s:8:"teamcoco";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:20:"!embed/v/(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!teamcoco\\.com/video/\\D!";i:1;R:235;}}}}}s:3:"ted";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:1;R:186;}}i:1;R:189;}s:8:"telegram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"@//t.me/(?!addstickers/|joinchat/)(?\'id\'\\w+/\\d+)@";i:1;R:186;}}i:1;R:189;}s:11:"theatlantic";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:11:"theguardian";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!theguardian\\.com/(?\'id\'\\w+/video/20(?:0[0-9]|1[0-7])[-/\\w]+)!";i:1;R:186;}}i:1;R:189;}s:8:"theonion";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:6:"tiktok";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:61:"#tiktok\\.com/(?:@[.\\w]+/video|v|i18n/share/video)/(?\'id\'\\d+)#";i:1;R:186;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:38:"#tiktok\\.com/@[.\\w]+/video/(?\'id\'\\d+)#";i:1;R:186;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"#//vm\\.tiktok\\.com/.#";i:1;R:235;}}}}}s:3:"tmz";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:1;R:186;}}i:1;R:189;}s:11:"tradingview";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!tradingview\\.com/(?:chart/[^/]+|i)/(?\'chart\'\\w+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"chart";}}i:1;a:2:{i:0;s:45:"!tradingview\\.com/symbols/(?\'symbol\'[-:\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"symbol";}}}i:1;R:189;}s:13:"traileraddict";a:2:{i:0;R:189;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;R:235;}}}}}s:13:"trendingviews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:56:"!trendingviews.co/(?:video|embed)/(?:[^/]+-)?(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:6:"tumblr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:27:"!did=\\\\u0022(?\'did\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"did";}}i:1;a:2:{i:0;s:31:"!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"key";}}}s:6:"header";s:16:"User-agent: curl";s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;R:235;}}s:3:"url";s:75:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}";}}}s:21:"twentyfoursevensports";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!247sports\\.com/PlayerSport/[-\\w]*?(?\'player_id\'\\d+)/Embed!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"player_id";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";R:1251;s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!247sports\\.com/Player/[-\\w]*?\\d!";i:1;R:235;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:33:"!player_id%3[Dd](?\'video_id\'\\d+)!";i:1;R:782;}}s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!247sports\\.com/Video/.!";i:1;R:235;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;R:782;}i:1;a:2:{i:0;s:70:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'\\w+))?#";i:1;R:787;}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:370;}i:3;a:2:{i:0;s:56:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'\\w+)#";i:1;R:787;}}i:1;R:189;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@twitter\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:186;}}i:1;R:189;}s:7:"ustream";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:1;R:1006;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!embed/(?\'cid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"cid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;R:235;}}}}}s:5:"vbox7";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:1;R:186;}}i:1;R:189;}s:4:"veoh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:1;R:186;}}i:1;R:189;}s:4:"vevo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!vevo\\.com/watch/(.*?/)?(?\'id\'[A-Z]+\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}}i:1;R:189;}s:14:"videodetective";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:1;R:186;}}i:1;R:189;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:186;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:370;}}i:1;R:189;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:186;}}i:1;R:189;}s:2:"vk";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:97:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}i:1;a:2:{i:0;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:1;R:1334;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:99:"#meta property="og:video" content=".*?oid=(?\'oid\'-?\\d+).*?id=(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)#";i:1;R:1334;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:15:"#^(?!.*?hash=)#";i:1;R:235;}}}}}s:7:"vocaroo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!voca(?:\\.ro|roo\\.com)/(?:i/)?(?\'id\'\\w+)!";i:1;R:186;}}i:1;R:189;}s:3:"vox";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:1;R:186;}}i:1;R:189;}s:14:"washingtonpost";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:1;R:186;}i:1;a:2:{i:0;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:1;R:186;}}i:1;R:189;}s:6:"wistia";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!wistia.com/medias/(?\'id\'\\w+)!";i:1;R:186;}}i:1;R:189;}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:18:"!v: ?"?(?\'id\'\\d+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:235;}}}}}s:3:"wsj";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;R:186;}i:1;a:2:{i:0;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:1;R:186;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;R:235;}}}}}s:9:"xboxclips";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"@(?:gameclips\\.io|xboxclips\\.com)/(?!game/)(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:1;R:345;}}i:1;R:189;}s:7:"xboxdvr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!(?:gamer|xbox)dvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:1;R:345;}}i:1;R:189;}s:5:"youku";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+=*)!";i:1;R:186;}}i:1;R:189;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:69:"!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:186;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:186;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:370;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!/vi/(?\'id\'[-\\w]+)!";i:1;R:186;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!/shared\\?ci=!";i:1;R:235;}}}}}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:1:{i:0;i:771;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:130:{s:7:"ABCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:189;}}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:1:{i:0;i:256;}}s:6:"AMAZON";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:8:"required";b:1;s:11:"filterChain";R:189;}s:3:"tld";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"ANCHOR";R:1432;s:9:"AUDIOBOOM";R:1432;s:9:"AUDIOMACK";a:7:{s:10:"attributes";a:3:{s:6:"artist";R:1434;s:4:"mode";R:1434;s:5:"title";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1434;s:8:"track_id";R:1434;s:9:"track_num";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"BBCNEWS";R:1432;s:8:"BITCHUTE";R:1432;s:14:"BLEACHERREPORT";R:1432;s:5:"BREAK";R:1432;s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:3:{s:5:"bckey";R:1434;s:5:"bcpid";R:1434;s:5:"bctid";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"CASTOS";a:7:{s:10:"attributes";a:2:{s:4:"host";R:1434;s:2:"id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"CBSNEWS";R:1432;s:4:"CLYP";R:1432;s:4:"CNBC";R:1432;s:3:"CNN";R:1432;s:8:"CNNMONEY";R:1432;s:7:"CODEPEN";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1434;s:4:"user";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:13:"COMEDYCENTRAL";R:1432;s:4:"COUB";R:1432;s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1434;s:1:"t";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:12:"DEMOCRACYNOW";R:1432;s:7:"DUMPERT";R:1432;s:11:"EIGHTTRACKS";R:1432;s:4:"ESPN";R:1432;s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1434;s:4:"type";R:1434;s:4:"user";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"FALSTAD";a:7:{s:10:"attributes";a:2:{s:3:"cct";R:1434;s:3:"ctz";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"FLICKR";R:1432;s:7:"FOXNEWS";R:1432;s:10:"FUNNYORDIE";R:1432;s:8:"GAMESPOT";R:1432;s:12:"GAMETRAILERS";R:1432;s:5:"GETTY";a:7:{s:10:"attributes";a:5:{s:2:"et";R:1434;s:6:"height";a:3:{s:12:"defaultValue";i:360;s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}s:2:"id";R:1434;s:3:"sig";R:1434;s:5:"width";a:3:{s:12:"defaultValue";i:640;s:11:"filterChain";R:1502;s:8:"required";b:0;}}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"GFYCAT";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1500;s:2:"id";R:1434;s:5:"width";R:1508;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:4:"GIFS";R:1514;s:5:"GIPHY";a:7:{s:10:"attributes";a:4:{s:6:"height";R:1500;s:2:"id";R:1434;s:4:"type";R:1434;s:5:"width";R:1508;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:4:"GIST";R:1432;s:10:"GLOBALNEWS";R:1432;s:8:"GOFUNDME";R:1432;s:11:"GOOGLEDRIVE";R:1432;s:10:"GOOGLEPLUS";a:7:{s:10:"attributes";a:3:{s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";R:1505;}}s:8:"required";b:0;}s:3:"oid";R:1434;s:3:"pid";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:12:"GOOGLESHEETS";a:7:{s:10:"attributes";a:4:{s:3:"gid";R:1434;s:2:"id";R:1434;s:3:"oid";R:1434;s:4:"type";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:4:"HUDL";a:7:{s:10:"attributes";a:3:{s:7:"athlete";R:1434;s:9:"highlight";R:1434;s:2:"id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:4:"HULU";R:1432;s:3:"IGN";R:1432;s:4:"IMDB";R:1432;s:5:"IMGUR";R:1432;s:9:"INDIEGOGO";R:1432;s:9:"INSTAGRAM";R:1432;s:15:"INTERNETARCHIVE";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1500;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:23:"htmlspecialchars_decode";s:6:"params";R:1505;}}s:8:"required";b:0;}s:5:"width";R:1508;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:8:"IZLESENE";R:1432;s:8:"JSFIDDLE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1434;s:8:"revision";R:1434;s:4:"user";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:10:"JWPLATFORM";R:1432;s:7:"KALTURA";a:7:{s:10:"attributes";a:4:{s:8:"entry_id";R:1453;s:10:"partner_id";R:1453;s:2:"sp";R:1434;s:9:"uiconf_id";R:1453;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:3:"KHL";R:1432;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:1434;s:2:"id";R:1434;s:5:"video";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"LIBSYN";R:1432;s:8:"LIVELEAK";R:1432;s:10:"LIVESTREAM";a:7:{s:10:"attributes";a:5:{s:10:"account_id";R:1434;s:7:"channel";R:1434;s:7:"clip_id";R:1434;s:8:"event_id";R:1434;s:8:"video_id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"MAILRU";R:1432;s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:189;s:9:"bitNumber";i:0;s:7:"allowed";a:1:{i:0;i:770;}}s:6:"MEDIUM";R:1432;s:9:"MEGAPHONE";R:1432;s:8:"METACAFE";R:1432;s:8:"MIXCLOUD";R:1432;s:5:"MIXER";a:7:{s:10:"attributes";a:2:{s:7:"channel";R:1434;s:3:"vod";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:3:"MLB";R:1432;s:5:"MRCTV";R:1432;s:5:"MSNBC";R:1432;s:13:"NATGEOCHANNEL";R:1432;s:11:"NATGEOVIDEO";R:1432;s:7:"NBCNEWS";R:1432;s:9:"NBCSPORTS";R:1432;s:3:"NHL";a:7:{s:10:"attributes";a:2:{s:1:"c";R:1434;s:1:"t";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:3:"NPR";a:7:{s:10:"attributes";a:2:{s:1:"i";R:1434;s:1:"m";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"NYTIMES";R:1432;s:6:"ORFIUM";a:7:{s:10:"attributes";a:4:{s:8:"album_id";R:1434;s:11:"playlist_id";R:1434;s:6:"set_id";R:1434;s:8:"track_id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:8:"PASTEBIN";R:1432;s:9:"PINTEREST";R:1432;s:7:"PODBEAN";R:1432;s:5:"PREZI";R:1432;s:6:"REDDIT";R:1432;s:6:"RUMBLE";R:1432;s:6:"RUTUBE";R:1432;s:6:"SCRIBD";R:1432;s:7:"SENDVID";R:1432;s:10:"SLIDESHARE";R:1432;s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:1434;s:11:"playlist_id";R:1434;s:12:"secret_token";R:1434;s:8:"track_id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"SPORCLE";R:1432;s:9:"SPORTSNET";R:1432;s:7:"SPOTIFY";R:1432;s:8:"SPREAKER";a:7:{s:10:"attributes";a:2:{s:10:"episode_id";R:1434;s:7:"show_id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:10:"STEAMSTORE";R:1432;s:8:"STITCHER";a:7:{s:10:"attributes";a:2:{s:3:"eid";R:1434;s:3:"fid";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:9:"STRAWPOLL";R:1432;s:10:"STREAMABLE";R:1432;s:8:"STREAMJA";R:1432;s:8:"TEAMCOCO";R:1432;s:3:"TED";R:1432;s:8:"TELEGRAM";R:1432;s:11:"THEATLANTIC";R:1432;s:11:"THEGUARDIAN";R:1432;s:8:"THEONION";R:1432;s:6:"TIKTOK";R:1432;s:3:"TMZ";R:1432;s:11:"TRADINGVIEW";a:7:{s:10:"attributes";a:2:{s:5:"chart";R:1434;s:6:"symbol";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:13:"TRAILERADDICT";R:1432;s:13:"TRENDINGVIEWS";R:1432;s:6:"TUMBLR";a:7:{s:10:"attributes";a:4:{s:3:"did";R:1434;s:2:"id";R:1434;s:3:"key";R:1434;s:4:"name";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:21:"TWENTYFOURSEVENSPORTS";a:7:{s:10:"attributes";a:2:{s:9:"player_id";R:1434;s:8:"video_id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:1434;s:7:"clip_id";R:1434;s:1:"t";R:1434;s:8:"video_id";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"TWITTER";R:1432;s:7:"USTREAM";a:7:{s:10:"attributes";a:2:{s:3:"cid";R:1434;s:3:"vid";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:5:"VBOX7";R:1432;s:4:"VEOH";R:1432;s:4:"VEVO";R:1432;s:14:"VIDEODETECTIVE";R:1432;s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1434;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:1505;}}s:8:"required";b:0;}}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:4:"VINE";R:1432;s:2:"VK";a:7:{s:10:"attributes";a:3:{s:4:"hash";R:1434;s:3:"oid";R:1434;s:3:"vid";R:1434;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}s:7:"VOCAROO";R:1432;s:3:"VOX";R:1432;s:14:"WASHINGTONPOST";R:1432;s:6:"WISTIA";R:1432;s:4:"WSHH";R:1432;s:3:"WSJ";R:1432;s:9:"XBOXCLIPS";R:1478;s:7:"XBOXDVR";R:1478;s:5:"YOUKU";R:1432;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:4:"list";R:1434;s:1:"t";R:1653;}s:11:"filterChain";R:1436;s:12:"nestingLimit";i:10;s:5:"rules";R:1445;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1449;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:10:{s:20:"AMAZON_ASSOCIATE_TAG";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_CA";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_DE";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_ES";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_FR";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IN";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IT";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_JP";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_UK";s:0:"";s:16:"MEDIAEMBED_THEME";s:0:"";}}');
	}
}