<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2020 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles\MediaPack;

class Renderer extends \s9e\TextFormatter\Renderers\PHP
{
	protected $params=['AMAZON_ASSOCIATE_TAG'=>'','AMAZON_ASSOCIATE_TAG_CA'=>'','AMAZON_ASSOCIATE_TAG_DE'=>'','AMAZON_ASSOCIATE_TAG_ES'=>'','AMAZON_ASSOCIATE_TAG_FR'=>'','AMAZON_ASSOCIATE_TAG_IN'=>'','AMAZON_ASSOCIATE_TAG_IT'=>'','AMAZON_ASSOCIATE_TAG_JP'=>'','AMAZON_ASSOCIATE_TAG_UK'=>'','MEDIAEMBED_THEME'=>''];
	protected function renderNode(\DOMNode $node)
	{
		switch($node->nodeName){case'ABCNEWS':$this->out.='<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//abcnews.go.com/video/embed?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'AMAZON':$this->out.='<span data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://www.amazon.com/favicon.ico) center no-repeat;border:0;height:100%;left:0;position:absolute;width:100%" src="//ws-';if($node->getAttribute('tld')==='jp')$this->out.='fe';elseif($node->hasAttribute('tld')&&(strpos('desfrinituk',$node->getAttribute('tld'))!==false))$this->out.='eu';else$this->out.='na';$this->out.='.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=';switch($node->getAttribute('tld')){case'ca':$this->out.='15&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);break;case'de':$this->out.='3&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);break;case'es':$this->out.='30&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);break;case'fr':$this->out.='8&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);break;case'in':$this->out.='31&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IN'],2);break;case'it':$this->out.='29&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);break;case'jp':$this->out.='9&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);break;case'uk':$this->out.='2&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);break;default:$this->out.='1&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);}$this->out.='&amp;asins='.htmlspecialchars($node->getAttribute('id'),2).'"></iframe></span></span>';break;case'ANCHOR':$this->out.='<iframe data-s9e-mediaembed="anchor" allowfullscreen="" loading="lazy" scrolling="no" src="//anchor.fm/embed/episodes/x-'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:102px;max-width:700px;width:100%"></iframe>';break;case'AUDIOBOOM':$this->out.='<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" loading="lazy" scrolling="no" src="//audioboom.com/posts/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>';break;case'AUDIOMACK':$this->out.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" loading="lazy" scrolling="no"';if($node->getAttribute('mode')==='album'){$this->out.=' src="https://www.audiomack.com/embed/album/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.=htmlspecialchars($node->getAttribute('artist'),2).'/'.htmlspecialchars($node->getAttribute('title'),2);$this->out.='" style="border:0;height:400px;max-width:900px;width:100%"';}else{$this->out.=' src="https://www.audiomack.com/embed/song/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.=htmlspecialchars($node->getAttribute('artist'),2).'/'.htmlspecialchars($node->getAttribute('title'),2);$this->out.='" style="border:0;height:252px;max-width:900px;width:100%"';}$this->out.='></iframe>';break;case'BANDCAMP':$this->out.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if($node->hasAttribute('album_id')){$this->out.='album='.htmlspecialchars($node->getAttribute('album_id'),2);if($node->hasAttribute('track_num'))$this->out.='/t='.htmlspecialchars($node->getAttribute('track_num'),2);}else$this->out.='track='.htmlspecialchars($node->getAttribute('track_id'),2);if($this->params['MEDIAEMBED_THEME']==='dark')$this->out.='/bgcol=333333/linkcol=0f91ff';$this->out.='"></iframe></span></span>';break;case'BBCNEWS':$this->out.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com/news/av/video-';if((strpos($node->getAttribute('playlist'),'/news/')===0))$this->out.=htmlspecialchars(substr(strstr($node->getAttribute('playlist'),'/news/'),6),2);elseif((strpos($node->getAttribute('id'),'/')!==false))$this->out.=htmlspecialchars(substr(strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=htmlspecialchars($node->getAttribute('id'),2);$this->out.='/embed"></iframe></span></span>';break;case'BITCHUTE':$this->out.='<span data-s9e-mediaembed="bitchute" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.bitchute.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BLEACHERREPORT':$this->out.='<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//bleacherreport.com/video_embed?id='.htmlspecialchars($node->getAttribute('id'),2).'&amp;library=video-cms" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BREAK':$this->out.='<span data-s9e-mediaembed="break" style="display:inline-block;width:100%;max-width:464px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:60.344828%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//break.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BRIGHTCOVE':$this->out.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://';if($node->hasAttribute('bckey'))$this->out.='link.brightcove.com/services/player/bcpid'.htmlspecialchars($node->getAttribute('bcpid'),2).'?bckey='.htmlspecialchars($node->getAttribute('bckey'),2).'&amp;bctid='.htmlspecialchars($node->getAttribute('bctid'),2).'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640';else$this->out.='players.brightcove.net/'.htmlspecialchars($node->getAttribute('bcpid'),2).'/default_default/index.html?videoId='.htmlspecialchars($node->getAttribute('bctid'),2);$this->out.='"></iframe></span></span>';break;case'CASTOS':$this->out.='<iframe data-s9e-mediaembed="castos" allowfullscreen="" loading="lazy" scrolling="no" src="https://player.castos.com/player/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'CBSNEWS':$this->out.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($node->getAttribute('id'),'-')!==false))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbsnews.com/embed/videos/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';elseif($node->hasAttribute('pid'))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.htmlspecialchars($node->getAttribute('pid'),2).'"></object>';else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.htmlspecialchars($node->getAttribute('id'),2).'"></object>';$this->out.='</span></span>';break;case'CLYP':$this->out.='<iframe data-s9e-mediaembed="clyp" allowfullscreen="" loading="lazy" scrolling="no" src="https://clyp.it/'.htmlspecialchars($node->getAttribute('id'),2).'/widget" style="border:0;height:265px;max-width:900px;width:100%"></iframe>';break;case'CNBC':$this->out.='<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid='.htmlspecialchars($node->getAttribute('id'),2).'&amp;size=640_360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNN':$this->out.='<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//fave.api.cnn.io/v1/fav/?video='.htmlspecialchars($node->getAttribute('id'),2).'&amp;customer=cnn&amp;edition=international&amp;env=prod" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNNMONEY':$this->out.='<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/'.htmlspecialchars($node->getAttribute('id'),2).'&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CODEPEN':$this->out.='<iframe data-s9e-mediaembed="codepen" allowfullscreen="" loading="lazy" scrolling="no" src="https://codepen.io/'.htmlspecialchars($node->getAttribute('user'),2).'/embed/'.htmlspecialchars($node->getAttribute('id'),2).'?height=400&amp;default-tab=html,result" style="border:0;height:400px;width:100%"></iframe>';break;case'COMEDYCENTRAL':$this->out.='<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//media.mtvnservices.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'COUB':$this->out.='<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//coub.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'DAILYMOTION':$this->out.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.dailymotion.com/embed/video/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('t'))$this->out.='?start='.htmlspecialchars($node->getAttribute('t'),2);$this->out.='"></iframe></span></span>';break;case'DEMOCRACYNOW':$this->out.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((strpos($node->getAttribute('id'),'/headlines')!==false))$this->out.='headlines/'.htmlspecialchars(strstr($node->getAttribute('id'),'/headlines',true),2);elseif((strpos($node->getAttribute('id'),'2')===0))$this->out.='story/'.htmlspecialchars($node->getAttribute('id'),2);elseif((strpos($node->getAttribute('id'),'shows/')===0))$this->out.='show/'.htmlspecialchars(substr(strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></span></span>';break;case'DUMPERT':$this->out.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.dumpert.nl/embed/'.htmlspecialchars(strtr($node->getAttribute('id'),'/','_'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'EIGHTTRACKS':$this->out.='<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//8tracks.com/mixes/'.htmlspecialchars($node->getAttribute('id'),2).'/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ESPN':$this->out.='<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.espn.com/core/video/iframe?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FACEBOOK':$this->out.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/facebook.min.html#'.htmlspecialchars($node->getAttribute('type').$node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'FALSTAD':$this->out.='<iframe data-s9e-mediaembed="falstad" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;max-height:90vh;width:100%" src="https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c';if($node->hasAttribute('cct'))$this->out.='ct='.htmlspecialchars($node->getAttribute('cct'),2);else$this->out.='tz='.htmlspecialchars($node->getAttribute('ctz'),2);$this->out.='"></iframe>';break;case'FLICKR':$this->out.='<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.flickr.com/photos/_/'.htmlspecialchars($node->getAttribute('id'),2).'/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FOXNEWS':$this->out.='<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FUNNYORDIE':$this->out.='<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.funnyordie.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GAMESPOT':$this->out.='<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gamespot.com/videos/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GAMETRAILERS':$this->out.='<span data-s9e-mediaembed="gametrailers" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if((strpos($node->getAttribute('id'),'mgid:')===0))$this->out.='media.mtvnservices.com/embed/'.htmlspecialchars($node->getAttribute('id'),2);else$this->out.='embed.gametrailers.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'?embed=1&amp;suppressBumper=1';$this->out.='"></iframe></span></span>';break;case'GETTY':$this->out.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.gettyimages.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'?et='.htmlspecialchars($node->getAttribute('et'),2).'&amp;tld=com&amp;sig='.htmlspecialchars($node->getAttribute('sig'),2).'&amp;caption=false&amp;ver=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GFYCAT':$this->out.='<span data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*($node->getAttribute('height')+44)/$node->getAttribute('width'),2).'%;padding-bottom:calc('.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'% + 44px)';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gfycat.com/ifr/'.htmlspecialchars($node->getAttribute('id'),2).'?hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$this->out.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gifs.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIPHY':$this->out.='<span data-s9e-mediaembed="giphy" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//giphy.com/embed/'.htmlspecialchars($node->getAttribute('id'),2);if($node->getAttribute('type')==='video')$this->out.='/video';$this->out.='"></iframe></span></span>';break;case'GIST':$this->out.='<iframe data-s9e-mediaembed="gist" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="" src="https://s9e.github.io/iframe/2/gist.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;width:100%"></iframe>';break;case'GLOBALNEWS':$this->out.='<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//globalnews.ca/video/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOFUNDME':$this->out.='<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:349px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:118.911175%;padding-bottom:calc(59.312321% + 208px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund='.htmlspecialchars($node->getAttribute('id'),2).'&amp;image=1&amp;coinfo=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEDRIVE':$this->out.='<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//drive.google.com/file/d/'.htmlspecialchars($node->getAttribute('id'),2).'/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEPLUS':$this->out.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/2/googleplus.min.html#';if($node->hasAttribute('oid'))$this->out.=htmlspecialchars($node->getAttribute('oid'),2);else$this->out.='+'.htmlspecialchars($node->getAttribute('name'),2);$this->out.='/posts/'.htmlspecialchars($node->getAttribute('pid'),2).'"></iframe>';break;case'GOOGLESHEETS':if($node->getAttribute('type')==='chart')$this->out.='<span data-s9e-mediaembed="googlesheets" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.htmlspecialchars($node->getAttribute('id'),2).'/pubchart?oid='.htmlspecialchars($node->getAttribute('oid'),2).'&amp;format=interactive" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else{$this->out.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;resize:vertical;width:100%" src="https://docs.google.com/spreadsheets/d/'.htmlspecialchars($node->getAttribute('id'),2).'/p';if((strpos($node->getAttribute('id'),'e/')===0))$this->out.='ubhtml?widget=true&amp;headers=false';else$this->out.='review';$this->out.='#gid='.htmlspecialchars($node->getAttribute('gid'),2).'"></iframe>';}break;case'HUDL':$this->out.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.hudl.com/embed/';if($node->hasAttribute('id'))$this->out.='video/'.htmlspecialchars($node->getAttribute('id'),2);else$this->out.='athlete/'.htmlspecialchars($node->getAttribute('athlete'),2).'/highlights/'.htmlspecialchars($node->getAttribute('highlight'),2);$this->out.='"></iframe></span></span>';break;case'HULU':$this->out.='<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://secure.hulu.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IGN':$this->out.='<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMDB':$this->out.='<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.imdb.com/video/imdb/vi'.htmlspecialchars($node->getAttribute('id'),2).'/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMGUR':$this->out.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){var d=e.data.split(\' \');style.height=d[0]+\'px\';style.width=d[1]+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:400px;max-width:100%;width:542px" src="https://s9e.github.io/iframe/2/imgur.min.html#';if($node->getAttribute('type')==='album')$this->out.='a/';$this->out.=htmlspecialchars($node->getAttribute('id'),2).'"></iframe>';break;case'INDIEGOGO':$this->out.='<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.indiegogo.com/project/'.htmlspecialchars($node->getAttribute('id'),2).'/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'INSTAGRAM':$this->out.='<iframe data-s9e-mediaembed="instagram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/instagram.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="background:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"></iframe>';break;case'INTERNETARCHIVE':if((strpos($node->getAttribute('id'),'playlist=1')!==false))$this->out.='<iframe data-s9e-mediaembed="internetarchive" allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'&amp;list_height=150" style="border:0;height:170px;max-width:640px;width:100%"></iframe>';else{$this->out.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';}break;case'IZLESENE':$this->out.='<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.izlesene.com/embedplayer/'.htmlspecialchars($node->getAttribute('id'),2).'?autoplay=0" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'JSFIDDLE':$this->out.='<iframe data-s9e-mediaembed="jsfiddle" allowfullscreen="" loading="lazy" scrolling="no" src="//jsfiddle.net/'.htmlspecialchars($node->getAttribute('id'),2).'/'.htmlspecialchars($node->getAttribute('revision'),2).'/embedded/'.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'/" style="border:0;height:400px;width:100%"></iframe>';break;case'JWPLATFORM':$this->out.='<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//content.jwplatform.com/players/'.htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KALTURA':$this->out.='<span data-s9e-mediaembed="kaltura" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.875%;padding-bottom:calc(56.25% + 36px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://cdnapisec.kaltura.com/p/'.htmlspecialchars($node->getAttribute('partner_id'),2).'/sp/';if($node->hasAttribute('sp'))$this->out.=htmlspecialchars($node->getAttribute('sp'),2);else$this->out.=htmlspecialchars($node->getAttribute('partner_id'),2).'00';$this->out.='/embedIframeJs/uiconf_id/'.htmlspecialchars($node->getAttribute('uiconf_id'),2).'/partner_id/'.htmlspecialchars($node->getAttribute('partner_id'),2).'?iframeembed=true&amp;entry_id='.htmlspecialchars($node->getAttribute('entry_id'),2).'"></iframe></span></span>';break;case'KHL':$this->out.='<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.khl.ru/iframe/feed/start/'.htmlspecialchars($node->getAttribute('id'),2).'?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KICKSTARTER':$this->out.='<span data-s9e-mediaembed="kickstarter"';if($node->hasAttribute('video'))$this->out.=' style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.htmlspecialchars($node->getAttribute('id'),2).'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$this->out.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.htmlspecialchars($node->getAttribute('id'),2).'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$this->out.='</span>';break;case'LIBSYN':$this->out.='<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" loading="lazy" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/'.htmlspecialchars($node->getAttribute('id'),2).'/thumbnail/no" style="border:0;height:90px;max-width:900px;width:100%"></iframe>';break;case'LIVELEAK':$this->out.='<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.liveleak.com/e/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'LIVESTREAM':$this->out.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->hasAttribute('clip_id'))$this->out.='cdn.livestream.com/embed/'.htmlspecialchars($node->getAttribute('channel'),2).'?layout=4&amp;autoplay=false&amp;clip='.htmlspecialchars($node->getAttribute('clip_id'),2);else{$this->out.='livestream.com/accounts/'.htmlspecialchars($node->getAttribute('account_id'),2).'/events/'.htmlspecialchars($node->getAttribute('event_id'),2);if($node->hasAttribute('video_id'))$this->out.='/videos/'.htmlspecialchars($node->getAttribute('video_id'),2);$this->out.='/player?autoPlay=false';}$this->out.='"></iframe></span></span>';break;case'MAILRU':$this->out.='<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://my.mail.ru/video/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MEDIUM':$this->out.='<iframe data-s9e-mediaembed="medium" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/medium.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:316px;max-width:900px;width:100%"></iframe>';break;case'MEGAPHONE':$this->out.='<iframe data-s9e-mediaembed="megaphone" allowfullscreen="" loading="lazy" scrolling="no" src="https://player.megaphone.fm/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:200px;max-width:900px;width:100%"></iframe>';break;case'METACAFE':$this->out.='<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.metacafe.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MIXCLOUD':$this->out.='<span data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F'.htmlspecialchars($node->getAttribute('id'),2).'%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MIXER':$this->out.='<span data-s9e-mediaembed="mixer" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://mixer.com/embed/player/'.htmlspecialchars($node->getAttribute('channel'),2);if($node->hasAttribute('vod'))$this->out.='?vod='.htmlspecialchars($node->getAttribute('vod'),2);$this->out.='"></iframe></span></span>';break;case'MLB':$this->out.='<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mlb.com/video/share/c-'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MRCTV':$this->out.='<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mrctv.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MSNBC':$this->out.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($node->getAttribute('id'),'_')!==false))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:68.75%;padding-bottom:calc(56.25% + 80px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid=';else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.msnbc.com/msnbc/embedded-video/';$this->out.=htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$this->out.='</span></span>';break;case'NATGEOCHANNEL':$this->out.='<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//channel.nationalgeographic.com/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NATGEOVIDEO':$this->out.='<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCNEWS':$this->out.='<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.nbcnews.com/widget/video-embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCSPORTS':$this->out.='<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/'.htmlspecialchars($node->getAttribute('id'),2).'?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NHL':$this->out.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if($node->hasAttribute('t'))$this->out.='/t-'.htmlspecialchars($node->getAttribute('t'),2);if($node->hasAttribute('c'))$this->out.='/c-'.htmlspecialchars($node->getAttribute('c'),2);$this->out.='?autostart=false"></iframe></span></span>';break;case'NPR':$this->out.='<iframe data-s9e-mediaembed="npr" allowfullscreen="" loading="lazy" scrolling="no" src="//www.npr.org/player/embed/'.htmlspecialchars($node->getAttribute('i'),2).'/'.htmlspecialchars($node->getAttribute('m'),2).'" style="border:0;height:228px;max-width:800px;width:100%"></iframe>';break;case'NYTIMES':$this->out.='<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ORFIUM':$this->out.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.orfium.com/embedded/';if($node->hasAttribute('album_id'))$this->out.='album/'.htmlspecialchars($node->getAttribute('album_id'),2);elseif($node->hasAttribute('playlist_id'))$this->out.='playlist/'.htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('set_id'))$this->out.='live-set/'.htmlspecialchars($node->getAttribute('set_id'),2);else$this->out.='track/'.htmlspecialchars($node->getAttribute('track_id'),2);$this->out.='" style="border:0;height:';if($node->hasAttribute('album_id'))$this->out.='550';else$this->out.='275';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'PASTEBIN':$this->out.='<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" loading="lazy" scrolling="" src="//pastebin.com/embed_iframe.php?i='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;resize:vertical;width:100%"></iframe>';break;case'PINTEREST':$this->out.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/pinterest.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:';if((strpos($node->getAttribute('id'),'/')!==false))$this->out.='730';else$this->out.='345';$this->out.='px;width:100%"></iframe>';break;case'PODBEAN':$this->out.='<iframe data-s9e-mediaembed="podbean" allowfullscreen="" loading="lazy" scrolling="no" src="//www.podbean.com/media/player/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100px;max-width:900px;width:100%"></iframe>';break;case'PREZI':$this->out.='<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//prezi.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'REDDIT':$this->out.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/reddit.min.html#'.htmlspecialchars($node->getAttribute('id').$node->getAttribute('path'),2).'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'RUMBLE':$this->out.='<span data-s9e-mediaembed="rumble" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://rumble.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'RUTUBE':$this->out.='<span data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:720px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//rutube.ru/play/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SCRIBD':$this->out.='<iframe data-s9e-mediaembed="scribd" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.scribd.com/embeds/'.htmlspecialchars($node->getAttribute('id'),2).'/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';break;case'SENDVID':$this->out.='<span data-s9e-mediaembed="sendvid" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//sendvid.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SLIDESHARE':$this->out.='<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:83.372365%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SOUNDCLOUD':$this->out.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" loading="lazy" scrolling="no" src="https://w.soundcloud.com/player/?url=';if($node->hasAttribute('playlist_id'))$this->out.='https%3A//api.soundcloud.com/playlists/'.htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('track_id'))$this->out.='https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($node->getAttribute('track_id'),2).'&amp;secret_token='.htmlspecialchars($node->getAttribute('secret_token'),2);else{if((strpos($node->getAttribute('id'),'://')===false))$this->out.='https%3A//soundcloud.com/';$this->out.=htmlspecialchars($node->getAttribute('id'),2);}$this->out.='" style="border:0;height:';if($node->hasAttribute('playlist_id')||(strpos($node->getAttribute('id'),'/sets/')!==false))$this->out.='450';else$this->out.='166';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'SPORCLE':$this->out.='<iframe data-s9e-mediaembed="sporcle" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/sporcle.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:535px;max-width:820px;width:100%"></iframe>';break;case'SPORTSNET':$this->out.='<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://images.rogersdigitalmedia.com/video_service.php?videoId='.htmlspecialchars($node->getAttribute('id'),2).'&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SPOTIFY':if((strpos($node->getAttribute('id'),'episode/')===0)||(strpos($node->getAttribute('id'),'show/')===0))$this->out.='<iframe data-s9e-mediaembed="spotify" allow="encrypted-media" allowfullscreen="" loading="lazy" scrolling="no" src="https://open.spotify.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:152px;max-width:900px;width:100%"></iframe>';else$this->out.='<span data-s9e-mediaembed="spotify" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:125%;padding-bottom:calc(100% + 80px)"><iframe allow="encrypted-media" allowfullscreen="" loading="lazy" scrolling="no" src="https://open.spotify.com/embed/'.htmlspecialchars(strtr($node->getAttribute('id'),':','/').$node->getAttribute('path'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SPREAKER':$this->out.='<iframe data-s9e-mediaembed="spreaker" allowfullscreen="" loading="lazy" scrolling="no" src="https://widget.spreaker.com/player?episode_id='.htmlspecialchars($node->getAttribute('episode_id'),2).'&amp;show_id='.htmlspecialchars($node->getAttribute('show_id'),2).'&amp;theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:'.htmlspecialchars(400-200*$node->hasAttribute('episode_id'),2).'px;max-width:900px;width:100%"></iframe>';break;case'STEAMSTORE':$this->out.='<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" loading="lazy" scrolling="no" src="//store.steampowered.com/widget/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:190px;max-width:900px;width:100%"></iframe>';break;case'STITCHER':$this->out.='<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.stitcher.com/embed/'.htmlspecialchars($node->getAttribute('fid'),2).'/'.htmlspecialchars($node->getAttribute('eid'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'STRAWPOLL':$this->out.='<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="" src="//www.strawpoll.me/embed_1/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMABLE':$this->out.='<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//streamable.com/e/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMJA':$this->out.='<span data-s9e-mediaembed="streamja" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://streamja.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TEAMCOCO':$this->out.='<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//teamcoco.com/embed/v/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TED':$this->out.='<span data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.htmlspecialchars($node->getAttribute('id'),2);if((strpos($node->getAttribute('id'),'.html')===false))$this->out.='.html';$this->out.='"></iframe></span></span>';break;case'TELEGRAM':$this->out.='<iframe data-s9e-mediaembed="telegram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/telegram.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:96px;max-width:500px;width:100%"></iframe>';break;case'THEATLANTIC':$this->out.='<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theatlantic.com/video/iframe/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEGUARDIAN':$this->out.='<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.theguardian.com/embed/video/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEONION':$this->out.='<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theonion.com/video_embed/?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TIKTOK':$this->out.='<span data-s9e-mediaembed="tiktok" style="display:inline-block;width:100%;max-width:340px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:205.882353%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.tiktok.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TMZ':$this->out.='<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TRADINGVIEW':$this->out.='<iframe data-s9e-mediaembed="tradingview" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:400px;width:100%" src="https://s.tradingview.com/';if($node->hasAttribute('symbol'))$this->out.='widgetembed/?interval=D&amp;symbol='.htmlspecialchars(strtr($node->getAttribute('symbol'),'-',':'),2);else$this->out.='embed/'.htmlspecialchars($node->getAttribute('chart'),2);$this->out.='"></iframe>';break;case'TRAILERADDICT':$this->out.='<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//v.traileraddict.com/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TRENDINGVIEWS':$this->out.='<span data-s9e-mediaembed="trendingviews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://trendingviews.co/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TUMBLR':$this->out.='<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tumblr.min.html#'.htmlspecialchars($node->getAttribute('key'),2).'/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;max-width:520px;width:100%"></iframe>';break;case'TWENTYFOURSEVENSPORTS':if($node->hasAttribute('video_id'))$this->out.='<span data-s9e-mediaembed="twentyfoursevensports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbssports.com/video/player/embed?args=player_id%3D'.htmlspecialchars($node->getAttribute('video_id'),2).'%26channel%3Dmobilevideo%26pcid%3D'.htmlspecialchars($node->getAttribute('video_id'),2).'%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else$this->out.='<iframe data-s9e-mediaembed="twentyfoursevensports" allowfullscreen="" loading="lazy" onload="window.addEventListener(\'message\',function(e){if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\'px\'})" scrolling="no" src="https://247sports.com/PlayerSport/'.htmlspecialchars($node->getAttribute('player_id'),2).'/Embed/" style="border:0;height:200px;max-width:600px;width:100%"></iframe>';break;case'TWITCH':$this->out.='<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" onload="contentWindow.postMessage(\'\',\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/2/twitch.min.html#channel='.htmlspecialchars($node->getAttribute('channel'),2).';clip_id='.htmlspecialchars($node->getAttribute('clip_id'),2).';t='.htmlspecialchars($node->getAttribute('t'),2).';video_id='.htmlspecialchars($node->getAttribute('video_id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TWITTER':$this->out.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/twitter.min.html#'.htmlspecialchars($node->getAttribute('id').$this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:250px;max-width:550px;width:100%"></iframe>';break;case'USTREAM':$this->out.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if($node->hasAttribute('vid'))$this->out.='recorded/'.htmlspecialchars($node->getAttribute('vid'),2);else$this->out.=htmlspecialchars($node->getAttribute('cid'),2);$this->out.='?html5ui"></iframe></span></span>';break;case'VBOX7':$this->out.='<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vbox7.com/emb/external.php?vid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VEOH':$this->out.='<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v'.htmlspecialchars($node->getAttribute('id'),2).'&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'VEVO':$this->out.='<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.vevo.com/?isrc='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDEODETECTIVE':$this->out.='<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIMEO':$this->out.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//player.vimeo.com/video/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('t'))$this->out.='#t='.htmlspecialchars($node->getAttribute('t'),2);$this->out.='"></iframe></span></span>';break;case'VINE':$this->out.='<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vine.co/v/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VK':$this->out.='<span data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vk.com/video_ext.php?oid='.htmlspecialchars($node->getAttribute('oid'),2).'&amp;id='.htmlspecialchars($node->getAttribute('vid'),2).'&amp;hash='.htmlspecialchars($node->getAttribute('hash'),2).'&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VOCAROO':$this->out.='<span data-s9e-mediaembed="vocaroo"';if((strpos($node->getAttribute('id'),'s0')===0)||(strpos($node->getAttribute('id'),'s1')===0))$this->out.=' style="display:inline-block;width:100%;max-width:148px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:29.72973%"><object data="//vocaroo.com/player.swf?playMediaID='.htmlspecialchars($node->getAttribute('id'),2).'&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span>';else$this->out.=' style="display:inline-block;width:100%;max-width:300px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:20%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vocaroo.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$this->out.='</span>';break;case'VOX':$this->out.='<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WASHINGTONPOST':$this->out.='<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.washingtonpost.com/video/c/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WISTIA':$this->out.='<span data-s9e-mediaembed="wistia" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://fast.wistia.net/embed/iframe/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSHH':$this->out.='<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.worldstarhiphop.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSJ':$this->out.='<span data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXCLIPS':$this->out.='<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gameclips.io/'.htmlspecialchars($node->getAttribute('user'),2).'/'.htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXDVR':$this->out.='<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gamerdvr.com/gamer/'.htmlspecialchars($node->getAttribute('user'),2).'/video/'.htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUKU':$this->out.='<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.youku.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUTUBE':$this->out.='<span data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.htmlspecialchars($node->getAttribute('id'),2).'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube.com/embed/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('list'))$this->out.='?list='.htmlspecialchars($node->getAttribute('list'),2);if($node->hasAttribute('t')){if($node->hasAttribute('list'))$this->out.='&amp;';else$this->out.='?';$this->out.='start='.htmlspecialchars($node->getAttribute('t'),2);}$this->out.='"></iframe></span></span>';break;case'br':$this->out.='<br>';break;case'e':case'i':case's':break;case'p':$this->out.='<p>';$this->at($node);$this->out.='</p>';break;default:$this->at($node);}
	}
	/** {@inheritdoc} */
	public $enableQuickRenderer=true;
	/** {@inheritdoc} */
	protected $static=[];
	/** {@inheritdoc} */
	protected $dynamic=['ABCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//abcnews.go.com/video/embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ANCHOR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="anchor" allowfullscreen="" loading="lazy" scrolling="no" src="//anchor.fm/embed/episodes/x-$1" style="border:0;height:102px;max-width:700px;width:100%"></iframe>'],'AUDIOBOOM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" loading="lazy" scrolling="no" src="//audioboom.com/posts/$1/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>'],'BITCHUTE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bitchute" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.bitchute.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BLEACHERREPORT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//bleacherreport.com/video_embed?id=$1&amp;library=video-cms" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BREAK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="break" style="display:inline-block;width:100%;max-width:464px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:60.344828%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//break.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CASTOS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="castos" allowfullscreen="" loading="lazy" scrolling="no" src="https://player.castos.com/player/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'CLYP'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="clyp" allowfullscreen="" loading="lazy" scrolling="no" src="https://clyp.it/$1/widget" style="border:0;height:265px;max-width:900px;width:100%"></iframe>'],'CNBC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid=$1&amp;size=640_360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//fave.api.cnn.io/v1/fav/?video=$1&amp;customer=cnn&amp;edition=international&amp;env=prod" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNNMONEY'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/$1&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CODEPEN'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="codepen" allowfullscreen="" loading="lazy" scrolling="no" src="https://codepen.io/$2/embed/$1?height=400&amp;default-tab=html,result" style="border:0;height:400px;width:100%"></iframe>'],'COMEDYCENTRAL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//media.mtvnservices.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COUB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//coub.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'EIGHTTRACKS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//8tracks.com/mixes/$1/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ESPN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.espn.com/core/video/iframe?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FLICKR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.flickr.com/photos/_/$1/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FOXNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FUNNYORDIE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.funnyordie.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GAMESPOT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gamespot.com/videos/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GIST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="gist" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="" src="https://s9e.github.io/iframe/2/gist.min.html#$1" style="border:0;height:180px;width:100%"></iframe>'],'GLOBALNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//globalnews.ca/video/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOFUNDME'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:349px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:118.911175%;padding-bottom:calc(59.312321% + 208px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund=$1&amp;image=1&amp;coinfo=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOOGLEDRIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//drive.google.com/file/d/$1/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'HULU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://secure.hulu.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IGN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IMDB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.imdb.com/video/imdb/vi$1/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'INDIEGOGO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.indiegogo.com/project/$1/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'INSTAGRAM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="instagram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/instagram.min.html#$1" style="background:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"></iframe>'],'IZLESENE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.izlesene.com/embedplayer/$1?autoplay=0" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'JWPLATFORM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//content.jwplatform.com/players/$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'KHL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.khl.ru/iframe/feed/start/$1?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'LIBSYN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" loading="lazy" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/$1/thumbnail/no" style="border:0;height:90px;max-width:900px;width:100%"></iframe>'],'LIVELEAK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.liveleak.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MAILRU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://my.mail.ru/video/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MEDIUM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="medium" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/medium.min.html#$1" style="border:0;height:316px;max-width:900px;width:100%"></iframe>'],'MEGAPHONE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="megaphone" allowfullscreen="" loading="lazy" scrolling="no" src="https://player.megaphone.fm/$1" style="border:0;height:200px;max-width:900px;width:100%"></iframe>'],'METACAFE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.metacafe.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MIXCLOUD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F$1%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MLB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mlb.com/video/share/c-$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MRCTV'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mrctv.org/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOCHANNEL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//channel.nationalgeographic.com/$1/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOVIDEO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.nbcnews.com/widget/video-embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCSPORTS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/$1?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NPR'=>['(^[^ ]+(?> (?![im]=)[^=]+="[^"]*")*(?> i="([^"]*)")?(?> (?!m=)[^=]+="[^"]*")*(?> m="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="npr" allowfullscreen="" loading="lazy" scrolling="no" src="//www.npr.org/player/embed/$1/$2" style="border:0;height:228px;max-width:800px;width:100%"></iframe>'],'NYTIMES'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'PASTEBIN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" loading="lazy" scrolling="" src="//pastebin.com/embed_iframe.php?i=$1" style="border:0;height:300px;resize:vertical;width:100%"></iframe>'],'PODBEAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="podbean" allowfullscreen="" loading="lazy" scrolling="no" src="//www.podbean.com/media/player/$1" style="border:0;height:100px;max-width:900px;width:100%"></iframe>'],'PREZI'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//prezi.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'RUMBLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="rumble" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://rumble.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'RUTUBE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:720px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//rutube.ru/play/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SCRIBD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="scribd" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.scribd.com/embeds/$1/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'],'SENDVID'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="sendvid" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//sendvid.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SLIDESHARE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:83.372365%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SPORCLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="sporcle" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/sporcle.min.html#$1" style="border:0;height:535px;max-width:820px;width:100%"></iframe>'],'SPORTSNET'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://images.rogersdigitalmedia.com/video_service.php?videoId=$1&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STEAMSTORE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" loading="lazy" scrolling="no" src="//store.steampowered.com/widget/$1" style="border:0;height:190px;max-width:900px;width:100%"></iframe>'],'STITCHER'=>['(^[^ ]+(?> (?![ef]id=)[^=]+="[^"]*")*(?> eid="([^"]*)")?(?> (?!fid=)[^=]+="[^"]*")*(?> fid="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.stitcher.com/embed/$2/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'STRAWPOLL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="" src="//www.strawpoll.me/embed_1/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMABLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//streamable.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMJA'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamja" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://streamja.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TEAMCOCO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//teamcoco.com/embed/v/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TELEGRAM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="telegram" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/telegram.min.html#$1" style="border:0;height:96px;max-width:500px;width:100%"></iframe>'],'THEATLANTIC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theatlantic.com/video/iframe/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEGUARDIAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.theguardian.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEONION'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theonion.com/video_embed/?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TIKTOK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="tiktok" style="display:inline-block;width:100%;max-width:340px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:205.882353%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.tiktok.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TMZ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TRAILERADDICT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//v.traileraddict.com/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TRENDINGVIEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="trendingviews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://trendingviews.co/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TUMBLR'=>['(^[^ ]+(?> (?!(?:id|key)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!key=)[^=]+="[^"]*")*(?> key="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tumblr.min.html#$2/$1" style="border:0;height:300px;max-width:520px;width:100%"></iframe>'],'TWITCH'=>['(^[^ ]+(?> (?!(?:c(?:hannel|lip_id)|t|video_id)=)[^=]+="[^"]*")*(?> channel="([^"]*)")?(?> (?!(?:clip_id|t|video_id)=)[^=]+="[^"]*")*(?> clip_id="([^"]*)")?(?> (?!(?:t|video_id)=)[^=]+="[^"]*")*(?> t="([^"]*)")?(?> (?!video_id=)[^=]+="[^"]*")*(?> video_id="([^"]*)")?.*)s','<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" onload="contentWindow.postMessage(\'\',\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/2/twitch.min.html#channel=$1;clip_id=$2;t=$3;video_id=$4" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VBOX7'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vbox7.com/emb/external.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VEOH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v$1&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'VEVO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.vevo.com/?isrc=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIDEODETECTIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VINE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vine.co/v/$1/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VK'=>['(^[^ ]+(?> (?!(?:[ov]id|hash)=)[^=]+="[^"]*")*(?> hash="([^"]*)")?(?> (?![ov]id=)[^=]+="[^"]*")*(?> oid="([^"]*)")?(?> (?!vid=)[^=]+="[^"]*")*(?> vid="([^"]*)")?.*)s','<span data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vk.com/video_ext.php?oid=$2&amp;id=$3&amp;hash=$1&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VOX'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WASHINGTONPOST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.washingtonpost.com/video/c/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WISTIA'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wistia" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://fast.wistia.net/embed/iframe/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WSHH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.worldstarhiphop.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WSJ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXCLIPS'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gameclips.io/$2/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXDVR'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gamerdvr.com/gamer/$2/video/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'YOUKU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.youku.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>']];
	/** {@inheritdoc} */
	protected $quickRegexp='(<(?:(?!/)((?:A(?:BCNEWS|MAZON|NCHOR|UDIO(?:BOOM|MACK))|B(?:ANDCAMP|BCNEWS|ITCHUTE|LEACHERREPORT|R(?:EAK|IGHTCOVE))|C(?:ASTOS|BSNEWS|LYP|N(?:BC|N(?:MONEY)?)|O(?:DEPEN|MEDYCENTRAL|UB))|D(?:AILYMOTION|EMOCRACYNOW|UMPERT)|E(?:IGHTTRACKS|SPN)|F(?:A(?:CEBOOK|LSTAD)|LICKR|OXNEWS|UNNYORDIE)|G(?:AME(?:SPOT|TRAILERS)|ETTY|FYCAT|I(?:FS|PHY|ST)|LOBALNEWS|O(?:FUNDME|OGLE(?:DRIVE|PLUS|SHEETS)))|HU(?:DL|LU)|I(?:GN|M(?:DB|GUR)|N(?:DIEGOGO|STAGRAM|TERNETARCHIVE)|ZLESENE)|J(?:SFIDDLE|WPLATFORM)|K(?:ALTURA|HL|ICKSTARTER)|LI(?:BSYN|VE(?:LEAK|STREAM))|M(?:AILRU|E(?:DIUM|GAPHONE|TACAFE)|IX(?:CLOUD|ER)|LB|RCTV|SNBC)|N(?:ATGEO(?:CHANNEL|VIDEO)|BC(?:NEW|SPORT)S|HL|PR|YTIMES)|ORFIUM|P(?:ASTEBIN|INTEREST|ODBEAN|REZI)|R(?:EDDIT|U(?:MBL|TUB)E)|S(?:CRIBD|ENDVID|LIDESHARE|OUNDCLOUD|P(?:O(?:R(?:CLE|TSNET)|TIFY)|REAKER)|T(?:EAMSTORE|ITCHER|R(?:AWPOLL|EAM(?:ABLE|JA))))|T(?:E(?:AMCOCO|D|LEGRAM)|HE(?:ATLANTIC|GUARDIAN|ONION)|IKTOK|MZ|R(?:A(?:DINGVIEW|ILERADDICT)|ENDINGVIEWS)|UMBLR|W(?:ENTYFOURSEVENSPORTS|IT(?:CH|TER)))|USTREAM|V(?:BOX7|E(?:OH|VO)|I(?:DEODETECTIVE|MEO|NE)|K|O(?:CAROO|X))|W(?:ASHINGTONPOST|ISTIA|S(?:HH|J))|XBOX(?:CLIPS|DVR)|YOU(?:KU|TUBE)))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s';
	/** {@inheritdoc} */
	protected function renderQuickTemplate($id, $xml)
	{
		$attributes=$this->matchAttributes($xml);
		$html='';switch($id){case'AMAZON':$attributes+=['tld'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://www.amazon.com/favicon.ico) center no-repeat;border:0;height:100%;left:0;position:absolute;width:100%" src="//ws-';if($attributes['tld']==='jp')$html.='fe';elseif(isset($attributes['tld'])&&(strpos('desfrinituk',$attributes['tld'])!==false))$html.='eu';else$html.='na';$html.='.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=';switch(htmlspecialchars_decode($attributes['tld'])){case'ca':$html.='15&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);break;case'de':$html.='3&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);break;case'es':$html.='30&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);break;case'fr':$html.='8&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);break;case'in':$html.='31&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IN'],2);break;case'it':$html.='29&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);break;case'jp':$html.='9&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);break;case'uk':$html.='2&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);break;default:$html.='1&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);}$html.='&amp;asins='.$attributes['id'].'"></iframe></span></span>';break;case'AUDIOMACK':$attributes+=['mode'=>null,'artist'=>null,'title'=>null];$html.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" loading="lazy" scrolling="no"';if($attributes['mode']==='album'){$html.=' src="https://www.audiomack.com/embed/album/';if(isset($attributes['id']))$html.=$attributes['id'];else$html.=$attributes['artist'].'/'.$attributes['title'];$html.='" style="border:0;height:400px;max-width:900px;width:100%"';}else{$html.=' src="https://www.audiomack.com/embed/song/';if(isset($attributes['id']))$html.=$attributes['id'];else$html.=$attributes['artist'].'/'.$attributes['title'];$html.='" style="border:0;height:252px;max-width:900px;width:100%"';}$html.='></iframe>';break;case'BANDCAMP':$attributes+=['track_num'=>null,'track_id'=>null];$html.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if(isset($attributes['album_id'])){$html.='album='.$attributes['album_id'];if(isset($attributes['track_num']))$html.='/t='.$attributes['track_num'];}else$html.='track='.$attributes['track_id'];if($this->params['MEDIAEMBED_THEME']==='dark')$html.='/bgcol=333333/linkcol=0f91ff';$html.='"></iframe></span></span>';break;case'BBCNEWS':$attributes+=['playlist'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com/news/av/video-';if((strpos($attributes['playlist'],'/news/')===0))$html.=htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['playlist']),'/news/'),6),2);elseif((strpos($attributes['id'],'/')!==false))$html.=htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['id']),'/'),1),2);else$html.=$attributes['id'];$html.='/embed"></iframe></span></span>';break;case'BRIGHTCOVE':$attributes+=['bcpid'=>null,'bctid'=>null];$html.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://';if(isset($attributes['bckey']))$html.='link.brightcove.com/services/player/bcpid'.$attributes['bcpid'].'?bckey='.$attributes['bckey'].'&amp;bctid='.$attributes['bctid'].'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640';else$html.='players.brightcove.net/'.$attributes['bcpid'].'/default_default/index.html?videoId='.$attributes['bctid'];$html.='"></iframe></span></span>';break;case'CBSNEWS':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($attributes['id'],'-')!==false))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbsnews.com/embed/videos/'.$attributes['id'].'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';elseif(isset($attributes['pid']))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.$attributes['pid'].'"></object>';else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.$attributes['id'].'"></object>';$html.='</span></span>';break;case'DAILYMOTION':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.dailymotion.com/embed/video/'.$attributes['id'];if(isset($attributes['t']))$html.='?start='.$attributes['t'];$html.='"></iframe></span></span>';break;case'DEMOCRACYNOW':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((strpos($attributes['id'],'/headlines')!==false))$html.='headlines/'.htmlspecialchars(strstr(htmlspecialchars_decode($attributes['id']),'/headlines',true),2);elseif((strpos($attributes['id'],'2')===0))$html.='story/'.$attributes['id'];elseif((strpos($attributes['id'],'shows/')===0))$html.='show/'.htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['id']),'/'),1),2);else$html.=$attributes['id'];$html.='"></iframe></span></span>';break;case'DUMPERT':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.dumpert.nl/embed/'.strtr($attributes['id'],'/','_').'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FACEBOOK':$attributes+=['type'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/facebook.min.html#'.$attributes['type'].$attributes['id'].'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'FALSTAD':$attributes+=['ctz'=>null];$html.='<iframe data-s9e-mediaembed="falstad" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;max-height:90vh;width:100%" src="https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c';if(isset($attributes['cct']))$html.='ct='.$attributes['cct'];else$html.='tz='.$attributes['ctz'];$html.='"></iframe>';break;case'GAMETRAILERS':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="gametrailers" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if((strpos($attributes['id'],'mgid:')===0))$html.='media.mtvnservices.com/embed/'.$attributes['id'];else$html.='embed.gametrailers.com/embed/'.$attributes['id'].'?embed=1&amp;suppressBumper=1';$html.='"></iframe></span></span>';break;case'GETTY':$attributes+=['width'=>null,'height'=>null,'id'=>null,'et'=>null,'sig'=>null];$html.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.gettyimages.com/embed/'.$attributes['id'].'?et='.$attributes['et'].'&amp;tld=com&amp;sig='.$attributes['sig'].'&amp;caption=false&amp;ver=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GFYCAT':$attributes+=['width'=>null,'height'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.htmlspecialchars(100*($attributes['height']+44)/htmlspecialchars_decode($attributes['width']),2).'%;padding-bottom:calc('.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']),2).'% + 44px)';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gfycat.com/ifr/'.$attributes['id'].'?hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$attributes+=['width'=>null,'height'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gifs.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIPHY':$attributes+=['width'=>null,'height'=>null,'id'=>null,'type'=>null];$html.='<span data-s9e-mediaembed="giphy" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//giphy.com/embed/'.$attributes['id'];if($attributes['type']==='video')$html.='/video';$html.='"></iframe></span></span>';break;case'GOOGLEPLUS':$attributes+=['name'=>null,'pid'=>null];$html.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/2/googleplus.min.html#';if(isset($attributes['oid']))$html.=$attributes['oid'];else$html.='+'.$attributes['name'];$html.='/posts/'.$attributes['pid'].'"></iframe>';break;case'GOOGLESHEETS':$attributes+=['type'=>null,'id'=>null,'oid'=>null,'gid'=>null];if($attributes['type']==='chart')$html.='<span data-s9e-mediaembed="googlesheets" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.$attributes['id'].'/pubchart?oid='.$attributes['oid'].'&amp;format=interactive" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else{$html.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;resize:vertical;width:100%" src="https://docs.google.com/spreadsheets/d/'.$attributes['id'].'/p';if((strpos($attributes['id'],'e/')===0))$html.='ubhtml?widget=true&amp;headers=false';else$html.='review';$html.='#gid='.$attributes['gid'].'"></iframe>';}break;case'HUDL':$attributes+=['athlete'=>null,'highlight'=>null];$html.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.hudl.com/embed/';if(isset($attributes['id']))$html.='video/'.$attributes['id'];else$html.='athlete/'.$attributes['athlete'].'/highlights/'.$attributes['highlight'];$html.='"></iframe></span></span>';break;case'IMGUR':$attributes+=['type'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){var d=e.data.split(\' \');style.height=d[0]+\'px\';style.width=d[1]+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" style="border:0;height:400px;max-width:100%;width:542px" src="https://s9e.github.io/iframe/2/imgur.min.html#';if($attributes['type']==='album')$html.='a/';$html.=$attributes['id'].'"></iframe>';break;case'INTERNETARCHIVE':$attributes+=['id'=>null,'width'=>null,'height'=>null];if((strpos($attributes['id'],'playlist=1')!==false))$html.='<iframe data-s9e-mediaembed="internetarchive" allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'&amp;list_height=150" style="border:0;height:170px;max-width:640px;width:100%"></iframe>';else{$html.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';}break;case'JSFIDDLE':$attributes+=['id'=>null,'revision'=>null];$html.='<iframe data-s9e-mediaembed="jsfiddle" allowfullscreen="" loading="lazy" scrolling="no" src="//jsfiddle.net/'.$attributes['id'].'/'.$attributes['revision'].'/embedded/'.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'/" style="border:0;height:400px;width:100%"></iframe>';break;case'KALTURA':$attributes+=['partner_id'=>null,'uiconf_id'=>null,'entry_id'=>null];$html.='<span data-s9e-mediaembed="kaltura" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.875%;padding-bottom:calc(56.25% + 36px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://cdnapisec.kaltura.com/p/'.$attributes['partner_id'].'/sp/';if(isset($attributes['sp']))$html.=$attributes['sp'];else$html.=$attributes['partner_id'].'00';$html.='/embedIframeJs/uiconf_id/'.$attributes['uiconf_id'].'/partner_id/'.$attributes['partner_id'].'?iframeembed=true&amp;entry_id='.$attributes['entry_id'].'"></iframe></span></span>';break;case'KICKSTARTER':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="kickstarter"';if(isset($attributes['video']))$html.=' style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$html.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$html.='</span>';break;case'LIVESTREAM':$attributes+=['channel'=>null,'account_id'=>null,'event_id'=>null];$html.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if(isset($attributes['clip_id']))$html.='cdn.livestream.com/embed/'.$attributes['channel'].'?layout=4&amp;autoplay=false&amp;clip='.$attributes['clip_id'];else{$html.='livestream.com/accounts/'.$attributes['account_id'].'/events/'.$attributes['event_id'];if(isset($attributes['video_id']))$html.='/videos/'.$attributes['video_id'];$html.='/player?autoPlay=false';}$html.='"></iframe></span></span>';break;case'MIXER':$attributes+=['channel'=>null];$html.='<span data-s9e-mediaembed="mixer" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://mixer.com/embed/player/'.$attributes['channel'];if(isset($attributes['vod']))$html.='?vod='.$attributes['vod'];$html.='"></iframe></span></span>';break;case'MSNBC':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:640px"><span';if((strpos($attributes['id'],'_')!==false))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:68.75%;padding-bottom:calc(56.25% + 80px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid=';else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.msnbc.com/msnbc/embedded-video/';$html.=$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$html.='</span></span>';break;case'NHL':$html.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if(isset($attributes['t']))$html.='/t-'.$attributes['t'];if(isset($attributes['c']))$html.='/c-'.$attributes['c'];$html.='?autostart=false"></iframe></span></span>';break;case'ORFIUM':$attributes+=['track_id'=>null];$html.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.orfium.com/embedded/';if(isset($attributes['album_id']))$html.='album/'.$attributes['album_id'];elseif(isset($attributes['playlist_id']))$html.='playlist/'.$attributes['playlist_id'];elseif(isset($attributes['set_id']))$html.='live-set/'.$attributes['set_id'];else$html.='track/'.$attributes['track_id'];$html.='" style="border:0;height:';if(isset($attributes['album_id']))$html.='550';else$html.='275';$html.='px;max-width:900px;width:100%"></iframe>';break;case'PINTEREST':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/pinterest.min.html#'.$attributes['id'].'" style="border:0;height:360px;max-width:';if((strpos($attributes['id'],'/')!==false))$html.='730';else$html.='345';$html.='px;width:100%"></iframe>';break;case'REDDIT':$attributes+=['id'=>null,'path'=>null];$html.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/reddit.min.html#'.$attributes['id'].$attributes['path'].'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'SOUNDCLOUD':$attributes+=['secret_token'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" loading="lazy" scrolling="no" src="https://w.soundcloud.com/player/?url=';if(isset($attributes['playlist_id']))$html.='https%3A//api.soundcloud.com/playlists/'.$attributes['playlist_id'];elseif(isset($attributes['track_id']))$html.='https%3A//api.soundcloud.com/tracks/'.$attributes['track_id'].'&amp;secret_token='.$attributes['secret_token'];else{if((strpos($attributes['id'],'://')===false))$html.='https%3A//soundcloud.com/';$html.=$attributes['id'];}$html.='" style="border:0;height:';if(isset($attributes['playlist_id'])||(strpos($attributes['id'],'/sets/')!==false))$html.='450';else$html.='166';$html.='px;max-width:900px;width:100%"></iframe>';break;case'SPOTIFY':$attributes+=['id'=>null,'path'=>null];if((strpos($attributes['id'],'episode/')===0)||(strpos($attributes['id'],'show/')===0))$html.='<iframe data-s9e-mediaembed="spotify" allow="encrypted-media" allowfullscreen="" loading="lazy" scrolling="no" src="https://open.spotify.com/embed/'.$attributes['id'].'" style="border:0;height:152px;max-width:900px;width:100%"></iframe>';else$html.='<span data-s9e-mediaembed="spotify" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:125%;padding-bottom:calc(100% + 80px)"><iframe allow="encrypted-media" allowfullscreen="" loading="lazy" scrolling="no" src="https://open.spotify.com/embed/'.htmlspecialchars(strtr(htmlspecialchars_decode($attributes['id']),':','/').htmlspecialchars_decode($attributes['path']),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SPREAKER':$attributes+=['episode_id'=>null,'show_id'=>null];$html.='<iframe data-s9e-mediaembed="spreaker" allowfullscreen="" loading="lazy" scrolling="no" src="https://widget.spreaker.com/player?episode_id='.$attributes['episode_id'].'&amp;show_id='.$attributes['show_id'].'&amp;theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:'.htmlspecialchars(400-200*isset($attributes['episode_id']),2).'px;max-width:900px;width:100%"></iframe>';break;case'TED':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.$attributes['id'];if((strpos($attributes['id'],'.html')===false))$html.='.html';$html.='"></iframe></span></span>';break;case'TRADINGVIEW':$attributes+=['chart'=>null];$html.='<iframe data-s9e-mediaembed="tradingview" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:400px;width:100%" src="https://s.tradingview.com/';if(isset($attributes['symbol']))$html.='widgetembed/?interval=D&amp;symbol='.strtr($attributes['symbol'],'-',':');else$html.='embed/'.$attributes['chart'];$html.='"></iframe>';break;case'TWENTYFOURSEVENSPORTS':$attributes+=['player_id'=>null];if(isset($attributes['video_id']))$html.='<span data-s9e-mediaembed="twentyfoursevensports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbssports.com/video/player/embed?args=player_id%3D'.$attributes['video_id'].'%26channel%3Dmobilevideo%26pcid%3D'.$attributes['video_id'].'%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else$html.='<iframe data-s9e-mediaembed="twentyfoursevensports" allowfullscreen="" loading="lazy" onload="window.addEventListener(\'message\',function(e){if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\'px\'})" scrolling="no" src="https://247sports.com/PlayerSport/'.$attributes['player_id'].'/Embed/" style="border:0;height:200px;max-width:600px;width:100%"></iframe>';break;case'TWITTER':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" loading="lazy" onload="var c=new MessageChannel;c.port1.onmessage=function(e){style.height=e.data+\'px\'};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/twitter.min.html#'.htmlspecialchars(htmlspecialchars_decode($attributes['id']).$this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:250px;max-width:550px;width:100%"></iframe>';break;case'USTREAM':$attributes+=['cid'=>null];$html.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if(isset($attributes['vid']))$html.='recorded/'.$attributes['vid'];else$html.=$attributes['cid'];$html.='?html5ui"></iframe></span></span>';break;case'VIMEO':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//player.vimeo.com/video/'.$attributes['id'];if(isset($attributes['t']))$html.='#t='.$attributes['t'];$html.='"></iframe></span></span>';break;case'VOCAROO':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="vocaroo"';if((strpos($attributes['id'],'s0')===0)||(strpos($attributes['id'],'s1')===0))$html.=' style="display:inline-block;width:100%;max-width:148px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:29.72973%"><object data="//vocaroo.com/player.swf?playMediaID='.$attributes['id'].'&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span>';else$html.=' style="display:inline-block;width:100%;max-width:300px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:20%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vocaroo.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$html.='</span>';break;case'YOUTUBE':$attributes+=['id'=>null,'t'=>null];$html.='<span data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.$attributes['id'].'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube.com/embed/'.$attributes['id'];if(isset($attributes['list']))$html.='?list='.$attributes['list'];if(isset($attributes['t'])){if(isset($attributes['list']))$html.='&amp;';else$html.='?';$html.='start='.$attributes['t'];}$html.='"></iframe></span></span>';}

		return $html;
	}
}